{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: databaso.pas,v 1.15 2005/01/01 11:16:27 mw Exp $ }

{ DATABASE.PAS: Overlay-Teil }

{$I XPDEFINE.INC }
{$IFDEF BP }
  {$O+,F+}
{$ENDIF }

unit databaso;

interface

uses xpglobal,dos,typeform,datadef, fileio;


procedure dbCreate(const filename:dbFileName; flp:dbFLP);
procedure dbZAP(var dbp:DB);
procedure dbAppendField(const filename:string; feld:dbFeldTyp);
procedure dbDeleteField(const filename:string; feldname:dbFeldStr);
procedure dbKillXbase(const filename:dbFilename);
function  dbPack(const filename:string):boolean;


implementation

uses
{$IFDEF UnixFS }
  {$IFDEF Linux}
    xplinux,
  {$ELSE }
    {$FATAL Need chmod - look at xplinux for procedure SetAccess }
  {$ENDIF }
{$ENDIF }
  database,
  datadef1;



{===== Datenbank bearbeiten =========================================}

{ logischen Feld-Record in phys. Feld-Record kopieren }

procedure makefeld(var lfeld:dbFeldTyp; var fld:dbfeld);
begin
  fillchar(fld,sizeof(fld),0);
  with lfeld,fld do begin
    name:=UStr(fname);
    feldtyp:=ftyp;
    case ftyp of
      1,2,5 : feldsize:=fsize;
      3     : feldsize:=6;
      4     : feldsize:=4;
      6     : feldsize:=8;
    end;
    if (ftyp=2) or (ftyp=3) then begin
      nlen:=fnlen; nk:=fnk;
      end;
    end;
end;


{ .EB1-Datei anlegen }

procedure MakeXbase(filename:pathstr; var ehd:dbdheader; var f:file);
begin
  with ehd do begin
    fillchar(ehd,sizeof(ehd),0);
    magic:=eb_magic;
    hdsize:=256;
    assign(f,filename+dbExtExt);
    rewrite(f,1);
    if not iohandler then exit;
    blockwrite(f,ehd,256);
    close(f);
{$IFDEF UnixFS }
    SetAccess(filename+dbExtExt, taUserRW);
{$ENDIF }
    end;
end;


{ Datenbank anlegen                   }
{ INT_NR wird automatisch angelegt,   }
{ ist nicht in flp^.felder enthalten! }

procedure dbCreate(const filename:dbFileName; flp:dbFLP);
var hd    : dbheader;
    ehd   : dbdheader;
    f     : file;
    i     : integer;
    size  : word;
    fld   : dbFeld;
    xflag : boolean;
begin
  with hd do begin
    fillchar(hd,sizeof(hd),0);
    magic:=db_magic;
    nextinr:=0;     { der erste Satz bekommt dann Nr. 1 }
    felder:=flp^.felder;
    size:=5;    { Flagbyte + INT_NR }
    xflag:=false;
    for i:=1 to felder do begin
      if flp^.feld[i].ftyp=1 then inc(flp^.feld[i].fsize);
      case flp^.feld[i].ftyp of
        1,2,5 : inc(size,flp^.feld[i].fsize);
        3     : inc(size,6);  { Real }
        4     : inc(size,4);  { Datum }
        6     : begin
                  inc(size,8);  { externes Feld: Zeiger + Grsse }
                  xflag:=true;
                end;
      else
        error('ungltiger Feldtyp: '+strs(flp^.feld[i].ftyp));
      end;
    end;
    recsize:=size;
    hdsize:=sizeof(dbheader)+32*(felder+1);
    assign(f,filename+dbExt);
    rewrite(f,1);
    if not iohandler then exit;
    blockwrite(f,hd,sizeof(hd));
    for i:=0 to felder do begin
      if i=0 then with fld do begin
        fillchar(fld,sizeof(fld),0);
        name:='INT_NR'; feldtyp:=2; feldsize:=4; nlen:=11;
        end
      else
        makefeld(flp^.feld[i],fld);
      blockwrite(f,fld,sizeof(fld));
      end;
    close(f);
{$IFDEF UnixFS }
    SetAccess(filename+dbExt, taUserRW);	{ User Read/Write }
{$ENDIF }
    end;

  if xflag then
    MakeXbase(filename,ehd,f);

  assign(f,filename+dbIxExt);
  erase(f);
  if ioresult = 0 then ;
end;


procedure dbZAP(var dbp:DB);
begin
  with dp(dbp)^ do begin
{$IFDEF Debug }
    if dl then dbLog('DB zappen: '+fname);
{$ENDIF }
    with hd do begin
      recs:=0;                      { Header zurcksetzen }
      nextinr:=0;
      firstfree:=0;
      reccount:=0;
      Writehd(dbp);
{$IFDEF Debug }
      if dl then dbLog('   .DB1 krzen');
{$ENDIF }
      seek(f1,hdsize);
      truncate(f1);                 { Datei krzen }
      if xflag then begin
        seek(fe,0);                 { EB1-Header zurcksetzen }
        blockread(fe,dbdhd,sizeof(dbdhd));
        fillchar(dbdhd.freelist,sizeof(dbdhd.freelist),0);
        seek(fe,0);
        blockwrite(fe,dbdhd,sizeof(dbdhd));
{$IFDEF Debug }
        if dl then dbLog('   .EB1 krzen');
{$ENDIF }
        seek(fe,dbdhd.hdsize);      { EB1 krzen }
        truncate(fe);
        end;
      if flindex then begin
{$IFDEF Debug }
        if dl then dbLog('   .IX1 neu aufbauen');
{$ENDIF }
        close(fi);
        freemem(index,sizeof(ixfeld)*ixhd.indizes);
        erase(fi);
        OpenIndex(dbp);
        end;
      end;
    end;
  dbFlushClose(dbp);
  dbGoTop(dbp);
end;


{ Neues Feld in bestehender Datenbank anlegen }
{ Datenbank muss geschlossen sein             }
{ geht noch nicht bei ext. Feldern!           }

procedure dbAppendField(const filename:string; feld:dbFeldTyp);
var d       : DB;
    df      : dbfeld;
    i       : longint;
    newsize : word;
    irec    : dbIndexCRec;
begin
  dbOpen(d,filename,0);
  irec.df:=filename;
  with dp(d)^ do begin
    irec.command:=icOpenCWindow; ICP(irec);
    if feld.ftyp=1 then inc(feld.fsize);
    makefeld(feld,df);
    newsize:=hd.recsize+df.feldsize;
    freemem(recbuf,hd.recsize);
    getmem(recbuf,newsize);
    fillchar(recbuf^,newsize,0);

    for i:=hd.recs downto 1 do begin         { Felder konvertieren }
      irec.percent:=(100*(hd.recs-i+1) div hd.recs);
      irec.command:=icShowConvert;
      ICP(irec);
      seek(f1,hd.hdsize+(i-1)*hd.recsize);
      blockread(f1,recbuf^,hd.recsize);
      seek(f1,hd.hdsize+32+(i-1)*newsize);
      blockwrite(f1,recbuf^,newsize);
      end;

    seek(f1,hd.hdsize);                      { Feldliste erweitern }
    blockwrite(f1,df,32);

    inc(hd.felder);                          { Header korrigieren }
    inc(hd.hdsize,32);
    hd.recsize:=newsize;
    writehd(d);
    end;

  dbClose(d);
  irec.command:=icCloseWindow;
  ICP(irec);
  if not iohandler then exit;
end;


{ Feld aus bestehender Datenbank lschen }
{ Datenbank muss geschlossen sein        }
{ gehn noch nicht bei ext. Feldern!      }

procedure dbDeleteField(const filename:string; feldname:dbFeldStr);
var fnr     : integer; {war ein Word, mu integer sein, da fkt -1 zurckgeben kann!!  MK 12/99 }
    d       : DB;
    irec    : dbIndexCRec;
    newsize : word;
    i       : longint;
    df      : dbfeld;
begin
  dbOpen(d,filename,0);
  fnr:=dbGetFeldnr(d,feldname);
  if fnr<0 then error('Ungltiger Feldname:  '+feldname);
  with dp(d)^ do begin
    irec.df:=fname;
    irec.command:=icOpenCWindow; ICP(irec);
    newsize:=hd.recsize-feldp^.feld[fnr].fsize;

    for i:=fnr to hd.felder-1 do begin   { Feld aus phys. Feldliste lschen }
      seek(f1,sizeof(hd)+(i+1)*32);
      blockread(f1,df,32);
      seek(f1,sizeof(hd)+i*32);
      blockwrite(f1,df,32);
      end;

    for i:=1 to hd.recs do begin         { Records konvertieren }
      irec.percent:=(100*i div hd.recs);
      irec.command:=icShowConvert;
      ICP(irec);
      seek(f1,hd.hdsize+(i-1)*hd.recsize);
      blockread(f1,recbuf^,hd.recsize);
      if fnr<hd.felder then
        Move(recbuf^[feldp^.feld[fnr+1].fofs],recbuf^[feldp^.feld[fnr].fofs],
             hd.recsize-feldp^.feld[fnr+1].fofs);
      seek(f1,hd.hdsize-32+(i-1)*newsize);
      blockwrite(f1,recbuf^,newsize);
      end;

    dec(hd.felder);                      { Header korrigieren }
    hd.recsize:=newsize;
    dec(hd.hdsize,32);
    writehd(d);
    end;

  dbClose(d);
  irec.command:=icCloseWindow;
  ICP(irec);
  if not iohandler then exit;
end;


{ alle extenen Feldbezge lschen }

procedure dbKillXbase(const filename:dbFilename);
var d      : DB;
    i      : integer;
    ll     : array[0..1] of longint;
    l      : longint;
    irec   : dbIndexCRec;
    c1,c2  : longint;
    lastpos: longint;
    ehd    : dbdheader;
    f      : ^file;
    mfm    : byte;
begin
  new(f);
  MakeXbase(filename,ehd,f^);
  dispose(f);
  dbOpen(d,filename,0);
  with dp(d)^ do begin
    irec.df:=fname;
    irec.command:=icOpenKWindow;
    ICP(irec);
    dbFlush(d);
    seek(f1,hd.hdsize);
    ll[0]:=0; ll[1]:=0;
    c1:=0; c2:=0;
    while not eof(f1) do begin
      lastpos:=filepos(f1);
      blockread(f1,recbuf^,hd.recsize);
      inc(c1);
      if recbuf^[0] and 1=0 then begin   { not deleted }
        inc(c2);
        irec.percent:=(100*c1 div hd.recs);
        irec.count:=c2;
        irec.command:=icShowConvert;
        ICP(irec);
        for i:=1 to feldp^.felder do
          if feldp^.feld[i].ftyp=dbUntypedExt then begin
            fastmove(recbuf^[feldp^.feld[i].fofs+4],l,4);
            if l<>0 then begin
              fastmove(ll,recbuf^[feldp^.feld[i].fofs],8);
              seek(f1,lastpos);
              blockwrite(f1,recbuf^,hd.recsize);
              inc(c2);
              end;
            end;
        end;
      end;
    close(f1);
    mfm:=filemode; filemode:=$42;
    reset(f1,1);
    filemode:=mfm;
    dbClose(d);
    irec.command:=icCloseWindow;
    ICP(irec);
    end;
end;


{ Dateiname *ohne* Extension! }

function dbPack(const filename:string):boolean;
var n,i   : longint;
    irec  : dbIndexCRec;
    f1,f2 : file;
    hd    : dbheader;
    fld   : dbfeld;
    p     : pointer;
    bp    : ^byte absolute p;
begin
  assign(f1,filename+dbExt);
  reset(f1,1);
  if ioresult<>0 then
    dbPack:=true
  else begin
    blockread(f1,hd,sizeof(hd));
    if hd.hdsize+hd.recsize*hd.reccount+10000>disk_free(0) then
    begin
      close(f1);
      dbPack:=false;
      exit;
    end; 
    irec.df:=filename;
    irec.command:=icOpenPWindow; ICP(irec);
    reset(f1,1);
    assign(f2,'pack.$$$');
    rewrite(f2,1);
{$IFDEF UnixFS }
    { Wir muessen an dieser Stelle bereits eingreifen, da sonst
      pack.$$$ waehrend des Pack-Vorganges auch fuer andere
      lesbar sein koennte }
    close(f2);
    SetAccess('pack.$$$', taUserRW);
    assign(f2, 'pack.$$$');
    reset(f2, 1);
{$ENDIF }
    blockread(f1,hd,sizeof(hd));
    blockwrite(f2,hd,sizeof(hd));
    for i:=0 to hd.felder do begin     { incl. Int_Nr }
      blockread(f1,fld,sizeof(fld));
      blockwrite(f2,fld,sizeof(fld));
      end;
    getmem(p,hd.recsize);
    n:=0;
    while not eof(f1) do begin
      blockread(f1,p^,hd.recsize);
      if bp^ and rFlagDeleted=0 then begin
        inc(n);
        irec.percent:=100 * n div hd.reccount;

        irec.command:=icShowPack;
        ICP(irec);
        blockwrite(f2,p^,hd.recsize);
        end;
      end;
    freemem(p,hd.recsize);
    hd.recs:=n;
    hd.reccount:=n;    { sicherheitshalber.. kann Fehler korrigieren }
    hd.firstfree:=0;
    seek(f2,0);
    blockwrite(f2,hd,sizeof(hd));
    close(f1); close(f2);
    erase(f1); rename(f2,filename+dbExt);
    irec.command:=icCloseWindow;
    ICP(irec);
    assign(f1,filename+dbIxExt);
    erase(f1);
    if ioresult<>0 then;
    dbPack:=true;
    end;
end;


end.
{
  $Log: databaso.pas,v $
  Revision 1.15  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.14  2004/01/09 16:18:55  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.13  2003/08/23 22:58:13  my
  MY:- Neue Funktion 'disk_free' implementiert, die abhngig vom jeweili-
       gen OS (WinNT/2K/XP oder andere) bei der Ermittlung des freien
       Plattenplatzes die entsprechenden Routinen 'diskfree' oder
       'NTDiskFree' verwendet, und in allen Units, die bisher selbst auf
       das OS getestet haben, diese neue Funktion verwendet.

  Revision 1.12  2003/08/23 20:29:53  my
  MW+MY:- Fix NTDiskFree: '1024*1024' und '$10000' (oops!) => '$100000'

  Revision 1.11  2003/08/23 17:25:35  my
  MY:- NTDiskFree-Routinen kompakter geschrieben und Redundanzen
       eliminiert, Typos gefixt, Source formatiert

  Revision 1.10  2003/08/19 11:09:15  mw
  MW: - Umbau auf NTDiskFree

  Revision 1.9  2003/07/30 23:09:48  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.8  2003/06/25 17:25:40  tw
  auto-de-branching

  Revision 1.7.2.3  2001/08/02 22:31:32  mk
  - removed function FUStr, only usefull in 3.70

  Revision 1.7.2.2  2001/07/28 19:24:12  mk
  - added some const parameters

  Revision 1.7.2.1  2000/12/31 11:35:53  mk
  - fileio.disksize statt lfn.disksize benutzen

  Revision 1.7  2000/05/09 15:52:40  hd
  - UnixFS: Access-Mode eingefuegt

  Revision 1.6  2000/04/29 07:59:03  mk
  - Funktion FUStr fuer Filenamen Up/Locase eingebaut

  Revision 1.5  2000/02/15 20:43:35  mk
  MK: Aktualisierung auf Stand 15.02.2000

}
