/*
 * PSP.C - Program Segment Prefix (PSP)
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dos.h>
#include <dialog.h>

typedef struct {
	WORD		signature;
	WORD    	seg_mem;
	char		filler;
	char		service_req;
	WORD		size_first_seg;
	char    	remainder[2];
	DWORD		adr_int22;
	DWORD		adr_int23;
	DWORD		adr_int24;
	WORD		parent_psp;
	char		JFT[20];
	WORD		environ;
	DWORD		ss_sp;
	WORD    	num_JFT;
	void far *	JFTptr;
	void far *	prevPSP;
	char		DBCS;
	char		TrueName;
	char		Novell;
	char		NovellTask;
	char		version[2];
	WORD		WSelector;
	WORD		PDB_Partition;
	WORD		PDB_NextPDB;
	char		WINOLDAP;
	char		unused1[3];
	WORD		PDB_EntryStack;
	char		unused2[2];
	char		service_ins[3];
	char		unused3[2];
	char		unused4[7];
	char		firs_FCB[16];
	char		sec_FCB[16];
	char		unused5[4];
	char		cmdline[128];
} s_psp;

s_psp *	stack[20];
int index = -1;

ROBJ *IDD_PSP;
DOBJ *dialog;

const char cp_text[] =
	"Signature:\n"
	"Program:\n"
	"Commandline:\n\n"
	"Segment of environment:\n"
	"Segment of PSP:\n"
	"Segment of parrent:\n\n"
	"Stored termination:\n"
	"Stored control-Break:\n"
	"Stored critical error:\n\n"
	"Adress of Table:\n"
	"Num Entries:\n"
	"Entry Table:";

const char cp_form[] =
	"%04X\n"
	"\n\n\n"
	"%04X\n"
	"%04X\n"
	"%04X\n\n"
	"%p\n"
	"%p\n"
	"%p\n\n"
	"%p\n"
	"%-3d\n";

void initstack(void)
{
	int x;
	s_psp *p = MK_FP(_psp, 0);

	for (x = 0; x < 20; x++) {
		stack[x] = p;
		p = MK_FP(p->parent_psp, 0);
	}
}

char *getargv(int seg)
{
	_DX = seg;
	asm {
		push	di
		xor	ax,ax
		mov	es,dx
		mov	di,ax
		mov	cx,7FFFh
		cld
	}
nextvariable:
	asm {
		repnz	scasb
		jcxz	short badenviron
		cmp	es:[di],al
		jne	short nextvariable
		or	ch,10000000b
		neg     cx
		mov	ax,cx
		add	ax,1
	}
badenviron:
	asm	pop	di
	return MK_FP(_DX, _AX);
}

void putpsp(s_psp *p)
{
	int x,y,q;
	char *a;

	x = dialog->rc.x + 3;
	y = dialog->rc.y + 2;

	a = getargv(p->environ);
	scputc(x + 24, y + 1, 0, 30, ' ');
	for (q = 1; q < 30; q++) {
		if (a[q] < 32)
			break;
		scputc(x + q + 23, y + 1, 0, 1, a[q]);
	}
	scputc(x + 23, y + 2, 0, 30, ' ');
	for (q = 1; q < 40; q++) {
		if (p->cmdline[q] < 32)
			break;
		scputc(x + q + 23, y + 2, 0, 1, p->cmdline[q]);
	}

	scputf(x + 11, y, 0, 0, "(%d)", index);
	scputf(x + 24, y, 0, 0, cp_form,
		p->signature,
		p->environ,
		FP_SEG(p),
		p->parent_psp,
		p->adr_int22,
		p->adr_int23,
		p->adr_int24,
		p->JFTptr,
		p->num_JFT);

		scputf(x + 23, y + 14, 0, 0,
	"%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d",
		p->JFT[0],p->JFT[1],p->JFT[2],p->JFT[3],p->JFT[4],
		p->JFT[5],p->JFT[6],p->JFT[7],p->JFT[8],p->JFT[9]);
	scputf(x + 23, y + 15, 0, 0,
	"%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d",
		p->JFT[10],p->JFT[11],p->JFT[12],p->JFT[13],p->JFT[14],
		p->JFT[15],p->JFT[16],p->JFT[17],p->JFT[18],p->JFT[19]);
}

int event_parrent(void)
{
	if (++index < 20 && stack[index] != stack[index - 1]) {
		putpsp(stack[index]);
	} else {
		index--;
	}
	return _C_NORMAL;
}

int event_child(void)
{
	if (index > 0)
		putpsp(stack[--index]);
	return _C_NORMAL;
}

int main(void)
{
	if ((dialog = rsopen(IDD_PSP)) == NULL)
		return 1;
	mouseinit();
	mouseon();
	initstack();
	dialog->object[0].proc = event_parrent;
	dialog->object[1].proc = event_child;
	tdshow(dialog);
	scputs(dialog->rc.x + 3, dialog->rc.y + 2, 0, 0, cp_text);
	event_parrent();
	tdmodal(dialog);
	mouseoff();

	return 0;
}

/******** Resource begin PSP *
	{ 0x001C,   3,   2, {11, 2,58,21} },
	{ 0x4000,   0, 'P', { 4,19,11, 1} },
	{ 0x4000,   0, 'C', {18,19,11, 1} },
	{ 0x0A00,   0, 'Q', {45,19, 8, 1} },
********* Resource data  *******************/
static int PSP_RC[] = {
	0x0A26,0x001C,0x0203,0x020B,0x153A,0x4000,0x5000,0x1304,
	0x010B,0x4000,0x4300,0x1312,0x010B,0x0A00,0x5100,0x132D,
	0x0108,0x3AF0,0xF470,0x1718,0x7070,0xF07F,0x7008,0x03F0,
	0x7010,0x7F70,0x08F0,0x1070,0x0FF0,0x7017,0x7F70,0x05F0,
	0x1070,0x09F0,0xF017,0x100B,0x03F0,0xF017,0x100B,0x10F0,
	0xF017,0x1008,0x04F0,0xF017,0x200F,0x7250,0x676F,0x6172,
	0x206D,0x6553,0x6D67,0x6E65,0x2074,0x7250,0x6665,0x7869,
	0x2820,0x5350,0x2950,0x29F4,0x5020,0x7261,0x6572,0x746E,
	0x2020,0xF0DC,0x2004,0x6843,0x6C69,0xF064,0x2004,0xF0DC,
	0x2011,0x7551,0x7469,0x2020,0xF0DC,0x2009,0x0BF0,0xF0DF,
	0x2003,0x0BF0,0xF0DF,0x2010,0x08F0,0xF0DF,0x2004,0x1717,
}; //	176 byte
ROBJ *IDD_PSP = (ROBJ *)&PSP_RC;
/******** Resource end   PSP */
