;
; _getkey.asm - int _getkey(void);
;
; Checks for currently available keystrokes
;
; Returns zero if no keystroke available
; else AH = BIOS scan code, AL = ASCII character
;

include		clib.inc

extrn		keycode	 : BYTE
extrn		keypres	 : BYTE
extrn		__INT09__: ABS

PPROC		_getkey

_ScanInsert	= 	52h
_ScanDelete	= 	53h
_ScanF11	= 	85h
_ScanF12	= 	86h

		mov	ah,1		; BIOS - CHECK FOR KEYSTROKE
		int	16h		; ZF set if no keystroke available
		jz	short @@ex_key	; ZF clear if keystroke available

		mov	ah,0            ; BIOS - GET KEYSTROKE
		int     16h             ; AH = BIOS scan code
		mov	dl,ah
		jmp	short @@end     ; AL = ASCII character

@@ex_key:       xor	dx,dx
		mov	dl,cs:[keycode]
		mov	al,cs:[keypres]
		or	al,al
		jz	short @@nokey

		mov	al,dl
		cmp	al,_ScanF11
		jz	short @@FXX
		cmp	al,_ScanF12
		jz	short @@FXX

		mov	ah,2
		int	16h
		and	al,4
		jz	short @@nokey

		cmp	al,_ScanDelete
		jz	short @@ctrl
		cmp	al,_ScanInsert
		jz	short @@ctrl
		jmp	short @@nokey

@@FXX:		xchg	al,ah
		xor	al,al
		mov	cs:[keypres],al
		jmp	short @@end

@@ctrl:		mov	ah,dl
		mov	cs:[keypres],dh
		jmp	short @@end

@@nokey:	xor     ax,ax
@@end:		ret

PEND		_getkey

		END
