;
; PEVENT.ASM - Panel event
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
INCLUDE		clib.inc
INCLUDE		dzmain.inc
INCLUDE		string.inc
INCLUDE		dialog.inc
INCLUDE		ifsmgr.inc
INCLUDE		io.inc

		LOCALS

_DATA		SEGMENT

ermsg_01	DB	"Error init directory",10,'%s',0

key_table	DW      KEY_LEFT
		DW      KEY_RIGHT
		DW      KEY_UP
		DW      KEY_INS
		DW      KEY_DOWN
		DW      KEY_END
		DW      KEY_HOME
		DW      KEY_PGUP
		DW      KEY_PGDN
		DW      KEY_ENTER
		DW      KEY_KPENTER

key_count	=	(($ - key_table) / 2)

proc_table	DW	event_LEFT
		DW	event_RIGHT
		DW	event_UP
		DW	event_INS
		DW	event_DOWN
		DW	event_END
		DW	event_HOME
		DW	event_PGUP
		DW	event_PGDN
		DW	event_ENTER
		DW	event_ENTER

_DATA		ENDS

_TEXT		SEGMENT

		EXTRN	PanelPutinfoIZ:	NEAR
		EXTRN	PanelPutinfoAX:	NEAR
		EXTRN	PanelPutitemAX:	NEAR

event_LEFT:	les	bx,[si.pn_xl]
		xor	ax,ax
		xor	dx,dx
		mov	al,ES:[bx+3]
		cmp	ax,[si.pn_cel_index]
		ja	SHORT @@
		sub	[si.pn_cel_index],ax
		jmp	SHORT upd_pcellsi
@@:		cmp	[si.pn_cel_index],dx
		jz	SHORT @@1
		mov	[si.pn_cel_index],dx
		jmp	SHORT upd_pcellsi
@@1:		cmp	[si.pn_fcb_index],dx
		jz	SHORT @@0
		cmp	ax,[si.pn_fcb_index]
		ja	SHORT @@2
		sub	[si.pn_fcb_index],ax
		jmp	SHORT @@3
@@2:		mov	[si.pn_fcb_index],dx
@@3:            mov	ax,dx
		jmp	PanelPutitemAX
@@0:		xor	ax,ax
		ret

upd_pcellsi:	push	DS
		push	si
		call	pcell_update
		ret

event_RIGHT:	les	bx,[si.pn_xl]
		xor	cx,cx
		mov	cl,ES:[bx+3]
		mov	ax,[si.pn_cel_index]
		add	ax,cx
		mov	dx,[si.pn_cel_count]
		dec	dx
		cmp	ax,dx
		ja	SHORT @@
		add	[si.pn_cel_index],cx
		jmp	SHORT upd_pcellsi
@@:		mov	ax,[si.pn_cel_index]
		add	ax,[si.pn_fcb_index]
		add	ax,cx
		cmp	ax,[si.pn_fcb_count]
		jae	SHORT @@1
		add	[si.pn_fcb_index],cx
		xor	ax,ax
		jmp	PanelPutitemAX
@@1:            cmp	[si.pn_cel_index],dx
		jae	SHORT @@0
		mov	[si.pn_cel_index],dx
		jmp	SHORT upd_pcellsi
@@0:            xor	ax,ax
		ret

event_UP:   	xor	ax,ax
		cmp	[si.pn_cel_index],ax
		jz	SHORT @@1
		dec     [si.pn_cel_index]
		jmp	SHORT upd_pcellsi
@@1:            cmp	[si.pn_fcb_index],ax
		jnz	SHORT @@
		ret
@@:		dec     [si.pn_fcb_index]
		mov	ax,CLP_MOVEDN
		jmp	PanelPutitemAX

event_DOWN:	mov	ax,[si.pn_cel_count]
		dec	ax
		cmp	ax,[si.pn_cel_index]
		jbe	SHORT @@
		inc	[si.pn_cel_index]
		jmp	SHORT upd_pcellsi
@@:		jne	SHORT @@0
		mov	ax,[si.pn_fcb_count]
		sub	ax,[si.pn_fcb_index]
		sub	ax,[si.pn_cel_index]
		cmp	ax,1
		jng	SHORT @@0
		inc	[si.pn_fcb_index]
		mov	ax,CLP_MOVEUP
		jmp	PanelPutitemAX
@@0:		xor	ax,ax
		ret

event_INS:	push	DS
		push	si
		call	pcell_select
		or	ax,ax
		jnz	SHORT @@
		ret
@@:		test	config.c_lflag,_C_INSMOVDN
		jnz	SHORT event_DOWN
		mov	ax,1
		ret

event_END:	mov	dx,[si.pn_cel_count]
		mov	ax,[si.pn_fcb_count]
		cmp	dx,ax
		jae	SHORT @@
		sub	ax,dx
		mov	[si.pn_fcb_index],ax
		dec	dx
		mov	[si.pn_cel_index],dx
@@1:		xor	ax,ax
		jmp	PanelPutitemAX
@@:             dec	dx
		cmp     dx,[si.pn_cel_index]
		ja	SHORT @@0
		xor	ax,ax
		ret
@@0:            mov	[si.pn_cel_index],dx
		mov	[si.pn_fcb_index],0
		jmp	SHORT @@1

event_HOME: 	xor	ax,ax
		mov	dx,[si.pn_cel_index]
		or	dx,[si.pn_fcb_index]
		jnz	SHORT @@
		ret
@@:             mov	[si.pn_cel_index],ax
		mov	[si.pn_fcb_index],ax
		jmp	PanelPutitemAX

event_PGUP:	xor	ax,ax
		mov	dx,[si.pn_cel_index]
		or	dx,[si.pn_fcb_index]
		jnz	SHORT @@
		ret
@@:		cmp	ax,[si.pn_cel_index]
		jz	SHORT @@1
		mov	[si.pn_cel_index],ax
		jmp	upd_pcellsi
@@1:		mov	cx,ax
		les	bx,[si.pn_xl]
		mov	al,ES:[bx+2]
		mov	cl,ES:[bx+3]
		imul	cx
		cmp	ax,[si.pn_fcb_index]
		ja	SHORT @@2
		sub	[si.pn_fcb_index],ax
		jmp	SHORT @@3
@@2:            mov	[si.pn_fcb_index],0
@@3:            xor	ax,ax
		jmp	PanelPutitemAX

event_PGDN: 	mov	ax,[si.pn_cel_count]
		dec	ax
		cmp	ax,[si.pn_cel_index]
		je	SHORT @@
		mov	[si.pn_cel_index],ax
		jmp	upd_pcellsi
@@:		add	ax,[si.pn_fcb_index]
		inc	ax
		cmp	ax,[si.pn_fcb_count]
		jne	SHORT @@1
@@0:		xor	ax,ax
		ret
@@1:		mov	ax,[si.pn_fcb_index]
		add	ax,[si.pn_cel_count]
		cmp	ax,[si.pn_fcb_count]
		jae	SHORT @@0
		mov	ax,[si.pn_cel_count]
		dec	ax
		add	[si.pn_fcb_index],ax
		xor	ax,ax
		mov	[si.pn_cel_index],ax
		jmp	PanelPutitemAX

;;; Panel Event ENTER

savepath:	push	ES
		push	bx
		mov	bx,[si]
		push	SS
		lea	ax,prevp
		push	ax
		push	DS
		test	[bx.wp_flag],_W_ARCHIVE
		jnz	SHORT @@arch
		test	[bx.wp_flag],_W_LONGNAME
		jnz	SHORT @@long
		add	bx,wp_path
@@strfn:	push	bx
		call	strfn
@@cpy:		push	dx
@@cpyAX:	push	ax
		call	strcpy
		pop	bx
		pop	ES
		ret
@@long:		add	bx,wp_path
		push	bx
		push	large 0
		call	wlongname
		jmp	SHORT @@cpy
@@arch:		cmp	[bx.wp_arch],0
		jz	SHORT @@file
		add	bx,wp_arch
		jmp	SHORT @@strfn
@@file:		add	bx,wp_file
		mov	ax,bx
		jmp	SHORT @@cpyAX

reducepath:	push	DS
		push	di	; DI: .wp_path | .wp_arch
		push	'\'
		call	strrchr
		or	ax,ax
		jnz	SHORT @@
		mov	[di],al
		ret
@@:		mov	bx,ax
		xor	ax,ax
		mov	[bx],al
		ret

addtopath:	xor	eax,eax
		push	DS
		push	di	; DI: .wp_path | .wp_arch
		add	bx,fb_name
		cmp	al,[di]
		jz	SHORT @@
		push	eax
		push	ES
		push	bx
		call	strfcat
		ret
@@:		push	ES
		push	bx
		call	strcpy
		ret

ENTER_local:	lea	ax,wtmp
		push	SS
		push	ax
		push	SS
		push	ax
		push	DS
		mov	ax,di
		add	ax,wp_path
		push	ax
		push	ES
		add	bx,fb_name
		push	bx
		call	strfcat
		call	chdir
		or	ax,ax
		jnz	SHORT ENTER_read
		push	DS
		mov	ax,di
		add	ax,wp_path
		push	ax
		xor	ax,ax
		mov	al,[di.wp_path]
		and	al,(NOT 20h)
		sub	al,'@'
		push	ax
		cmp	_ifsmgr,0
		jz	SHORT @@dos
		test	[di.wp_flag],_W_LONGNAME
		jz	SHORT @@dos
		call	wfullpath
		jmp	SHORT ENTER_read
@@dos:		call	fullpath

ENTER_read:	push	DS
		push	si
		call	panel_read
		push	[si.pn_wsub]
		call	com_setdevice
		ret

ENTER_network:  add	di,wp_path
		test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@sub
		push	DS
		mov	ax,di
		add	ax,2
		push	ax
		push	'\'
		call	strrchr
		or	ax,ax
		jz	SHORT ENTER_read
		call	reducepath
		jmp	SHORT ENTER_read
@@sub:		call	addtopath
		jmp	SHORT ENTER_read

ENTER_archive:  test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@sub
		cmp	[di.wp_arch],0
		jnz	SHORT @@arc
		and     [di.wp_flag],(NOT _W_ARCHIVE)
		jmp	SHORT ENTER_read
@@arc:		add	di,wp_arch
		call	reducepath
		jmp	SHORT ENTER_read
@@sub:		add	di,wp_arch
		call	addtopath
		jmp	SHORT ENTER_read

ENTER_error:    push	DS
		mov	ax,di
		add	ax,wp_path
		push	ax
		push	DS
		push	OFFSET ermsg_01
		push	large 0
		call    ermsg
		add	sp,12
		ret

ENTER_subdir:	xor	ax,ax
		mov	di,[si]
		cmp	[di.wp_path.1],':'
		je	SHORT @@reset
		cmp	[di.wp_path],'\'
		jne	SHORT ENTER_error
@@reset:	mov	[si.pn_cel_index],ax
		mov	[si.pn_fcb_index],ax
		mov	prevp,al
		test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@
		call	savepath
@@:		test	ES:[bx.fb_flag],_A_ARCHIVE
		jnz	SHORT @@archive
		cmp	[di.wp_path.1],':'
		jne	SHORT @@network
		call	ENTER_local
		jmp	SHORT @@update
@@network:	call	ENTER_network
		jmp	SHORT @@update
@@archive:	call	ENTER_archive
@@update:	cmp	prevp,0
		je	SHORT @@toend
		push	[si.pn_wsub]
		push    SS
		lea	ax,prevp
		push	ax
		call	wsearch
		cmp	ax,-1
		je	SHORT @@toend
		push	DS
		push	si
		push    ax
		call	panel_setid
@@toend:	xor	ax,ax
		jmp	PanelPutinfoAX

event_ENTER:	push	DS
		push	si
		call	panel_curobj
		or	ax,ax
		jnz	SHORT @@1
		ret
@@1:		mov	ES,dx
		mov	bx,ax
		test	ES:[bx.fb_flag],_A_SUBDIR
		jnz	SHORT ENTER_subdir
		test	ES:[bx.fb_flag],_A_ARCHIVE
		jnz	SHORT @@0
		mov	WORD PTR [cobj+2],dx
		mov	WORD PTR [cobj],ax
		add	ax,fb_name
		push    dx
		push	ax
		call	isexec
		or	ax,ax
		jnz	SHORT @@exe
		push	cobj
		lea	ax,prevp
		push	SS
		push	ax
		call	fbinitype
		or	ax,ax
		jnz	SHORT @@ini
		lea	ax,prevp
		push	SS
		push	ax
		mov	ax,[si]
		add	ax,wp_path
		push	DS
		push	ax
		mov	eax,cobj
		add	ax,fb_name
		push	eax
		call	strfcat
		push	dx
		push	ax
		call	readword
		cmp	ax,FWID_ZIP
		je	SHORT @@archzip
		cmp	ax,FWID_ARJ
		je	SHORT @@archarj
		cmp	ax,FWID_DZIP
		je	SHORT @@archdzip
		cmp	ax,FWID_GZ
		je	SHORT @@archgz
@@0:		xor	ax,ax
		ret
@@ini:		mov	ax,1
		ret
@@exe:          add	WORD PTR [cobj],fb_name
		push	cobj
		call	ex_command
		ret
@@archdzip:	mov	ax,_A_DZIP
		jmp	SHORT @@archive
@@archgz:       mov	ax,_A_GZ
		jmp	SHORT @@archive
@@archarj:	mov	ax,_A_ARJ
		jmp	SHORT @@archive
@@archzip:      mov	ax,_A_ZIP
@@archive:      test	config.c_apath.wp_flag,_W_ARCHIVE
		jnz	SHORT @@0
		test	config.c_bpath.wp_flag,_W_ARCHIVE
		jnz	SHORT @@0
		mov	di,[si]
		mov	[di.wp_arch],0
		and	[di.wp_flag],(NOT _W_ARCHIVE)
		or	[di.wp_flag],ax
		push	DS
		mov	ax,di
		add	ax,wp_file
		push	ax
		add	WORD PTR [cobj],fb_name
		push	cobj
		call	strcpy
		push	DS
		push	si
		call	panel_read
		call	PanelPutinfoIZ
		ret

_TEXT    	ENDS

PPROC		panel_hndevent
ARG		panel:	DWORD,\
		event:	WORD
LOCAL		prevp:	BYTE:[WMAXPATH],\
		wtmp:	BYTE:[WMAXPATH],\
		cobj:	DWORD
		USES	si,di
		push	panel
		call	panel_state
		jz	SHORT @@end
		mov	si,WORD PTR panel
		mov	cx,key_count
		xor	bx,bx
		mov	ax,event
		cmp	ax,KEY_INS	; Shift-Ins --> ClipboardPaste()
		je	SHORT @@shift
@@keyloop:	cmp	ax,[bx.key_table]
		jz	SHORT @@exe
		add	bx,2
		dec	cx
		jnz	SHORT @@keyloop
		jmp	SHORT @@end
@@exe:		call	[bx.proc_table]
@@end:        	xor	ax,ax
@@ret:		ret
@@shift:	les	bx,shift
		mov	dl,es:[bx]
		and	dl,3
		jnz	SHORT @@end
		xor	bx,bx
		jmp	SHORT @@keyloop
PEND		panel_hndevent

		END
