/*
 * CMSELECT.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <dzmain.h>

static char
	cp_selectmask	[32] = {0};

static int __select(void)
{
	int q;
	fblk **p;

	if (!panel_state(cpanel))
		return 0;
	p = cpanel->ide->fcb;
	for (q = 0; q < cpanel->fcb_count; q++) {
		if (cmpwarg(p[q]->name, cp_selectmask))
			select_fb(p[q]);
	}
	panel_putitem(cpanel, 0);
	return 1;
}

static int __deselect(void)
{
	int q;
	fblk **p;

	p = cpanel->ide->fcb;
	for (q = 0; q < cpanel->fcb_count; q++) {
		if (cmpwarg(p[q]->name, cp_selectmask))
			p[q]->flag &= ~_A_SELECTED;
	}
	panel_putitem(cpanel, 0);
	return 1;
}

int cmselect(void)
{
	int result;

	if (!panel_state(cpanel))
		return 0;
	if (cp_selectmask[0] == 0)
		strcpy(cp_selectmask, cp_stdmask);
	result = tgetline(cp_select, cp_selectmask, 12, 32);
	if (result == 0 || cp_selectmask[0] == 0)
		return 0;
	return __select();
}

int cmdeselect(void)
{
	int result;

	if (!panel_state(cpanel))
		return 0;
	if (cp_selectmask[0] == 0)
		strcpy(cp_selectmask, cp_stdmask);
	result = tgetline(cp_deselect, cp_selectmask, 12, 32);
	if (result == 0 || cp_selectmask[0] == 0)
		return 0;
	return __deselect();
}

int cminvert(void)
{
	int q;
	fblk **p;

	if (!panel_state(cpanel))
		return 0;
	p = cpanel->ide->fcb;
	for (q = 0; q < cpanel->fcb_count; q++)
		  invert_fb(p[q]);
	panel_putitem(cpanel, 0);
	return 1;
}
