/* CMMOVE.C--
 * Copyright (c) 1999 Hjort Nidudsson
 *
 * Change history:
 * 21 Apr 1999	- Created
 */

#include <arch.h>
#include <errno.h>
#include <string.h>
#include <progress.h>
#include <dzmain.h>

extern int copy_flag;
extern int copy_jump;
extern int copyfile(long, int, int, char);
extern int xcopy_file(const char *, wfblk *);
extern int xcopy_subdir(const char *);
extern int copy_initpath(FBLK *, int _1copy_or_0move);

static int jmp_count;
static char cp_emdelsub[] = "Can't delete the directory\n%s\n'%s'";

static int delete_directory(const char *p)
{
	if (progress_set(NULL, p, 0))
		return _ER_USERABORT;
	setfattr(p, 0);
	if (rmdir(p) && jmp_count == 0) {
		ermsg(cp_edel, cp_emdelsub, p, sys_errlist[errno]);
		return -1;
	}
	return 0;
}

static int delete_file(int result, int flag)
{
	if (result == 0 && copy_jump == 0) {
		if (ISRDONLY(flag))
			setfattr(__srcfile, 0);
		remove(__srcfile);
	} else if (result == 0) {
		copy_jump = 0;
		jmp_count++;
	}
	return result;
}

static int moveblock(const char *p, wfblk *wf)
{
	return delete_file(xcopy_file(p, wf), wf->attrib);
}

static int cmmovefile(FBLK *b)
{
	if (progress_set(__srcfile, __outfile, b->size))
		return _ER_USERABORT;
	if (rename(__srcfile, __outfile))
		return delete_file(
		       copyfile(b->size, b->date, b->time, b->flag), b->flag);
	return 0;
}

static int cmmovedirectory(FBLK *b)
{
	int result;
	char subdir[WMAXPATH];

	if (progress_set(b->name, __outpath, 0))
		return _ER_USERABORT;
	strfcat(__srcfile, __srcpath, b->name);
	strfcat(__outfile, __outpath, b->name);
	if (rename(__srcfile, __outfile)) {
		strfcat(subdir, __srcpath, b->name);
		fp_directory = xcopy_subdir;
		result = scansub(subdir, cp_stdmask, 1);
		if (result == 0 && copy_jump == 0) {
			fp_directory = delete_directory;
			return scansub(subdir, cp_stdmask, 0);
		} else if (result == 0) {
			copy_jump = 0;
			jmp_count++;
			return 0;
		}
		return -1;
	}
	return 0;
}

int cmmove(void)
{
	FBLK *b;

	if (!(b = cpanel_findfirst()))
		return 0;
	if (ISARCHIVE(b->flag)) {
		notsup();
		return 0;
	}
	if (copy_initpath(b, 0) == 0)
		return 0;
	if (copy_flag & _CPYOUTARCH)
		return notsup();
	jmp_count = 0;
	fp_fileblock = moveblock;
	progress_open(cp_move, cp_move);
	if (ISSELECTED(b->flag)) {
		do {
			if (ISSUBDIR(b->flag)) {
				if (cmmovedirectory(b))
					break;
			} else {
				strfcat(__srcfile, __srcpath, b->name);
				strfcat(__outfile, __outpath, b->name);
				if (cmmovefile(b))
					break;
			}
			b->flag &= ~(_A_SELECTED);
		} while ((b = panel_ffselected(cpanel)) != NULL);
	} else {
		if (ISSUBDIR(b->flag))
			cmmovedirectory(b);
		else
			cmmovefile(b);
	}
	progress_close();
	if (panel_state(&panela))
		panel_update_fcb(&panela);
	if (panel_state(&panelb))
		panel_update_fcb(&panelb);
	return 1;
}