/* CMFILTER.C--
 * Copyright (c) 2006 Hjort Nidudsson
 *
 * Change history:
 * 06 Jan 2006	- Created
 */

#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <dzmain.h>

const char cp_directory[] = "Directory";

/* Panel Filters */

enum RCPanelFilter {
	OD_FCOUNT,
	OD_MASK,
	OD_PATH,
	OD_SET,
	OD_LOAD,
	OD_CANCEL
};

static int event_loadpath(void)
{
	DOBJ *	d;
	char 	b[WMAXPATH];
	int 	result;

	d = tdialog;
	result = tools_modalidd(WMAXPATH, b, cp_directory);
	while (mousep());
	if (result == 0 || result == MOUSECMD)
		return _C_NORMAL;
	strcpy(d->object[OD_PATH].data, ex_convert(b));
	return _C_REOPEN;
}

int panel_filter(panel *p, int x)
{
	WSUB *	w;
	DOBJ *	d;
	TOBJ *	o;
	char *	cp;
	int 	result;
	int 	max;

	cp = (char *)IDD_PanelFilter;
	cp[6] = x;
	if ((d = rsopen(IDD_PanelFilter)) == NULL)
		return 0;
	w = p->ide;
	o = d->object;
	o[OD_LOAD].proc = event_loadpath;
	strcpy(o[OD_MASK].data, w->mask);
	strcpy(o[OD_PATH].data, w->path);
	sprintf(o[OD_FCOUNT].data, "%d", w->maxfb);
	tdinit(d);
	result = tdevent(d);
	if (result == 0) {
		twclose(d);
		return 0;
	}
	max = atoi(o[OD_FCOUNT].data);
	strcpy(w->path, o[OD_PATH].data);
	strcpy(w->mask, o[OD_MASK].data);
	twclose(d);
	result = w->maxfb;
	if (max != result && max > 10 && max < WMAXFBLOCK) {
		if (w->fcb) {
			wsclose(w);
			w->maxfb = max;
			if (wsopen(w) == 0) {
				w->maxfb = result;
				wsopen(w);
				return 0;
			}
		}
	}
	panel_update_fcb(p);
	if (p == cpanel)
		com_setdevice(w);
	return 1;
}

int cmafilter(void)
{
	return panel_filter(&panela, 3);
}

int cmbfilter(void)
{
	return panel_filter(&panelb, 42);
}

/* Operation Filters */

static int event_loadfilter(void)
{
	DOBJ *	d;
	char 	b[128];
	int 	result;

	d = tdialog;
	result = tools_modalidd(128, b, cp_filter);
	while (mousep());
	if (result == 0 || result == MOUSECMD)
		return _C_NORMAL;
	if (d->index != 1)
		d->index = 0;
	strcpy(d->object[d->index].data, b);
	return _C_REOPEN;
}

static GCMD filter_keys[] = {
	{ F3, event_loadfilter },
	{ 0,  NULL },
};

int cmfilter(void)
{
	return filter_edit(&config.opfilt, &filter_keys[0]);
}

/******** Resource begin PanelFilter *
	{ 0x041C,   6,   5, { 3, 3,38,13} },
	{ 0x0004,   2, 'B', {18, 3,14, 1} },
	{ 0x0004,   2, 'F', {18, 6,14, 1} },
	{ 0x0004,  17, 'D', { 6, 9,26, 1} },
	{ 0x0000,   0, 'O', { 3,11, 6, 1} },
	{ 0x4000,   0, 'L', {12,11, 8, 1} },
	{ 0x0200,   0, 'C', {23,11,10, 1} },
********* Resource data  *******************/
static int PanelFilter_RC[] = {
	0x05DA,0x041C,0x0506,0x0303,0x0D26,0x0004,0x4202,0x0312,
	0x010E,0x0004,0x4602,0x0612,0x010E,0x0004,0x4411,0x0906,
	0x011A,0x0000,0x4F00,0x0B03,0x0106,0x4000,0x4C00,0x0B0C,
	0x0108,0x0200,0x4300,0x0B17,0x010A,0x26F0,0xF050,0x2A2B,
	0x0BF0,0xF02E,0x2A28,0x0EF0,0xF007,0x2A31,0x05F0,0xF02E,
	0x2A2E,0x0EF0,0xF007,0x2A31,0x09F0,0xF02E,0x2A1E,0x1AF0,
	0xF007,0x2A2F,0x5050,0xF05C,0x5003,0x2A20,0x502A,0x5C50,
	0x05F0,0x2050,0x2A2A,0x5050,0xF05C,0x5007,0xF020,0x2A08,
	0x06F0,0xF020,0x2A03,0x08F0,0xF020,0x2A03,0x0AF0,0xF020,
	0x2A04,0x0DF0,0x5020,0x6E61,0x6C65,0x4620,0x6C69,0x6574,
	0xF072,0x2036,0x20DA,0x7542,0x6666,0x7265,0x7320,0x7A69,
	0x2065,0x11F0,0xBFC4,0x06F0,0xB320,0x5220,0x6165,0x2064,
	0x6F63,0x6E75,0x3A74,0x5B20,0x0EF0,0x5DFA,0xB320,0x06F0,
	0xC020,0x1EF0,0xD9C4,0x06F0,0xDA20,0x4620,0x6C69,0x7365,
	0xF020,0xC417,0xF0BF,0x2006,0x20B3,0x6552,0x6461,0x6D20,
	0x7361,0x3A6B,0x2020,0xF05B,0xFA0E,0x205D,0xF0B3,0x2006,
	0xF0C0,0xC41E,0xF0D9,0x2006,0x20DA,0x6944,0x6572,0x7463,
	0x726F,0x2079,0x13F0,0xBFC4,0x06F0,0xB320,0x5B20,0x1AF0,
	0x5DFA,0xB320,0x06F0,0xC020,0x1EF0,0xD9C4,0x08F0,0x4F20,
	0x206B,0xDC20,0x04F0,0x4C20,0x616F,0x2064,0xDC20,0x04F0,
	0x4320,0x6E61,0x6563,0x206C,0xDC20,0x08F0,0xF020,0xDF06,
	0x03F0,0xF020,0xDF08,0x03F0,0xF020,0xDF0A,0x04F0,0x2A20,
}; //	352 byte
ROBJ *IDD_PanelFilter = (ROBJ *)&PanelFilter_RC;
/******** Resource end   PanelFilter */
