; CALENDAR.ASM--
; Copyright (c) 2008 Hjort Nidudsson

INCLUDE		clib.inc
INCLUDE		time.inc
INCLUDE		stdsc.inc
INCLUDE		mouse.inc
INCLUDE		dialog.inc
INCLUDE		kbd.inc

STARTDAY  	= 5
STARTYEAR       = 0
MAXYEAR 	= 3000

_DATA		SEGMENT

cp_jan		DB	"January",0
cp_feb		DB	"February",0
cp_mar		DB	"March",0
cp_apr		DB	"April",0
cp_may		DB	"May",0
cp_jun		DB	"June",0
cp_jul		DB	"July",0
cp_aug		DB	"August",0
cp_sep		DB	"September",0
cp_oct		DB	"October",0
cp_nov		DB	"November",0
cp_dec		DB	"December",0

cp_month	DW	OFFSET cp_jan
		DW      OFFSET cp_feb
		DW      OFFSET cp_mar
		DW      OFFSET cp_apr
		DW      OFFSET cp_may
		DW      OFFSET cp_jun
		DW      OFFSET cp_jul
		DW      OFFSET cp_aug
		DW      OFFSET cp_sep
		DW      OFFSET cp_oct
		DW      OFFSET cp_nov
		DW      OFFSET cp_dec

mnd_table	DB	31,28,31,30,31,30,31,31,30,31,30,31

YPOS		= 0
XPOS		= 51

kpos		DB	(XPOS+1)
		DB	(XPOS+5)
		DB	(XPOS+9)
		DB	(XPOS+13)
		DB	(XPOS+17)
		DB	(XPOS+21)
		DB	(XPOS+25)

IDD_Calendar	DW	02BFh		; Alloc size
		DW	0018h		; Dialog
		DW	0000h
		DD	0B1D0033h
		DB	240,20,07h	; Dialog color - %Month %Year
		DB	240, 9,78h	;  %hh:mm:ss
		DB	241,34,7Fh	;  %calendar
		DB	240,23		; Dialog text
		DB	' :  :  '
		DB	240,29,''
		DB	' Mon Tue Wed Thu Fri Sat Sun  '
		DB	240,27,196
		DB	240,175,' '
		DB	240,29,''

cp_s_d		DB	'%s %d',0
cp_2d		DB	'%2d',0

key_local	DW	MOUSECMD
		DW	KEY_ESC
		DW	KEY_HOME
		DW	KEY_RIGHT
		DW	KEY_LEFT
		DW	KEY_UP
		DW	KEY_DOWN
		DW	KEY_PGUP
		DW	KEY_PGDN
		DW	CTRLPGUP
		DW	CTRLPGDN

key_count	=	(($ - key_local) / 2)

key_proc	DW	event_MOUSE
		DW	event_ESC
		DW	event_HOME
		DW	case_nextday
		DW	case_prevday
		DW	event_UP
		DW	event_DOWN
		DW	case_prevmonth
		DW	case_nextmonth
		DW	case_prevyear
		DW	case_nextyear

_DATA		ENDS

CALENDAR_TEXT	SEGMENT USE16 BYTE PUBLIC 'CODE'
		ASSUME CS:CALENDAR_TEXT

daysinfeb:      push	dx
		push	bx
		or	cx,cx
		jz	SHORT @@leap
		mov	ax,cx
		and	al,3
		jnz	SHORT @@400
		mov	ax,cx
		mov	bx,100
		xor	dx,dx
		div	bx
		or	dx,dx
		jnz	SHORT @@leap
@@400:		mov	bx,400
		mov	ax,cx
		xor	dx,dx
		div	bx
		or	dx,dx
		jz	SHORT @@leap
		mov	ax,28
@@toend:	pop	bx
		pop	dx
		ret
@@leap:		mov	ax,29
		jmp	SHORT @@toend

daysinmnd:      cmp	bx,2		; BX = month
		je	SHORT daysinfeb
		movzx	ax,mnd_table[bx-1]
		ret

weekdayjan1:	push	esi
		push	edi
		mov	esi,STARTDAY
		movzx	edi,cx
		mov	ecx,STARTYEAR
@@loop:         cmp	ecx,edi
		jnb	SHORT @@toend
		call	daysinfeb
		cmp	ax,29
		jne	SHORT @@next
		inc	esi
@@next:		inc	ecx
		inc	esi
		jmp	SHORT @@loop
@@toend:        push	dx
		xor	edx,edx
		mov	eax,esi
		mov	esi,7
		div	esi
		mov	ax,dx
		pop	dx
		mov	cx,di
		pop	edi
		pop	esi
		ret

weekday:	call	weekdayjan1
		push	si
		push	di
		mov	si,ax
		mov	di,bx
		mov	bx,1
@@loop:		cmp	bx,di
		jnb	SHORT @@toend
		call	daysinmnd
		add	si,ax
		inc	bx
		jmp	SHORT @@loop
@@toend:	push	dx
		mov	di,7
		xor	dx,dx
		mov	ax,si
		div	di
		mov	ax,dx
		pop	dx
		pop	di
		pop	si
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putmonth:       push	(XPOS + 1)
		push	YPOS
		push	19
		push	' '
		call	scputw
		push	year
		push	ds
		mov	bx,month
		dec	bx
		add	bx,bx
		push	cp_month[bx]
		push	ds
		push	OFFSET cp_s_d
		xor	eax,eax
		push	eax
		push	ax
		push	(XPOS + 1)
		call	scputf
		add	sp,18
		ret

put2d:		inc	si
		push	cx
		push	si
		push	ds
		push	OFFSET cp_2d
		push	0
		mov	ax,70h
		cmp	si,day
		jne	SHORT @@70
		mov	al,7Fh
@@70:		push	ax
		push	di
		mov	bx,cx
		movzx	ax,kpos[bx]
		push	ax
		call	scputf
		call	getday
		xor	ah,ah
		cmp	ax,si
		jne	SHORT @@popcx
		call	getmnd
		xor	ah,ah
		cmp	ax,month
		jne	SHORT @@popcx
		call	getyear
		cmp	ax,year
		jne	SHORT @@popcx
		mov	bx,sp
		mov	ss:[bx.sf_at],74h
		call	scputf
@@popcx:        add	sp,14
		pop	cx
		ret

putdata:        push	si
		push	di
		mov	ax,year
		mov	dx,month
		cmp	ax,current_year
		jne	SHORT @@update
		cmp	dx,current_month
		je	SHORT @@putday
@@update:	mov	current_month,dx
		mov	current_year,ax
		call	putmonth
		mov	si,(YPOS + 4)
@@clr:		push	XPOS
		push	si
		push	29
		push	7020h
		call	scputw
		inc	si
		cmp	si,(YPOS + 4 + 6)
		jb	SHORT @@clr
@@putday:	xor	si,si
		mov	di,4
@@loopy:	cmp	si,numdaysinmonth
		jnb	SHORT @@toend
		xor	cx,cx
@@loopx:	cmp	cx,7
		jnb	SHORT @@endx
		cmp	dayofweek,cx
		ja	SHORT @@NumDays
		cmp	di,4
		jne	SHORT @@NumDays
		call	put2d
@@nextx:	inc	cx
		jmp	SHORT @@loopx
@@NumDays:	cmp	di,4
		jna	SHORT @@nextx
		cmp	si,numdaysinmonth
		jae	SHORT @@nextx
		call	put2d
		jmp	SHORT @@nextx
@@endx:		inc	di
		cmp	di,11
		jb	SHORT @@loopy
@@toend:        pop	di
		pop	si
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

inc_year:	mov	cx,year
		cmp	cx,MAXYEAR
		je	SHORT @@start
		inc	cx
		ret
@@start:	mov	cx,STARTYEAR
		ret

dec_year:	mov	cx,year
		or	cx,cx
		jz	SHORT @@max
		dec	cx
		ret
@@max:		mov	cx,MAXYEAR
		ret

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_HOME:     call	current_date
		call	putdata
		ret

event_DOWN:	mov	ax,day
		add	ax,7
		cmp	ax,numdaysinmonth
		ja	SHORT case_nextday
		mov	day,ax
		call	putdata
		ret

case_nextday:	mov	dx,day
		inc	dx
		cmp	dx,numdaysinmonth
		ja	SHORT case_nextmonth
@@nextday:	mov	day,dx
		call	putdata
		ret

case_nextmonth:	mov	bx,month
		cmp	bx,12
		je	SHORT case_nextyear
		mov	dx,1
		mov	cx,year
		inc	bx
		jmp	SHORT set_date

case_nextyear:	mov	dx,1
		mov	bx,dx
		call	inc_year
		jmp	SHORT set_date

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_UP:       cmp	day,7
		jb	SHORT case_prevday
		sub	day,7
		call	putdata
		ret

case_prevday:	mov	dx,day
		cmp	dx,1
		je	SHORT @@prevmonth
		mov	cx,year
		mov	bx,month
		dec	dx
		jmp	SHORT set_date
@@prevmonth:	call	case_prevmonth
		mov	ax,numdaysinmonth
		mov	day,ax
		call	putdata
		ret

case_prevmonth:	mov	dx,1
		mov	bx,month
		mov	cx,year
		cmp	bx,1
		je	SHORT @@prevyear
		dec	bx
		jmp	SHORT set_date
@@prevyear:	mov	bx,12
		call	dec_year
		jmp	SHORT set_date

case_prevyear:	mov	dx,1
		mov	bx,dx
		call	dec_year

set_date:	mov	day,dx
		mov	month,bx
		mov	year,cx
		call	weekday
		mov	dayofweek,ax
		call	daysinmnd
		mov	numdaysinmonth,ax
		call	putdata
		ret

current_date:	call	getday
		xor	ah,ah
		mov	day,ax
		call	getmnd
		xor	ah,ah
		mov	month,ax
		call	getyear
		mov	year,ax
		mov	dx,day
		mov	bx,month
		mov	cx,ax
		call	weekday
		mov	dayofweek,ax
		call	daysinmnd
		mov	numdaysinmonth,ax
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		IFDEF	MOUSEDATE
testx:          push	bx
		push	dx
		xor	bx,bx
		dec	ax
		mov	dx,ax
		inc	dx
@@loop:		cmp	al,kpos[bx]
		je	SHORT @@out_bx
		cmp	dl,kpos[bx]
		je	SHORT @@out_bx
		inc	bx
		cmp	bx,7
		jb	SHORT @@loop
		mov	bx,32
@@out_bx:	mov	ax,bx
		pop	dx
		pop	bx
		ret

testy:          mov	dx,ax
		xor	ax,ax
		mov	cx,4
@@loop:		cmp	dx,cx
		je	SHORT @@toend
		inc	cx
		cmp	cx,10
		jb	SHORT @@loop
		mov	ax,32
@@toend:        mov	ax,cx
		ret

datexy:		push	dx
		call	testx
		pop	dx
		push	ax
		mov	ax,dx
		call	testy
		pop	dx
		cmp	ax,32
		je	SHORT @@null
		cmp	dx,32
		je	SHORT @@null
		cmp	dx,dayofweek
		jae	SHORT @@
		cmp	ax,4
		jne	SHORT @@
@@null:		xor	ax,ax
		ret
@@:		cmp	ax,4
		je	SHORT @@l1
		cmp	ax,5
		je	SHORT @@l2
		cmp	ax,6
		je	SHORT @@l3
		cmp	ax,7
		je	SHORT @@l4
		cmp	ax,8
		je	SHORT @@l5
		cmp	ax,9
		je	SHORT @@l6
		jmp	SHORT @@null
@@l1:		mov	ax,1
		jmp	SHORT @@add
@@l2:           mov	ax,8
		jmp	SHORT @@add
@@l3:           mov	ax,15
		jmp	SHORT @@add
@@l4:           mov	ax,22
		jmp	SHORT @@add
@@l5:           mov	ax,29
		jmp	SHORT @@add
@@l6:           mov	ax,36
@@add:		add	ax,dx
		sub	ax,dayofweek
@@toend:	cmp	ax,numdaysinmonth
		ja	SHORT @@null
		ret
ENDIF

event_ESC:	inc	_end
		ret

event_MOUSE:    push	IDD_Calendar.rs_rect
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcxyrow
		or	ax,ax
		jz	SHORT event_ESC
		IFDEF	MOUSEDATE
		dec	ax
		cmp	ax,4
		jb	SHORT @@toend
		cmp	ax,9
		ja	SHORT @@toend
		push	ax
		call	mousex
		pop	dx
		cmp	ax,(XPOS+1)
		jbe	SHORT @@toend
		movzx	bx,kpos[6]
		add	bx,2
		cmp	ax,bx
		jnb	SHORT @@toend
		call	datexy
		or	ax,ax
		jz	SHORT @@toend
		mov	day,ax
		call	putdata
		ENDIF
@@toend:        call	mousep
		or	ax,ax
		jnz	SHORT @@toend
		ret

modal:          cmp	_end,0
		jnz	SHORT @@toend
		call	tgetevent
		mov	cx,key_count
		xor	bx,bx
@@keyloop:	cmp	ax,[bx.key_local]
		je	SHORT @@exe
		add	bx,2
		loop	SHORT @@keyloop
		jmp	SHORT modal
@@exe:		call	[bx.key_proc]
		jmp	SHORT modal
@@toend:	ret

cmcalendar	PROC	PASCAL DIST
		PUBLIC	cmcalendar
LOCAL		dialog:	DWORD,\
		day:	WORD,\
		month:	WORD,\
		year:	WORD,\
		dayofweek: WORD,\
		numdaysinmonth:	WORD,\
		current_year: WORD,\
		current_month: WORD,\
		cons:	BYTE,\
		_end:	BYTE

		mov	al,console
		mov	cons,al
		mov	console,CON_UTIME
		xor	ax,ax
		mov	_end,al
		mov	current_year,ax
		mov	current_month,ax
		push	ds
		push	OFFSET IDD_Calendar
		call	rsopen
		or	ax,ax
		jz	SHORT @@toend
		mov     WORD PTR dialog,ax
		mov     WORD PTR dialog+2,dx
		push	dialog
		call	twshow
		call	current_date
		mov	dx,day
		mov	bx,month
		mov	cx,year
		call	set_date
		call	modal
		push	dialog
		call	twclose
		mov	al,cons
		mov	console,al
@@toend:	ret
cmcalendar	ENDP

CALENDAR_TEXT	ENDS

		END
