/*
 * STRTODW.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 *
 *  Modification: 20.03.07 - [dd.mm.yy | yyyy] | [mm/dd/yy | yyyy]
 *			     default: return current date
 */

#include <time.h>
#include <string.h>
#include <stdlib.h>

WORD strtodw(const char *p)
{
	WORD d,m,y,c;

	_ASSERTE(p == NULL);
	if (*p == 0) /* return current date */
		return dwdosdate();
	d = atoi(p);
	while (*p <= '9' && *p >= '0')
		p++;
	c = *p++;
	m = atoi(p);
	while (*p <= '9' && *p >= '0')
		p++;
	y = atoi(p + 1);
	if (y < 1900)
		if (y >= 80)
			y += 1900;
		else
			y += 2000;
	if (c == '/') /* mm/dd/yy */
		return dt_mkdw(m,d,y);
	return dt_mkdw(d,m,y);
}
