; TDEVENT.ASM--
; Copyright (c) 2004 Hjort Nidudsson
;
; Change history:
; 17 Nov 2008	- added KEY_HOME and KEY_END
; 16 Nov 2008	- added KEY_KPENTER
; 04 Apr 2004	- Created


include		clib.inc
include		dialog.inc
include		dos.inc

		.386p
		locals

_DATA		SEGMENT

tdialog		LABEL	DWORD
		PUBLIC	tdialog
tdoffdl		DW	?
tdsegdl		DW	?
tdllist		LABEL	DWORD
		PUBLIC	tdllist
tdoffll		DW	?
tdsegll		DW	?
tdoffss		DW	?

td_proctab	DW	case_ESC
		DW      case_LEFT
		DW      case_UP
		DW      case_RIGHT
		DW      case_DOWN
		DW      case_HOME
		DW      case_END
		DW      case_TAB
		DW      case_ENTER
		DW      case_ENTER
		DW      case_PGUP
		DW      case_PGDN
		DW      case_MOUSE

td_keytable	DW      KEY_ESC
		DW      KEY_LEFT
		DW      KEY_UP
		DW      KEY_RIGHT
		DW      KEY_DOWN
		DW      KEY_HOME
		DW      KEY_END
		DW      KEY_TAB
		DW      KEY_ENTER
		DW      KEY_KPENTER
		DW      KEY_PGUP
		DW      KEY_PGDN
		DW	MOUSECMD

key_count	=	(($ - td_keytable) / 2)

eventproc	DW	pbuttevent
		DW	radioevent
		DW	checkevent
		DW	xcellevent
		DW	teditevent
		DW	menusevent
		DW	xcellevent

_DATA		ENDS

_TEXT		SEGMENT

local_stack	PROC PASCAL	DIST
ARG		dialog:		DWORD
LOCAL		prevbp:		WORD,\	; init stack
		prevdlg:	DWORD,\	; init tdialog
		cursor:		DWORD,\	; init cursor
		ocursor:	DWORD,\	; object event cursor
		object:		DWORD,\	; dialog.object[index]
		orect:		DWORD,\	; dialog.object[index].rc
		oxpos:		WORD,\	; dialog.object[index].rc.x
		oypos:		WORD,\	; dialog.object[index].rc.y
		oxlen:		WORD,\	; dialog.object[index].rc.col
		oflag:		WORD,\	; dialog.object[index].flag
		mxpos:		WORD,\	; mouse temp x-pos
		mypos:		WORD,\	; mouse temp y-pos
		xlbuf:		WORD:[80],\
		event:		WORD,\	; active event
		result:		WORD	; active result
		ENDP

;-----------------------------------------------------------------------

LESOBJECTSI:	les	bx,dialog
		mov	ax,si
		jmp	SHORT LESOBJECTAX
LESOBJECT:	les	bx,dialog
		movzx	ax,es:[bx.dl_index]
LESOBJECTAX:	shl	ax,4			; item = 16 byte
		add	ax,WORD PTR es:[bx.dl_object]
		mov	bx,ax			; ES:BX to current object
		mov	ax,es:[bx.to_flag]	; AX to flag
		mov	oflag,ax
		ret

INITOBJECT:	lea	ax,ocursor
		push	ss
		push	ax
		mov	eax,es:[bx.to_rect]     ; ES:BX = current object
		les	bx,dialog
		add	ax,WORD PTR es:[bx.dl_rect]
		mov	orect,eax
		xor	dh,dh
		mov	dl,orect.rc_col
		mov	oxlen,dx
		mov	dl,al
		mov	oxpos,dx
		mov	dl,ah
		mov	oypos,dx
		call	getcursor
		ret

OMOUSECMD:	call	mousex
		push	ax
		call	mousey
		pop	dx
		cmp	ax,oypos
		jne	SHORT @@false
		mov	ax,oxpos
		dec	ax
		cmp	dx,ax
		jb	SHORT @@false
		add	ax,2
		cmp	dx,ax
		jbe	SHORT @@true
@@false:	xor	ax,ax	; return ZF set and AX = MOUSECMD
		mov	ax,MOUSECMD
		ret
@@true:		or	ax,1	; return ZF clear if mouseclick
		ret

mouseloop:	call	mousep
		or	ax,ax   ; return ZF set and AX = 0
		jnz	SHORT mouseloop
		ret

;-----------------------------------------------------------------------

tdexechild:     les	bx,dialog
		call	LESOBJECTAX
		call	es:[bx.to_proc]
		mov	result,ax
		cmp	ax,_C_REOPEN
		jne	SHORT @@toend
		les	bx,dialog
		mov	al,es:[bx.dl_index]
		push	ax
		push	dialog
		call	tdinit
		pop	ax
		les	bx,dialog
		mov	es:[bx.dl_index],al
@@toend:	ret

;-----------------------------------------------------------------------

previtem:	test	[si.to_flag],_O_DEACT
		jz	SHORT cxtoindex
		sub	si,16
		dec	cx
		jnz	SHORT previtem
previtem_0:	xor	ax,ax
		ret
cxtoindex_if:	test	[si.to_flag],_O_DEACT
		jnz	SHORT previtem_0
cxtoindex:	les	bx,dialog
		dec	cx
		mov	es:[bx.dl_index],cl
		mov	ax,1
		or	ax,ax
		ret

tdprevitem:	push	ds
		push	si
		lds	si,dialog
		xor	cx,cx
		add	cl,[si.dl_index]
		jz	SHORT @@last
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		call	previtem
		jnz	SHORT @@toend
		lds	si,dialog
		xor	cx,cx
@@last:		add	cl,[si.dl_count]
		jz	SHORT @@null
		mov	bl,[si.dl_index]
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		xor	ax,ax
@@loop:		cmp	bl,cl
		ja	SHORT @@null
		test	[si.to_flag],_O_DEACT
		jz	SHORT @@ok
		sub	si,16
		dec	cx
		jnz	SHORT @@loop
@@null:		xor	ax,ax
@@toend:	pop	si
		pop	ds
		ret
@@ok:		call	cxtoindex
		jmp	SHORT @@toend

;-----------------------------------------------------------------------

tditemleft:	push	ds
		push	si
		lds	si,dialog
		xor	cx,cx
		add	cl,[si.dl_index]
		jz	SHORT @@null
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		mov	bx,WORD PTR [si.to_rect.16]
@@loop:		cmp	bh,[si.to_rect.rc_y]
		jne	SHORT @@next
		cmp	bl,[si.to_rect.rc_x]
		jbe	SHORT @@next
		call	cxtoindex_if
		jnz	SHORT @@toend
@@next:		sub	si,16
		dec	cx
		jnz	SHORT @@loop
@@null:		xor	ax,ax
@@toend:	pop	si
		pop	ds
		ret

;-----------------------------------------------------------------------

tdnextitem:	push	ds
		push	si
		push	di
		lds	si,dialog
		movzx	di,[si.dl_count]
		movzx	cx,[si.dl_index]
		inc	cx
		lds	si,[si.dl_object]
		mov	ax,cx
		shl	ax,4
		add	si,ax
		inc	cx
@@loop:         cmp	cx,di
		ja	SHORT @@2
		call	cxtoindex_if
		jnz	SHORT @@toend
		inc	cx
		add	si,16
		jmp	SHORT @@loop
@@2:		lds	si,dialog
		movzx	di,[si.dl_index]
		inc	di
		mov	cx,1
		lds	si,[si.dl_object]
@@loop2:	cmp	cx,di
		ja	SHORT @@null
		call	cxtoindex_if
		jnz	SHORT @@toend
		inc	cx
		add	si,16
		jmp	SHORT @@loop2
@@null:		xor	ax,ax
@@toend:        pop	di
		pop	si
		pop	ds
		ret

;-----------------------------------------------------------------------

tditemright:	push	ds
		push	si
		push	di
		lds	si,dialog
		movzx	di,[si.dl_count]
		movzx	cx,[si.dl_index]
		inc	cx
		lds	si,[si.dl_object]
		mov	ax,cx
		shl	ax,4
		add	si,ax
		mov	bx,WORD PTR [si.to_rect-16]
		inc	cx
@@loop:         cmp	cx,di
		ja	SHORT @@null
		cmp	bh,[si.to_rect.rc_y]
		jne	SHORT @@next
		cmp	bl,[si.to_rect.rc_x]
		jae	SHORT @@next
		call	cxtoindex_if
		jnz	SHORT @@toend
@@next:         inc	cx
		add	si,16
		jmp	SHORT @@loop
@@null:		xor	ax,ax
@@toend:        pop	di
		pop	si
		pop	ds
		ret

;-----------------------------------------------------------------------

case_MOUSE:     call	mousex
		mov	mxpos,ax
		call	mousey
		mov	mypos,ax
		les	bx,dialog
		push	es:[bx.dl_rect]
		push	mxpos
		push	ax
		call	rcxyrow
		or	ax,ax
		jnz	SHORT @@do
		jmp	case_ESC

@@do:		les	bx,dialog
		movzx	ax,es:[bx.dl_rect.rc_x]
		mov	oxpos,ax
		sub	mxpos,ax
		mov	al,es:[bx.dl_rect.rc_y]
		mov	oypos,ax
		sub	mypos,ax

		push	si
		xor	si,si
@@objloop:	les	bx,dialog
		movzx	ax,es:[bx.dl_count]
		cmp	ax,si
		ja	SHORT @@loop
		jmp	@@endl

@@loop:		push	es:[bx.dl_rect]
		call	LESOBJECTSI
		push	es:[bx.to_rect]
		call	rcaddrc
		mov	WORD PTR orect,ax
		mov	WORD PTR orect+2,dx
		test	es:[bx.to_flag],_O_DEACT
		jnz	SHORT @@deact
		push	es:[bx.to_rect]
		push	mxpos
		push	mypos
		call	rcxyrow
		or	ax,ax
		jz	SHORT @@next

		les	bx,dialog
		mov	ax,si
		mov	es:[bx.dl_index],al
		call	LESOBJECTSI
		push	ax
		and	ax,000Fh
		cmp	ax,_O_PBUTT
		jnz	SHORT @@nopb
		mov	al,orect.rc_x
		push	ax
		mov	al,orect.rc_y
		push	ax
		mov	al,orect.rc_col
		push	ax
		call	pbuttms
@@nopb:		pop	ax
		test	ax,_O_DEXIT
		jz	SHORT @@0
		mov	result,_C_ESCAPE
		pop	si
		ret

@@0:		test	ax,_O_CHILD
		jz	SHORT @@1
		mov	ax,si
		pop	si
		call	tdexechild
		ret

@@1:            pop	si
		and	ax,000Fh
		cmp	ax,_O_PBUTT
		je	SHORT @@exit
		cmp	ax,_O_MENUS
		je	SHORT @@exit
		cmp	ax,_O_XHTML
		je	SHORT @@exit
		mov	result,_C_NORMAL
		ret

@@exit:		mov	result,_C_RETURN
		ret

@@next:		inc	si
		jmp	@@objloop

@@deact:	push	bx
		push	es:[bx.to_rect]
		push	mxpos
		push	mypos
		call	rcxyrow
		pop	bx
		or	ax,ax
		jz	SHORT @@next

		mov	ax,es:[bx.to_flag]
		and	al,0Fh
		cmp	al,_O_LLMSU
		je	SHORT @@llmsu
		cmp	al,_O_LLMSD
		je	SHORT @@llmsd
		cmp	al,_O_MOUSE
		jne	SHORT @@next

		mov	ax,es:[bx.to_flag]
		test	ax,_O_CHILD
		jz	SHORT @@next
		mov	ax,si
		pop	si
		jmp	tdexechild

@@llmsu:        pop	si
		jmp	SHORT ll_mouseup

@@llmsd:        pop	si
		jmp	SHORT ll_mousedn

@@endl:		pop	si
		les	bx,dialog
		push	es:[bx.dl_rect]
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcxyrow
		cmp	ax,1
		jne	SHORT @@mouse
@@mov:		push	dialog
		call	twmove
@@mouse:	call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
@@toend:	mov	result,_C_NORMAL
		ret

mouse_delay:	call	mousep
		or	ax,ax
		jnz	SHORT @@delay
		ret
@@delay:	call	scroll_delay
		call	scroll_delay
		or	ax,1
		ret

ll_mouseup:     les	bx,tdllist
		xor	ax,ax
		cmp	ax,es:[bx.ll_count]
		jz	SHORT end_scroll
		mov	dx,es:[bx.ll_dlgoff]
		mov	es:[bx.ll_celoff],ax
		les	bx,tdialog
		cmp	dl,es:[bx.dl_index]
		mov	es:[bx.dl_index],dl
		je	SHORT .mouseup
		ret

.mouseup:	call	case_UP
		or	ax,ax
		jz	SHORT end_scroll
		call	mouse_delay
		jnz	SHORT .mouseup
		jmp	SHORT end_scroll

ll_mousedn:     les	bx,tdllist
		xor	ax,ax
		cmp	ax,es:[bx.ll_count]
		jz	SHORT end_scroll

		mov	ax,es:[bx.ll_numcel]
		dec	ax
		mov	es:[bx.ll_celoff],ax
		add	ax,es:[bx.ll_dlgoff]
		les	bx,tdialog
		cmp	al,es:[bx.dl_index]
		mov	es:[bx.dl_index],al
		je	SHORT .mousedn
		xor	ax,ax
		ret

.mousedn:	call	case_DOWN
		or	ax,ax
		jz	SHORT end_scroll
		call	mouse_delay
		jnz	SHORT .mousedn

end_scroll:	call	mouseloop
		mov	ax,_C_NORMAL
		ret

		;-------------------------------------------------------

case_LIST:	call	LESOBJECT
		test	ax,_O_LLIST
		jnz	SHORT @@toend
		and	al,0Fh
		cmp	al,_O_MENUS
		je	SHORT @@toend
		mov	result,_C_NORMAL
		pop	ax
@@toend:	ret

		;-------------------------------------------------------

case_HOME:	call	case_LIST
		je	SHORT @@menus

@@llist:	xor	ax,ax
		les	bx,tdllist
		mov     es:[bx.ll_index],ax
		mov     es:[bx.ll_celoff],ax
		push	es:[bx.ll_dlgoff]
		call    es:[bx.ll_proc]
		pop	ax

@@menus:	les	bx,tdialog
		mov	es:[bx.dl_index],al
		call	tdnextitem
		call	tdprevitem
		ret

		;-------------------------------------------------------

case_LEFT:	call	LESOBJECT
		and	ax,000Fh
		cmp	ax,_O_MENUS
		je	SHORT .MENUS
		call	tditemleft
		jz	SHORT case_UP
		ret
.MENUS:		jmp	return_event	; return LEFT/RIGHT if MENUS

		;-------------------------------------------------------

case_RIGHT:	call	LESOBJECT
		and	ax,000Fh
		cmp	ax,_O_MENUS
		je	SHORT .MENUS
		call	tditemright
		jz	SHORT case_DOWN
		ret

		;-------------------------------------------------------

case_UP:	call	LESOBJECT
		and	ax,_O_LLIST
		jz	SHORT case_prev

		xor	ax,ax
		les	bx,tdllist
		cmp	ax,es:[bx.ll_celoff]
		jne	SHORT case_prev
		cmp	ax,es:[bx.ll_index]
		je	SHORT return_null

		mov	dx,es:[bx.ll_dlgoff]
		les	bx,tdialog
		cmp	es:[bx.dl_index],dl
		je	SHORT list_UP
		mov	es:[bx.dl_index],dl
		inc	ax
		ret

list_UP:	les	bx,tdllist
		dec	es:[bx.ll_index]
		jmp	SHORT return_llproc

case_prev:	call	tdprevitem
		ret

		;-------------------------------------------------------

case_DOWN:	call	LESOBJECT
		and	ax,_O_LLIST
		jz	SHORT case_next

		les	bx,tdllist
		mov	cx,es:[bx.ll_dcount]
		mov	dx,es:[bx.ll_celoff]

		mov	ax,cx
		dec	ax
		cmp	ax,dx
		je	SHORT @@

		mov	ax,dx
		add	ax,es:[bx.ll_index]
		inc	ax
		cmp	ax,es:[bx.ll_count]
		jb	SHORT case_next

@@:             mov	ax,es:[bx.ll_dlgoff]
		add	ax,dx
		les	bx,tdialog
		mov	ah,es:[bx.dl_index]	; align dialog index
		mov	es:[bx.dl_index],al
		cmp	al,ah
		jne	SHORT return_normal

		les	bx,tdllist
		mov	ax,es:[bx.ll_count]
		sub	ax,es:[bx.ll_index]
		sub	ax,cx
		jle	SHORT return_null	; no more items in list
		inc	es:[bx.ll_index]

		;-------------------------------------------------------

return_llproc:	call    es:[bx.ll_proc]
		jmp	SHORT return_ax
return_event:	inc	di
return_null:	xor	ax,ax
return_ax:	mov	result,ax
		ret
return_normal:	mov	result,_C_NORMAL
		ret

		;-------------------------------------------------------

case_TAB:	call	LESOBJECT
		and	ax,_O_LLIST
		jz	SHORT case_next
		les	bx,tdllist
		mov	ax,es:[bx.ll_dlgoff]
		add	ax,es:[bx.ll_dcount]
		les	bx,dialog
		mov	es:[bx.dl_index],al
		jmp	SHORT return_normal

case_next:	call	tdnextitem
		ret

		;-------------------------------------------------------

case_ESC:	mov	result,_C_ESCAPE
		ret

		;-------------------------------------------------------

case_PGUP:      call	case_LIST
		je	SHORT @@menus

		les	bx,tdllist
		xor	ax,ax
		cmp	ax,es:[bx.ll_celoff]
		je	SHORT @@index

		mov	es:[bx.ll_celoff],ax
		mov	ax,es:[bx.ll_dlgoff]
		les	bx,tdialog
		mov	es:[bx.dl_index],al
@@toend:	mov	result,_C_NORMAL
		ret

@@index:	cmp	ax,es:[bx.ll_index]
		je	SHORT @@toend

		mov	ax,es:[bx.ll_dcount]
		cmp	ax,es:[bx.ll_index]
		jbe	SHORT @@pgup

@@menus:	jmp	case_HOME

@@pgup:		sub	es:[bx.ll_index],ax
		jmp	SHORT return_llproc

		;-------------------------------------------------------

case_PGDN:      call	case_LIST
		je	SHORT case_END

		les	bx,tdllist
		mov	ax,es:[bx.ll_dcount]
		dec	ax
		cmp	ax,es:[bx.ll_celoff]
		je	SHORT @@

		mov	ax,es:[bx.ll_numcel]
		add	ax,es:[bx.ll_dlgoff]
		dec	ax
		les	bx,tdialog
		mov	es:[bx.dl_index],al
		mov	result,_C_NORMAL
		ret

@@:		add	ax,es:[bx.ll_celoff]
		add	ax,es:[bx.ll_index]
		inc	ax
		cmp	ax,es:[bx.ll_count]
		jnb	SHORT case_END
		mov	ax,es:[bx.ll_dcount]
		add	es:[bx.ll_index],ax
		jmp	return_llproc

		;-------------------------------------------------------

case_END:       call	case_LIST
		jne	SHORT @@llist

@@menus:	les	bx,tdialog
		mov	al,es:[bx.dl_count]
		dec	al
		mov	es:[bx.dl_index],al
		call	tdprevitem
		call	tdnextitem
		ret

@@llist:	les	bx,tdllist
		mov	ax,es:[bx.ll_count]
		cmp	ax,es:[bx.ll_dcount]
		jae	SHORT @@sub

		mov	ax,es:[bx.ll_numcel]
		dec	ax
		mov	es:[bx.ll_celoff],ax
		add	ax,es:[bx.ll_dlgoff]
		les	bx,tdialog
		mov	es:[bx.dl_index],al
		mov	result,_C_NORMAL
		ret

@@sub:		sub	ax,es:[bx.ll_dcount]
		cmp	ax,es:[bx.ll_index]
		je	SHORT @@null

		mov	es:[bx.ll_index],ax
		mov	ax,es:[bx.ll_dcount]
		dec	ax
		mov	es:[bx.ll_celoff],ax
		add	ax,es:[bx.ll_dlgoff]
		les	bx,tdialog
		mov	es:[bx.dl_index],al
		les	bx,tdllist
		jmp	return_llproc
@@null:		jmp	return_null

		;-------------------------------------------------------

case_ENTER:     call	LESOBJECT
		and	ax,_O_CHILD
		mov	ax,_C_RETURN
		jnz	SHORT @@exe
		mov	result,ax
		ret

@@exe:		les	bx,dialog
		movzx	ax,es:[bx.dl_index]
		call	tdexechild
		ret

;-----------------------------------------------------------------------

tdshortkey:     push	ax
		test	es:[bx.to_flag],_O_DEACT
		jnz	SHORT @@null
		cmp     es:[bx.to_ascii],0
		je	SHORT @@null
		and	al,0DFh
		cmp     es:[bx.to_ascii],al
		je	SHORT @@ok
		mov     al,es:[bx.to_ascii]
		and	al,0DFh
		sub	al,'A'
		push	bx
		movzx	bx,al
		cmp	ah,key_scancode[bx]
		pop	bx
		jne	SHORT @@null
@@ok:		or	ax,1
		jmp	SHORT @@toend
@@null:         xor	ax,ax
@@toend:        pop	ax
		ret

tdhndevent:	or	ax,ax
		jnz	SHORT @@do
		ret
@@do:		push	si
		xor	edx,edx
		mov	si,dx
		les	bx,tdialog
		movzx	cx,es:[bx.dl_count]
		les	bx,es:[bx.dl_object]
@@loop:         cmp	ax,KEY_F1
		je	SHORT @@case_F1
		test	es:[bx.to_flag],_O_GLCMD
		jz	SHORT @@tskey
		mov	edx,es:[bx.to_data]
@@tskey:	call	tdshortkey
		jnz	SHORT @@shortkey
		add	bx,16
		inc	si
		dec	cx
		jnz	SHORT @@loop
		or	dx,dx
		jz	SHORT @@null
		mov	bx,dx
		shr	edx,16
		mov	es,dx
@@nkey:		cmp	es:[bx.gl_key],0
		jz	SHORT @@null
		cmp	es:[bx.gl_key],ax
		je	SHORT @@gl_proc
		add	bx,SIZE S_GLCMD
		jmp	SHORT @@nkey
@@gl_proc:      call	es:[bx.gl_proc]
		jmp	SHORT @@toend
@@null:		xor	ax,ax
		jmp	SHORT @@toend
@@shortkey:	mov	ax,si
		les	bx,dialog
		mov	es:[bx.dl_index],al
		mov	ax,1
@@toend:        pop	si
		ret

@@case_F1:      test	es:[bx.to_flag],_O_DHELP
		jz	SHORT @@thelp
		call    es:[bx.to_proc]
		jmp	SHORT @@toend
@@thelp:	cmp	thelp,0
		jz	SHORT @@toend
		call	thelp
		jmp	SHORT @@toend

tdhandle_event:	mov	cx,key_count
		xor	bx,bx
@@keyloop:	cmp	ax,[bx.td_keytable]
		je	SHORT @@exe
		add	bx,2
		dec	cx
		jnz	SHORT @@keyloop
		call	tdhndevent
		mov	result,ax
		ret
@@exe:		call	[bx.td_proctab]
		ret

;-----------------------------------------------------------------------

tdgetevent:     mov	ax,es:[bx.to_flag]
		and	ax,000Fh
		cmp	ax,6
		ja	SHORT @@
		add	ax,ax
		xchg	ax,bx
		jmp	eventproc[bx]
@@:	DBUG	push	40
	DBUG	push	40
	DBUG	call	beep
		mov	ax,KEY_ESC
		ret

_TEXT		ENDS

;************** int tdlevent(DOBJ *, LOBJ *)

PPROC		tdlevent
ARG		@@dl:	DWORD,\
		@@ll:	DWORD
		mov	eax,tdllist
		xchg	eax,@@ll
		mov	tdllist,eax
		push	@@dl
		call	tdevent
		mov	edx,@@ll
		mov	tdllist,edx
		ret
PEND		tdlevent

;*************** int tdevent(DOBJ *)

PPROC		tdevent
ARG		dialog:		DWORD
LOCAL		prevbp:		WORD,\	; init stack
		prevdlg:	DWORD,\	; init tdialog
		cursor:		DWORD,\	; init cursor
		ocursor:	DWORD,\	; object event cursor
		object:		DWORD,\	; dialog.object[index]
		orect:		DWORD,\	; dialog.object[index].rc
		oxpos:		WORD,\	; dialog.object[index].rc.x
		oypos:		WORD,\	; dialog.object[index].rc.y
		oxlen:		WORD,\	; dialog.object[index].rc.col
		oflag:		WORD,\	; dialog.object[index].flag
		mxpos:		WORD,\	; mouse temp x-pos
		mypos:		WORD,\	; mouse temp y-pos
		xlbuf:		WORD:[80],\
		event:		WORD,\	; active event
		result:		WORD	; active result

		USES	si,di
		mov	eax,tdialog	; save tdialog and stack pointer
		mov	prevdlg,eax
		mov	ax,tdoffss
		mov	prevbp,ax
		mov	tdoffss,bp

		les	bx,dialog
		mov	tdsegdl,es	; set global pointer to *this
		mov	tdoffdl,bx

		mov	si,es:[bx.dl_flag]
		test	si,_D_DOPEN
		jnz	SHORT @@visible	; if not open -- open it
		push	dialog
		call	twopen
		or	ax,ax
		jz	SHORT @@toend

@@visible:	test	si,_D_ONSCR
		jnz	SHORT @@getcursor; if hidden -- make it visible
		push	dialog
		call	twshow
		or	ax,ax
		jz	SHORT @@toend

@@getcursor:	lea	ax,cursor
		push	ss
		push	ax
		call	getcursor 	; save cursor
		call	cursoroff	; turn cursor off

		call	LESOBJECT	; test to see if current
		and	ax,_O_DEACT     ; item is active
		jz	SHORT @@mwait
		call	tdnextitem      ; move to next item
		jz	SHORT @@toend   ; if exist..

@@mwait:	call	mouseloop	; wait for mouse
		xor	di,di		; main switch
		jmp	SHORT @@loop

@@toend:        mov	edx,prevdlg	; reset global pointers
		mov	tdialog,edx
		mov	dx,prevbp
		mov	tdoffss,dx
		ret			; return result

@@extproc:	call	es:[bx.to_proc]	; extern event handler
		jmp	SHORT @@set
@@loop:		mov	result,0
		call	LESOBJECT
		and	ax,_O_EVENT
		jnz	SHORT @@extproc
		call	tdgetevent
@@set:		mov	event,ax
		call	tdhandle_event
		cmp	result,_C_ESCAPE
		je	SHORT @@esc
		cmp	result,_C_RETURN
		je	SHORT @@return
		or	di,di
		jz	SHORT @@loop

@@break:	push	cursor
		call	setcursor
		mov	ax,event
		jmp	SHORT @@toend

@@esc:		mov	event,0
		jmp	SHORT @@break

@@return:	cmp	event,KEY_ENTER
		jne	SHORT @@index
		call	LESOBJECT
		and	ax,_O_DEXIT
		jnz	SHORT @@esc

@@index:	les	bx,dialog
		movzx	ax,es:[bx.dl_index]
		inc	ax
		mov	event,ax
		jmp	SHORT @@break
PEND		tdevent

_TEXT		SEGMENT

;-----------------------------------------------------------------------
; _O_PBUTT

pbuttevent:     mov	bx,ax
		call	INITOBJECT
		jz	SHORT @@
		call	cursoroff
@@:             push	oxpos
		push	oypos
		push	oxlen
		call	pbuttset
		call	tgetevent
		push	ax
		push	ocursor
		push	oxpos
		push	oypos
		push	oxlen
		call	pbuttclr
		call	setcursor
		pop	ax
		ret

;-----------------------------------------------------------------------
;_O_RBUTT

OGOTOXY:        mov	bx,ax
		call	INITOBJECT
		jnz	SHORT @@
		call	cursoron
@@:             inc	oxpos
		push	oxpos
		push	oypos
		call	gotoxy
		ret

xorradioflag:	call	LESOBJECT
		and	ax,_O_RADIO
		jz	SHORT @@do
		call	mouseloop
		ret
@@do:		les	bx,dialog
		xor	cx,cx
		add	cl,es:[bx.dl_count]
		jz	SHORT @@toend
		les	bx,es:[bx.dl_object]
@@loop:		test	es:[bx.to_flag],_O_RADIO;_O_RBUTT
		jz	SHORT @@next
		and	es:[bx.to_flag],(not _O_RADIO)
		push	es
		push	bx
		push	cx
		push	dialog
		push	es
		push	bx
		call	tdinitobj
		pop	cx
		pop	bx
		pop	es
@@next:		add	bx,16
		dec	cx
		jnz	SHORT @@loop
		call	LESOBJECT
		or	es:[bx.to_flag],_O_RADIO
		push	dialog
		push	es
		push	bx
		call	tdinitobj
		call	mouseloop
		inc	ax
@@toend:	ret

radioevent:	call	OGOTOXY
@@event:	call	tgetevent
		cmp	ax,MOUSECMD
		je	SHORT @@mouse
		cmp	ax,KEY_SPACE
		je	SHORT @@set
		jmp	SHORT oreturn
@@mouse:        call	OMOUSECMD
		jz	SHORT oreturn
@@set:		call	xorradioflag
		test	oflag,_O_EVENT
		jz	SHORT @@event
		mov	ax,KEY_SPACE
			;-----------------------------------------------
			; Reset cursor position
			;
oreturn:	push	ax
		push	ocursor
		call	setcursor
		pop	ax
		ret

;-----------------------------------------------------------------------
;_O_CHBOX

xorswitchflag:	call	LESOBJECT
		push	oxpos
		push	oypos
		push	1
		mov	ax,' '
		xor	es:[bx.to_flag],_O_FLAGB
		test	es:[bx.to_flag],_O_FLAGB
		jz	SHORT @@clear
		mov	al,'x'
@@clear:	push	ax
		call	scputw
		call	mouseloop
		ret

checkevent:	call	OGOTOXY
@@event:	call	tgetevent
		cmp	ax,MOUSECMD
		je	SHORT @@mouse
		cmp	ax,KEY_SPACE
		je	SHORT @@set
		jmp	SHORT oreturn
@@mouse:        call	OMOUSECMD
		jz	SHORT oreturn
@@set:		call	xorswitchflag
		test	oflag,_O_EVENT
		jz	SHORT @@event
		mov	ax,KEY_SPACE
		jmp	SHORT oreturn

;-----------------------------------------------------------------------
;_O_XCELL

testxyrow:	push	orect
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcxyrow
		or	ax,ax
		mov	ax,MOUSECMD
		ret

selectobj:	push	orect
		push	ss
		lea	ax,xlbuf
		push	ax
		push	ss
		push	ax
		push	oxlen
		mov	dl,at_background[B_DarkGray]
		push	dx
		push	orect
		push	ss
		push	ax
		call	rcread
		call	wcputbg
		call	rcxchg
		ret

deselectobj:	push	ax
		push	orect
		push	ss
		lea	ax,xlbuf
		push	ax
		call	rcwrite
		pop	ax
		ret

xcellevent:     mov	bx,ax
		call	INITOBJECT
		jz	SHORT @@celid
		call	cursoroff
@@celid:	test	oflag,_O_LLIST
		jz	SHORT @@select
		les	bx,dialog		; update index in list
		movzx	ax,es:[bx.dl_index]
		les	bx,tdllist
		cmp	ax,es:[bx.ll_dlgoff]
		jb	SHORT @@select
		sub	ax,es:[bx.ll_dlgoff]
		cmp	ax,es:[bx.ll_numcel]
		jae	SHORT @@select
		mov	es:[bx.ll_celoff],ax
@@select:	call	selectobj
@@loop:		call	tgetevent
		cmp	ax,MOUSECMD
		jne	SHORT @@endl
		call	testxyrow
		jz	SHORT @@endl
		push	oxpos
		push	oypos
		push	oxlen
		call	mousewait
		mov	ax,oflag
		and	ax,000Fh
		cmp	ax,_O_XHTML		; return if html
		mov	ax,KEY_ENTER
		je	SHORT @@endl
		push	si
		mov	si,10
@@wait:		push	16			; wait for dobbel-click
		call	delay
		call	mousep
		jnz	SHORT @@mousep
		dec	si
		jnz	SHORT @@wait
@@mousep:	call	mousep
		or	ax,ax
		jz	SHORT @@null
		call	testxyrow
		jz	SHORT @@null
		mov	ax,KEY_ENTER
		jmp	SHORT @@pop
@@null:         xor	ax,ax
@@pop:		pop	si
@@endl:		or	ax,ax
		jz	SHORT @@loop
		jmp	deselectobj

;-----------------------------------------------------------------------
;_O_TEDIT

teditevent:     mov	bx,ax
		push	es:[bx.to_data]
		mov	eax,es:[bx.to_rect]
		movzx	cx,es:[bx.to_count]	; size of buffer in para
		les	bx,dialog
		add	ax,WORD PTR es:[bx.dl_rect]
		push	eax
		shl	cx,4                    ; * 16
		push	cx
		call	tdedit
		ret

;-----------------------------------------------------------------------
;_O_MENUS

menusevent:     mov	bx,ax
		call	INITOBJECT
		jz	SHORT @@
		call	cursoroff
@@:             call	LESOBJECT
		xor	eax,eax
		cmp	es:[bx.to_data],eax
		jz	SHORT @@no_data
		push	20
		mov	dx,es
		mov	es,ax
		mov	al,es:[0484h]
		mov	es,dx
		push	ax
		push	0
		push	58
		push	es:[bx.to_data]
		push	20
		push	ax
		push	59
		mov	al,' '
		mov	ah,at_background[B_Menus]
		or	ah,at_foreground[F_Menus]
		push	ax
		call	scputw
		call	scputs
@@no_data:	call	selectobj
		call	tgetevent
		jmp	deselectobj

;-----------------------------------------------------------------------
;_O_XHTML

;-----------------------------------------------------------------------
;_O_MOUSE

;-----------------------------------------------------------------------
;_O_LLMSU

;-----------------------------------------------------------------------
;_O_LLMSD

extern_event:	push	bp
		mov	bp,tdoffss
		push	ax
		call	LESOBJECT
		pop	dx
		and	ax,_O_STATE
		jnz	SHORT @@error
		mov	ax,bx
		call	dx
@@toend:        pop	bp
		ret
@@error:	mov	ax,KEY_ESC
		jmp	SHORT @@toend

;*************** int tdteditevent(void)

tdteditevent	PROC	DIST
		PUBLIC	tdteditevent
		mov	ax,OFFSET teditevent
		call	extern_event
		ret
tdteditevent	ENDP

;*************** int tdxcellevent(void)

tdxcellevent	PROC	DIST
		PUBLIC	tdxcellevent
		mov	ax,OFFSET xcellevent
		call	extern_event
		ret
tdxcellevent	ENDP

;*************** int tdcheckevent(void)

tdcheckevent	PROC	DIST
		PUBLIC	tdcheckevent
		mov	ax,OFFSET checkevent
		call	extern_event
		ret
tdcheckevent	ENDP

;*************** int tdradioevent(void)

tdradioevent	PROC	DIST
		PUBLIC	tdradioevent
		mov	ax,OFFSET radioevent
		call	extern_event
		ret
tdradioevent	ENDP

;*************** int tdpbuttevent(void)

tdpbuttevent	PROC	DIST
		PUBLIC	tdpbuttevent
		mov	ax,OFFSET pbuttevent
		call	extern_event
		ret
tdpbuttevent	ENDP

_TEXT		ENDS

		END
