; OSEEK.ASM--
; Copyright (c) 2008 Hjort Nidudsson
;
; BOOL oseek(offset, orig)  - Seek and Read
; BOOL oseekl(offset, orig) - Seek only
;
; Change history:
; 21 Aug 2008	- Moves file pointer STDI

INCLUDE 	clib.inc
INCLUDE 	iost.inc
INCLUDE 	io.inc
INCLUDE		errno.inc

PPROC		oseekl
ARG		offs:	DWORD,\
		orig:	WORD
		USES	si
		mov	si,OSTDI
		call	seekst
		ret
PEND		oseekl

PPROC		oseek
ARG		offs:	DWORD,\
		orig:	WORD
		USES	si
		mov	si,OSTDI
		call	seekst
		jz	SHORT @@toend
		call	ofread
@@toend:	ret
PEND		oseek

_TEXT		SEGMENT

seekst:         mov	ax,orig
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@memseek
		cmp	ax,SEEK_CUR
		je	SHORT @@seekcur
@@seek:		mov	dx,WORD PTR offs
		mov	cx,WORD PTR offs+2
		mov	ah,42h
		mov	bx,[si.ios_file]
		int	21h
		jc	SHORT @@ioerror
		push	dx
		push	ax
		pop	eax
@@set:		mov	[si.ios_offs],eax
		xor	ax,ax
		mov	[si.ios_i],ax
		mov	[si.ios_c],ax
		inc	ax
		ret
@@seekcur:	movzx	edx,[si.ios_c]
		sub	dx,[si.ios_i]
		cmp	edx,offs
		jb	SHORT @@seek
		mov	edx,offs
		add	[si.ios_i],dx
		ret
@@ioerror:	push	ax
		call	dosmaperr
@@error:	xor	ax,ax
		ret
@@memseek:	cmp	ax,SEEK_CUR
		je	SHORT @@error
		cmp	ax,SEEK_END
		je	SHORT @@memend
		mov	eax,offs
		jmp	SHORT @@set
@@memend:	xor	eax,eax
		dec	eax
		add	eax,offs
		jmp	SHORT @@set
_TEXT		ENDS

		END