;
; INI.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		io.inc
INCLUDE		string.inc

		.386P

OPENINI_READ	= 0001h
OPENINI_WRITE   = 0012h
OPENCFG_READ	= 1201h
OPENCFG_WRITE	= 1212h
OPENCMD_READ	= 2201h
OPENCMD_WRITE   = 2212h

_DATA		SEGMENT

		EXTRN	_argv	: DWORD
		EXTRN	_bufin	: BYTE

		PUBLIC	configfile
		PUBLIC	configfile_extp

configfile	DB	80 dup(0)
configfile_extp	DD	0

extini		LABEL	DWORD
		DB	'.INI'
extcfg		LABEL	DWORD
		DB	'.CFG'
extcmd		LABEL	DWORD
		DB	'.CMD'

_DATA		ENDS

_TEXT		SEGMENT

Install:	push	DS
		push	OFFSET configfile
		les	bx,_argv
		push	DWORD PTR ES:[bx]
		call	strcpy
		push	dx
		push	ax
		push	'.'
		call	strrchr
		mov	WORD PTR configfile_extp+2,dx
		sub	ax,4
		mov	WORD PTR configfile_extp,ax
		ret

filename:	les	bx,configfile_extp
		mov	ES:[bx],eax
		mov	BYTE PTR ES:[bx+4],0
		mov	dx,DS
		mov	ax,OFFSET configfile
		ret

read4096:	push    fhnd
		push	DS
		push	OFFSET _bufin
		push	4096
		call	osread
		mov	rsize,ax
firstw_0:	or	ax,ax
		ret
firstwinc:      inc	di
		dec	cx
		jcxz	SHORT firstw_0
firstword:      mov	al,[di]
		cmp	al,' '
		je	SHORT firstwinc
		cmp	al,9
		je	SHORT firstwinc
		ret

_TEXT		ENDS

PPROC		filename_CMD
		mov	eax,extcmd
		call	filename
		ret
PEND		filename_CMD

PPROC		filename_CFG
		mov	eax,extcfg
		call	filename
		ret
PEND		filename_CFG

PPROC		filename_INI
		mov	eax,extini
		call	filename
		ret
PEND		filename_INI

PPROC		iniopen
ARG		action:	WORD
		mov	bx,OFFSET extini
		mov	ax,action
		shr	ax,10
		add     bx,ax
		mov	eax,[bx]
		call	filename
		push	dx
		push	ax
		mov	ax,action
		mov	al,ah
		and	ax,000Fh
		push	ax
		mov	ax,action
		xor	ah,ah
		xor	dx,dx
		cmp	ax,1
		je	SHORT @@1
		inc	dx
@@1:		push	dx
		push	ax
		call	osopen
		ret
PEND		iniopen

PPROC		inientry
ARG		section:DWORD,\
		entry:	DWORD
LOCAL		rsize:	WORD,\
		fhnd:	WORD
USES		si,di

		push	OPENINI_READ
		call	iniopen
		cmp	ax,-1
		je	SHORT @@null
		mov	fhnd,ax
		push	section
		call	strlen
		mov	si,ax

@@read:		call	read4096
		jz	SHORT @@eof
		push	DS
		pop	ES
		mov	cx,rsize
		mov	di,OFFSET _bufin
		cld
@@scan5B:	mov	ax,0A5Bh
@@scan:		repnz	scasb
		or	cx,cx
		jz	SHORT @@read
		mov	dx,cx
		inc	dx
		cmp	dx,rsize
		je	SHORT @@section
		cmp	[di-2],ah
		jne	SHORT @@scan
		neg	dx
		mov	cx,0FFFFh
		mov	ax,4201h
		mov	bx,fhnd
		int	21h
		jc	SHORT @@eof
		jmp	SHORT @@read

@@section:	cmp	_bufin[si+1],']'
		jne	SHORT @@scan
		mov	dx,ES
		les	bx,section
@@cmpsec:	mov	al,ES:[bx]
		mov	ah,[di]
		inc	di
		inc	bx
		or	ax,2020h
		cmp	ah,al
		jne	SHORT @@entry
		dec	cx
		jnz	SHORT @@cmpsec
@@nextsec:	mov	ES,dx
		jmp	SHORT @@scan5B
@@eof:          push    fhnd
		call	close
@@null:		xor	ax,ax
		mov	dx,ax
@@toend:	ret

@@entry:	cmp	ax,7D20h
		jne	SHORT @@nextsec
;
; Section found, read entries
;
@@line:		mov	ax,000Ah
		mov	ES,dx
		repnz	scasb
		or	cx,cx
		jz	SHORT @@eof
		mov	al,[di]
		cmp	al,'['
		je	SHORT @@eof
		cmp	al,';'
		je	SHORT @@line
		call	firstword
		jz	SHORT @@eof

		les	bx,entry	; compare entry name
@@cmpe:		mov	al,[di]
		mov	ah,ES:[bx]
		or	ah,ah           ; match if entry name is zero
		jz	SHORT @@found
		or	ax,2020h
		cmp	ah,al
		jne	SHORT @@line
		inc	di
		inc	bx
		dec	cx
		jnz	SHORT @@cmpe
		jmp	SHORT @@eof
;
; Entry found, read entry info past the equal sign
;
@@found:	push    fhnd
		call	close

		call	firstword       ; find the equal sign
		jz	SHORT @@null
		mov	al,[di]
		cmp	al,'='
		jne	SHORT @@null

		inc	di
		call	firstword       ; find the start of string
		jz	SHORT @@null

		mov	si,di
@@cmp:          lodsb
		cmp	al,';'
		je	SHORT @@zero
		cmp	al,0Dh
		je	SHORT @@zero
		dec	cx
		jnz	SHORT @@cmp

@@zero:		xor	ax,ax
		mov	[si-1],al
		cmp	al,[di]
		je	SHORT @@null
		push	DS
		push	di
		call	strtrim
		or	ax,ax
		je	SHORT @@null
		mov	dx,DS
		mov	ax,di
		jmp	SHORT @@toend
PEND		inientry

PPROC		inientryid
ARG		@@sec:	DWORD,\
		@@id:	WORD
LOCAL		@@entry: DWORD
		xor	eax,eax
		mov	ax,@@id
@@10:		cmp	al,10
		jb	SHORT @@
		inc	ah
		sub	al,10
		jmp	SHORT @@10
@@:		add	ax,'00'
		xchg	ah,al
		mov	@@entry,eax
		push	@@sec
		push	SS
		lea	ax,@@entry
		push	ax
		call	inientry
		ret
PEND		inientryid

INITPROC	Install 0 93

		END

