/*
 * FBALLOCF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <fblock.h>
#include <string.h>
#include <alloc.h>

FBLK *fballocff(const ffblk *ff, int flag)
{
	int size;
	FBLK *b;

	size = strlen(ff->ff_name) + sizeof(FBLK);
	if (!(b = (FBLK *)malloc(size)))
		return NULL;
	b->flag = (flag | ff->ff_attrib);
	b->size = ff->ff_fsize;
	b->date = ff->ff_fdate;
	b->time = ff->ff_ftime;
	strcpy(b->name, ff->ff_name);
	if (ISSUBDIR(b->flag) && stricmp(b->name, "..") == 0) {
		b->flag |= _A_UPDIR;
	} else if (!ISSUBDIR(b->flag)) {
		if (ISSYSTEM(b->flag) || ISHIDDEN(b->flag))
			strlwr(b->name + 1);
		else
			strlwr(b->name);
	}
	return b;
}