/*
 * DRVTYPE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <disk.h>

int _disk_type(int d)
{
	int q;

	if (d < 2) {
		if (_bios_disktype(d))
			return _DISK_FLOPPY;
		return _DISK_NOSUCHDRIVE;
	}
	q = _dos_remotedevice(d + 1);
	return (q == -1) ? _DISK_NOSUCHDRIVE :
		((q & (1 << 15))  ? _DISK_SUBST :
		((q & (1 << 12))  ? _DISK_NETWORK : _DISK_LOCAL));
}