/*
 * DRVTEST.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <disk.h>
#include <errno.h>

int _disk_test(int drive)
{
	int result;

	result = _disk_type(drive);
	if (result == _DISK_NOSUCHDRIVE)
		return 0;
	if (result == _DISK_LOCAL)
		return 1;
	if (_disk_ready(drive))
		return 1;
	if (errno == 2) {
		while (_disk_retry(drive) == 1) {
			if (_disk_ready(drive))
				return 1;
		}
	}
	return -1;
}
