/*
 * CMDELETE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <progress.h>
#include <errno.h>
#include <string.h>

static int wzipdelete(long size)
{
	int 	cx,sh,oh,sl;
	CZIP 	zf;
	ZCEN 	zc;
	DWORD 	ol;
	DWORD 	of;
	DWORD 	fz;
	DWORD 	ex;

	sl = wzipffindlocal(size);
	if (sl == -1)
		return -1;
	sh = arc_srchnd;
	oh = arc_outhnd;
	if (sl == 0) {
		close(oh);
		close(sh);
		arc_deltemp();
		return 1;
	}
	sl = 0;
	ol = zip_local.crc;
	ex = zip_local.csize;
	of = zip_local.fsize;
	zc.offset_sd = of;
	while (wzipreadcentral(sh, &zf, 0)) {
		cx = zf.extsize + zf.cmtsize;
		fz = sizeof(CZIP) + zf.fnsize + cx;
		if (ol == zf.offset_local) {
			if (cx)
				lseek(sh, cx, SEEK_CUR);
			sl++;
			continue;
		}
		if (zf.offset_local > ol)
			zf.offset_local -= ex;
		if (wzipcopycentral(sh, oh, &zf) == 0)
			break;
		of += fz;
	}
	if (zf.signature != ZID_ENDSENTR || progress_update(progress_size)) {
		close(sh);
		close(oh);
		arc_deltemp();
		return stderror(__outfile, EMARCHIVE, -1);
	}

	ol = zc.offset_sd;
	osread(sh, &zc, sizeof(ZCEN));
	zc.offset_sd = ol;
	zc.size_sd = of - ol;
	zc.entry_cur--;
	zc.entry_dir--;
	oswrite(oh, &zc, sizeof(ZCEN));
	if (zc.comment_size)
		copyhndl(sh, oh, zc.comment_size);
	close(sh);
	close(oh);
	if (zc.entry_cur + zc.entry_dir == 0) {
		arc_deltemp();
		arc_renametemp();
		return 2;
	}
	if (sl != 1) {
		arc_deltemp();
		return -1;
	}
	return arc_renametemp();
}

int wzipdel(WSUB *q, FBLK *b)
{
	int result;

	switch (confirm_delete_file(b->name, 0)) {
		case -1: return 1;
		case  0: return 0;
		default: break;
	}
	strfcat(__outfile, q->path, q->file);
	if (q->arch[0]) {
		strcpy(__outpath, q->arch);
		dostounix(__outpath);
	} else {
		__outpath[0] = 0;
	}
	strcpy(__srcfile, b->name);
	if (ISSUBDIR(b->flag))
		strcat(__srcfile, "/");
	result = wzipdelete(b->size);
	if (result == 1 && ISSUBDIR(b->flag))
		return 0;
	if (result == 1)
		stderror(b->name, EMNOENT, 1);
	if (result == 2)
		*q->flag &= ~_W_ARCHIVE;
	return result;
}
