; IOST.INC-- IO Bit Stream
; Copyright (c) 2008 Hjort Nidudsson

IOST_S		STRUC
		ios_bp		DD ?	; Base pointer
		ios_i		DW ?	; Current index
		ios_c		DW ?	; Byte count
		ios_memz	DW ?	; Buffer size
		ios_flag	DW ?    ; Bit flag
		ios_file	DW ?	; File handle
		ios_l		DW ?	; Count bits in Bit Buffer
		ios_bb		DD ?	; Bit Buffer | CRC
		ios_total	DD ?	; Read/Write count | File size
		ios_offs	DD ?	; Current offset | loop counter
		ios_flush	DD ?	; External flush proc
		ENDS			; 32 byte

OSIZE		= 	8000h
ISIZE		= 	4000h
DBITS		= 	14
DSIZE		= 	(1 shl DBITS)
CSIZE		= 	(DSIZE * 2)
LSIZE		= 	(CSIZE / 2)

GLOBAL  	_ios:	BYTE
OSTDI		EQU	OFFSET _ios
OSTDO		EQU	OSTDI + SIZE IOST_S

IO_SEARCHWORD   =	0001h	; Search whole words
IO_SEARCHCASE	=	0002h	; Case sensitive search
IO_SEARCHHEX    =	0004h	; Search hex string/ascii
IO_SEARCHSET	=	0008h	; Search entire scope
IO_SEARCHCUR	=	0010h	; Search from cursor/set
IO_SEARCHMASK	=	001Fh

IO_LWRD		=	0020h
IO_LWRC		=	0040h
IO_LOCK		=	0080h
IO_CRYPT	=	0100h	; Crypted file
IO_USEUPD	=	0200h	; Progress
IO_UPDTOTAL	=	0400h	; Add Read/Write size to total
IO_USECRC	=	0800h	; Update CRC on read/write
IO_USEBITS	=	1000h	; Align bits on read/write
IO_EXTFLUSH	=	2000h	; Extern flush proc
IO_MEMREAD	=	4000h	; Read from memory
IO_ERROR	=	8000h	; Write fault

SEEK_SET    	= 	0
SEEK_CUR    	= 	1
SEEK_END    	= 	2

GLOBAL PASCAL oinitst:	DIST	; int oinitst(WORD __offset);
GLOBAL PASCAL ofreest:	DIST	; int ofreest(WORD __offset);
GLOBAL PASCAL oclose:	DIST	; int oclose(WORD __offset);

GLOBAL PASCAL oputc:	DIST	; int oputc(int);
GLOBAL PASCAL oputb:	DIST    ; int oputb(WORD, int);
GLOBAL 	      ogetc:	DIST	; int ogetc(void);
GLOBAL PASCAL ogetb:	DIST	; int ogetb(int);
GLOBAL 	      ofwrite:	DIST    ; int ofwrite(void);
GLOBAL 	      ofread:	DIST	; int ofread(void);
GLOBAL PASCAL sputc:	DIST	; int sputc(WORD __offset, int);
GLOBAL PASCAL sputb:	DIST    ; int sputb(WORD __offset, WORD, int);
GLOBAL PASCAL ocopy:	DIST	; int ocopy(DWORD);
GLOBAL PASCAL odecrypt:	DIST
GLOBAL PASCAL odecode:	NEAR

GLOBAL PASCAL oflush:	DIST    ; int oflush(IOST *);
GLOBAL PASCAL oseek:	DIST	; int oseek(DWORD, int);  return ofread()
GLOBAL PASCAL oseekl:	DIST	; int oseekl(DWORD, int); no read
GLOBAL PASCAL offlush:	DIST    ; int offlush(void);
GLOBAL PASCAL ogets:	DIST	; char *ogets(int);
GLOBAL PASCAL oungetc:	DIST    ; int oungetc(void);
GLOBAL PASCAL owrite:	DIST    ; int owrite(IOST *, void *, WORD);
GLOBAL PASCAL oread:	DIST	; int oread(void *, WORD);
GLOBAL PASCAL oflushb:	DIST    ; int oflushb(WORD __dest, WORD __src);

GLOBAL PASCAL searchstring: BYTE:[128]
GLOBAL PASCAL osearch:	DIST
GLOBAL PASCAL onotfoundmsg: DIST
GLOBAL PASCAL continue_search: DIST
GLOBAL PASCAL cmdsearch: DIST	; (DWORD __fsize);
GLOBAL PASCAL osearchhex: DIST
GLOBAL PASCAL osearchtxt: DIST
GLOBAL PASCAL oupdate:	DIST    ; int oupdate(int);
GLOBAL oupdcrc:	NEAR

;;;;;;;
		.386p

		LOCALS

