/****************************************************************************

  exehdr - Reads and manipulates DOS exe (executable) file headers.

  Written to read in, display, and update to latest format (compatible
  to be stub within PE (and probably LE and NE) executables).

  This file should be compiled with the compiler set to no padding.
  eg #pragma pack  or align=1

  Version 0.00
  Written by: Kenneth J. Davis
  Date:       November 07, 2000
  Contact:    jeremyd@computer.org


Copyright (c): Public Domain [United States Definition]

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR AUTHORS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT
OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

****************************************************************************/

#ifndef EXEHDR_H
#define EXEHDR_H


/* PE - Portable Executable, Win32 executable files [latest exe spec],
   NE - New Executable,
   LE - Linear Executable,
   MZ - Standard DOS executable (contained as a stub program within others).
*/

/* Magic values for validating exe */
#define MAGIC_UNKNOWN 0x0     /* Indicates unknown or invalid exe file */
#define MAGIC_DOS 0x5A4D      /* ASCII ZM, in memory MZ     */
#define MAGIC_PE  0x00004550  /* ASCII ..EP, in memory PE.. */
#define MAGIC_NE  0x454E      /* ASCII EN, in memory NE     */
#define MAGIC_LE  0x454C      /* ASCII EL, in memory LE     */


/* The base DOS exe header in all valid DOS executables.
   Most non windows (or non os/2) aware development tools will assume
   the header is only 0x1C bytes and thus only this base
   portion may be valid as a header. [0x1C + relocation table]
   If magic contains MZ and the rest of this header is filled in
   with 0s, then the header is probably 0x40 bytes long, but 
   the exe does not contain a DOS stub. 
*/
typedef struct EXEHEADER_BASE
{
  WORD magic;   /* Should contain Magic ASCII MZ for valid EXE */
  /* The size of the DOS image including DOS exe header, for a
     pure DOS executable should also match the file size 
     (unless extra data is appended (such as Borland BGI or CHR files). */
  WORD lastPageSize; /* DOS image size bytes on last page (DOS image size mod 512) */
  WORD pages; /* DOS image size (including this header) in 512byte pages */
  WORD relocCnt; /* How many entries (count) in the relocation table */
  WORD hdrSize; /* Size of the header in paragraphs (16byte chunks) 
				   Note: the actual code/data starts immediately after this
				   header. I.e. for exes with initial IP=0 (org 0h) then
				   the first instruction begins at Offset hdrSize*16,
                   this also means relocation data is usually within the header's 
				   allocated size, but may not be as CS:IP may not be CS:0
				   or it may jmp over relocation table.
                   If this value is 0, it probably means either there is no
                   DOS executable, only one of the new types (PE, NE, LE),
                   and can probably safely assume header is 0x40 bytes 
                   (64 bytes for all currently defined info), i.e. hdrSize=0x0004 */
  WORD minAlloc; /* Minimum extra paragraphs of memory required (src of Not Enough Mem messge). */
  WORD maxAlloc; /* Maximum extra paragraphs of memory required (usually 0xFFFF all available). */
  WORD SS; /* Initial value for SS register (Stack Segment) relative (added) to segment value
              image loaded at in memory + 0x100 (PSP) i.e. relative to right after PSP. */
  WORD SP; /* Initial value for SP register (Stack Pointer). */
  WORD checksum; /* File checksum, or 0x0000 for no checksum. */
  WORD IP; /* Initial value for IP register (Instruction Pointer). */
  WORD CS; /* Initial value for CS register (Code Segment) relative (added) to segment value
		      image loaded at in memory + 0x100 (PSP) i.e. relative to right after PSP. */
  WORD relocTable; /* Offset in file (from begining) to start of relocation table. */
  WORD overlayNumber; /* Overlay number, usually 0 if no overlays (0=resident/nonoverlay portion). */
} EXEHEADER_BASE;

/* The linker information is optional in original DOS executables, the area is considered
   unused/reserved in LE/PE specifications. */
typedef struct EXEHEADER_LINKINFO
{
  WORD linkInfo[4]; /* 4 reserved words, usually containing 0s or linker information.
                       linkInfo[0] = ?, usually 0
					   linkInfo[1-2] = ?, usually 0, or linker information
					                 0x726A??FB (on disk FB ?? 6a 72)
					                 Borland Tlink, Version major=high 4bits, 
                                     minor=low 4bits, i.e. 0x726A-51-FB = TLink v5.01
					   linkInfo[3] = ? , usually 0
                     */
} EXEHEADER_LINKINFO;

/* The rest of the extended DOS header as defined in the PE/LE specifications. */
typedef struct EXEHEADER_EXT
{
  WORD oemID;        /* OEM identifier, usually 0 */
  WORD oemInfo;      /* OEM information, actual data specific to oemID specified, usually 0 */
  WORD reserved[10]; /* Reserved space, usually unused with values of 0 */
  DWORD newExeHdr;   /* Offset in file (from beginning) to start of new executable type
				         header, or in case of PE, to just before the actual header, but
					     still pointing to magic value of new executable type (PE.., NE, LE). 
                         This DWORD is always at offset 0x3C from beginning of file. */
} EXEHEADER_EXT;


#endif /* EXEHDR_H */
