program SCANDISK;
{$M 44000,32000,650000}
{$R+}{$S+}{$D+}
uses DOS,CRT,OpenDOS;

const version  = '3.1' {$IFOPT D+} + #225{beta} {$ENDIF};
      author   = 'M.Aitchison@phys.canterbury.ac.nz';
      ValidOptions = '/All disks/Batchmode (no pauses)/Checkonly/Delete lost clusters/Fix faults (write back fixes)'
                    +'/I..{use SCANDISK.INI or given file}'+log_
                    +'/M..{[Mode=]MONO..}/NoSUMmary/Surface scan/Timing test/Verbose/Yes to all (autofix)';
      Syntax      = ' [drive:]';
  	  WhatItDoes  = 'Search for errors on a disk, and optionally repair';

type
      FeaturesType = (VFAT,OS2EA,MSMacros);
      FilesystemType = (NotSpecified,FAT12,FAT16,FAT32,ALFS,HPFS,NTFS,EXT2FS,CPM,RDOS,MAC);
      FaultRecordPointer = ^FaultRecord;
      FaultType = (SoftError,HardError,Crosslink,LostSpace,BadBPB,FatMismatch,FatError,Needed2ndFat,RootdirUseless,
                   VFATmadness);
      FaultRecord = record Link       : FaultRecordPointer;
                           Fault      : FaultType;
                           Fixable    : (Impossible,Risky,Easy,NotWorthDoing,FixedAlready);
                           Start,
                           Finish     : comp;
                           Details    : string;
                           end;
var
    DriveNumber : byte;

const Linecount : integer = 0;
      FaultCount: integer = 0;
      FeaturesFound : set of FeaturesType = [];
var   Recorded  : array[0..31] of string80;
      DataSectors,
      MaxCluster: longint;
     Nclusters    : longint;

const NumberOfFloppyDiskDrives : byte = 2;
      LBA1 = $1BA0; LBA2 = $2BA0; LBAunknown = $0BA0;
      {KnownFiles :}
      ClusterOffset : longint = 0;
      Units : (Kb,Mb) = Kb;
      FStype : FilesystemType = NotSpecified;
      LFNfiles      : word = 0;
      DRDOSfiles    : word = 0;
      OS2files      : word = 0;
      UserFiles     : word = 0;
      HiddenFiles   : word = 0;
      DirectoryBytes: comp = 0;
      SystemBytes   : comp = 0;
      HiddenBytes   : comp = 0;
      WastedBytes   : comp = 0;
      UserFileBytes : comp = 0;
      TrueTotalBytes: comp = 0;
      TotalFreeBytes: comp = 0;
      WarningsCount : word = 0;
      ReadErrorsCount : word =0;
      DRDOS341    : boolean = false;  {check needed for int 25h calls}
      FaultsFound : FaultRecordPointer = nil;
      Nsides      : word    = 0;      {force single-sided format on a diskette?}
      Nsectors    : word    = 0;      {force sectors/track on a diskette? 0=normal}
      Ncylinders  : longint = 0;      {force number of cylinders/tracks? - for diskette drives}
      QuadDrive   : boolean = false;  {force Double-Density (360k) in a Quad-Density (1.2M) drive}
      FSname      : array[NotSpecified..MAC] of string[9]= ('unknown','FAT12','FAT16','FAT32','ALFS'
                    ,'HPFS','NTFS','EXT2FS','CPM','RDOS','MAC');
      VolumeLabel : string[22] = '';  {empty string means don't set label}
      SystemFiles : array[1..9] of record filename  : string[51];
                                          attr,size : longint;
                                          code      : pointer;
                                          end = ((filename:''),(filename:''),(filename:''),(filename:''),
                                                 (filename:''),(filename:''),(filename:''),(filename:''),
                                                 (filename:'') );

type QWord = comp;
    SizedBlocks = array[-1..25600] of word; {word at -1 is count of words used}
    DriveTypeType  = (NoDrive,Diskette360k,Diskette1200k,Diskette720k,Diskette1440,Diskette28,Diskette2880,
                      FixedDisk,NetworkDisk,RAMdisk);
type
      AskYesNo    = (Ask,Yes,No);
const
      DriveTypeName : array[DriveTypeType] of string[9] = (
                 '?','360k','1.2M','720k','1.44M','2.88M?','2.88M','?','?','?');
      DisksToScan : set of 'A' .. 'Z' = [];
      unknown   = -1;
      PhysicalDrive : integer = unknown;
      PhysicalStart : longint =0;
      BatchMode   : boolean = false;
      CheckOnly   : AskYesNo = Ask;
      DeleteLost  : AskYesNo = Ask;
      FixFaults   : AskYesNo = Ask;
      TimingTests : AskYesNo = No;
      PartitionTest : AskYesNo = Yes;
      SoakTest    : AskYesNo = No;
      VirusScan   : AskYesNo = No;
      IniFile     : string[99] = '';
      ScreenMode  : integer = -1; {-1 is default, 7=mono}
      NoSummary   : AskYesNo = Ask;
      SurfaceScan : AskYesNo = Ask;

type
    SectorArray = array[1..64] of array[0..511] of byte;
    SectorArrayPointer = ^SectorArray;
var
    FatSectors : array[0..255] of SectorArrayPointer;
type
    BiosParameterBlock = record {should be found in boot sector, also found in RAM}
	             BytesPerSector  : word; {should be 512}
	             SectorsPerCluster:byte; {a power of two, depends on capacity}
	             ReservedSectors : word; {1, the boot sector. Any more is suspicious in a diskette}
	             NumberOfFATs    : byte; {2, some RAM drives have 1. Dos assumes 2 usually}
	             RootEntries     : word; {a power of 16, can be varied}
	             TotalSectors    : word; {e.g. 720 for a 360K disk; includes boot sector, FATs, etc}
	             IDbyte          : byte; {F0 to FF; see first byte in FAT. Some ID's doubly-assigned}
	             SectorsPerFAT   : word; {how many sectors does each FAT take up?}
	             SectorsPerTrack : word; {e.g. 8,9,15,18 for diskettes. "optional" part of BPB}
	             NumberOfSides   : word; {1 or two for diskettes}
	             SpecialReserved : longint; {should be zero; viruses may use this, so it's checked}
	             BigTotalSectors : longint; {will be zero (unused) on diskettes}
	             end {of record};
    BootSector = record Jump : array[1..3] of byte; {should be $EB, something, $90}
	                OEMname : array[1..8] of char;  {can be anything reasonable name}
	                BPB : BiosParameterBlock;              {see above}
	                NormalDrive : byte;                  {0 under DOS 4 for diskettes, even on B:}
	                Reserved      : byte;                  {dunno, but DOS 4 reserves it}
	                ExtendedBootRecordSignature : byte;    {seems to be 41 under DOS 4.01}
	                VolumeSerial  : record low,high : word; end; {can be anything; DOS 4 or better}
	                VolumeLabel   : array[1..11] of char;  {repeats volume label when formatted, DOS 4+}
	                FATtype       : array[1..8] of char;   {"reserved" in DOS 4, seems to contain "FAT.."}
	                BootCode      : array[$3E..$1FD] of char; {might start before/after this; version-dependent}
	                AA55          : word;                     {normally $AA, $55}
	                end;
    BootSectorPointer = ^BootSector;
    AlfsFatType = array [0..511] of byte;
    CylinderGroupType = byte;
    LocationType      = record CylinderGroup : CylinderGroupType;
                               OffsetInCGType : longint;
                               end;
    CGinfo = record StartSector : byte;
                    StartTrack  : longint;
                    Units       : (bytes,blocks);
                    FastWriteSize : word;
                    end;

    DevicePointer = ^DeviceHeader;
    DeviceHeader  = record
                    NextDevice   : DevicePointer;
                    Attributes   : word; {bit $80 =1 for character devices (then bit 01=Stnd Input
                                                                  bit 02=Stnd Output
                                                                  bit 04=NUL device
                                                                  bit 08=CLOCK
                                                                  bit 10=special)
                                   =0 for block devices.
                           bit $40 =IOCTL bit
                           bit $20 =non-IBM FORMAT bit}
                    StrategyRoutine : word; {offset to strategy routine}
                    InterruptRoutine : word; {offset to interrupt routine}
                    Name     : array[1..8] of char;
                    end;
    ExtendedBiosDataAreaType =
       record NumberOfKilobytesAllocted : byte; {PS/2; see memw[0:$40E]}
              Reserved                  : array[1..$21] of byte;
	      PointingDevice : record Driver : pointer;
	                              Flags  : word; {use intr $15 to access?}
	                              Reserved : array[$28..$2F] of byte;
	                              end {of PointingDevice sub-record};
              end {of Extended Bios Data area record; whole thing is 1K long};
    DosDirEntry = record
                      Name : array[1..8] of char; ext : array[1..3] of char;
	                    Attribute : word;
                      Dunno     : byte;
                      Password  : word;
                      GID,UID,
                      Permissions : word;
	                    TimeDate  : longint;
	                    StartCluster : word;
	                    Size      : longint;
	                    end;
    DosDirArray = array[1..2000] of DosDirEntry;
    CGoffset = record CG : byte;
                      offset : array[1..3] of byte;
                      end;
    FreespaceEntry = record Size     : longint;
                            Location : locationType;
                            end;
    FreespaceRecord =record Area : array[1..56] of FreeSpaceEntry;
                            wasted : array[504..507] of byte;
                            Next   : locationType;
                            end;
    DirBlockType = array[1..2048] of byte;

    InfoBlockType = record ThisTableSize   : byte;  {number of valid entries in table after this}
                           SectorsInThisInfoblock : byte; {1 for diskettes and smallish partitions}
                           ALFSversion   : record major,minor : char; end;
                           Blocks,          { total number of blocks (sectors) on disk}
                           Reserved,
                           FreeBlocks,      {space left on disk}
                           FreeJnodes,      {we don't use inodes, but may some day use jnodes!}
                           FirstDataBlock,  {for "internal use" so driver can forget bootsector information}
                           BlockSize        : longint;
                           Bytes4CG,        {normally 1 bytes to hold cylinder group number}
                           Bytes4offset,    {normally 3 bytes to hold offset within CG, implies Tb total}
                           Bytes4dirblock,  {normally 2 bytes to hold dirblock number, allows 128kB of directory}
                           Bytes4namelength,{normally 1 bytes to hold length of filename}
                           Bytes4filetype,  {normally 2 bytes to hold dirent type (5 bits are name repeat count)}
                           Bytes4unixattr,  {normally 3 bytes to hold unix (etc) file attributes}
                           Bytes4datetime,  {normally 6 bytes to hold date & time }
                           Bytes4CGrec,     {normally 4 bytes/CG in table: 1 for type/drive, 1 for QWA use, 2 for start cyl}
                           Bytes4dirrec,    {normally 8 bytes/dirblock: Bytes4dirblock+Bytes4CG+Bytes4offset + 2 for hash}
                           Bytes4Sequence,  {normally 2 bytes for buffer write sequence number}
                           Bytes4BufferRec
                                         : byte;
                           UnicodeMethod : (NoUnicode,Unicode8,Unicode16);
                           DefaultCodePage : word;
                           QuickWriteBufferCount   : word; {effectively the allocation unit for QWA writes}
                           MountTime,LastWriteTime : longint;
                           MountCount, MaxMountCount : word;
                           Magic           : array[1..2] of char;  {think of Sooty}
                           State,
                           ErrorBehaviour,
                           CGcount     : word;
                           LastCheckTime,
                           CheckInterval : longint;
                           Creator_OS,
                           rev_level : longint;
                           WriteCount,WriteCountAtLastSync : word;   {21x4=84 bytes}
                           NotUsed       : word;
                           NextInfoblock : CGoffset;
                           Comment       : array[1..14-sizeof(CGoffset)] of char;
                           {at offset 100 decimal}
                           DefaultFileOptions : string[27-6*2];
                           SpecialtableOffset, SpecialCGtableSize : word;
                           BufferTableOffset, BufferTableSize : word;
                           DirTableOffset,DirTableSize : word; {this can expand with time}
                           {at offset 128 decimal}
                           CGTABLE : array[0..15] of record StartCylinder : word;
                                                            QWAused       : byte; {1=used or cannot use}
                                                            CGtype        : byte; {0x80=1 byte allocation}
                                                                                  {0x40=remote server}
                                                            end;
                           BUFFERTABLE : array[0..7] of record WrittenToQWA : word; {CG and offset within CG's QWA}
                                                               Location  : CGoffset;
                                                               Flags     : array[1..8-2-sizeof(CGoffset)] of byte;
                                                               end;
                           DIRTABLE : array[1..32] of record ParentDirblock : word;
                                                             Location : CGoffset;
                                                             Hash     : array[2+sizeof(CGoffset)..8] of char;
                                                             end;
                           end; {7200 files/348Mb, 10800/414 1556/44.6Mb 5269/475Mb = 20.7  26.1, 11.1 }

function MappedDrive(DriveNumber : byte) : byte;
begin
with reg do begin
            AX:=$440E; BX:=DriveNumber;
            msdos(reg);
            MappedDrive:=AL;
            end;
end;

procedure AskFor(DriveLetter : char);
begin
writeln('Please insert diskette into drive ',DriveLetter,': and press ENTER');
readln;
end;

{$F+}
var CurrentBootSector : BootSector;
    OldInterrupt13 : pointer;

procedure MyInterrupt13(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word); interrupt;
begin
Flags:=0;
PhysicalStart:=hi(DX)*65536+CX;
PhysicalDrive:=lo(DX);
end;

function ReadViaBios(PhysicalDrive : byte; Cylinder,Head,StartSector, HowMany : word; var where) : byte; {0=success}
var reg : registers;
begin
with reg do begin
	          AH:=2; AL:=HowMany;
	          CH:=byte(Cylinder);
	          CL:=StartSector+( (Cylinder and $0300) shr 2);
	          DL:=PhysicalDrive; DH:=head;
	          ES:=seg(where); BX:=ofs(where);
            intr($13,reg);
            (*
	          if odd(flags) and (ah=6)
	             then begin AH:=2; AL:=HowMany; intr($13,reg); end;
            *)
	          if odd(flags) then ReadViaBios:=AH else ReadViaBios:=0;
            end;
end;

function Dos_ReadSector(Drive : word; StartSector : longint; HowMany : word; var Where) : boolean ;
var Result : word;
    Packet : record SectorNumber : longint;
	            NumberToRead : word;
	            TransferAddr : pointer;
     	        Dummy        : array[1..256] of word;
	            end;
    PackPointer : pointer;
begin
Dos_ReadSector:=true;
Result:=0;
if (StartSector<$FFFF) and not DRDOS341
   then inline(
  $55/$16/$1E/         { PUSH BP,SS,DS  }
  $8B/$8E/HowMany/     { MOV CX,HowMany[BP]}
  $8B/$86/Drive/       { MOV AX,Drive[BP] }
  $8B/$96/StartSector/ { MOV DX,StartSector[BP]}
  $C5/$9E/Where/       { LDS BX,Where[BP] }
  $06/$55/$1E/$07/     { PUSH ES; BP; PUSH DS; POP ES; to work around old DOS bug}
  $8B/$EB/             { mov bp,bx ; DOS 3.1..3.3 sets ES:BP+1E to FFFF if invalid drive}
  $CD/$25/             { INT 25h ; read DOS absolute sectors}
  $1F/                 { POP DS  ; because flags pushed}
  $5D/$07/             { POP BP,ES ; working around DOS 3.x bug}
  $1F/$17/$5D/         { POP DS,SS,BP}
  $73/$02/             { JNC .+2}
  $0C/$01/             { OR AL,1}
  $89/$86/Result)      { MOV Result[BP],AX}
  else Result:=$0207;
DosError:=Result;
if (lo(Result)<>0) then
    begin
     with Packet do
	     begin
	     SectorNumber:=StartSector;
	     NumberToRead:=HowMany;
	     TransferAddr:=@where;
 	     fillchar(Dummy,sizeof(dummy),1);
	     end;
	   HowMany:=$FFFF; Result:=$1234;
	   PackPointer:=@Packet;
	   inline(
	     $55/$16/$1E/$56/$57/ { PUSH BP,SS,DS,SI,DI  }
	     $B9/$FFFF/           { MOV CX,HowMany[BP]}
	     $8B/$86/Drive/       { MOV AX,Drive[BP] }
	     $C5/$9E/PackPointer/ { LDS BX,PackPointer[BP] }
	     $CD/$25/             { INT 25h ; read DOS absolute sectors}
	     $1F/                 { POP DS  ; because flags pushed}
	     $5F/$5E/$1F/$17/$5D/ { POP DI,SI,DS,SS,BP}
	     $89/$86/Result);     { MOV Result[BP],AX}
     Dos_ReadSector:=(hi(Result)=0);
     if DosError=$0207 then DosError:=hi(Result);
 	   if hi(Result)<>0
 	      then if (byte(PhysicalDrive) in [0..4]) and (StartSector=0)
                then DosError:=ReadViaBios(PhysicalDrive,0,0,1,HowMany,Where);
	   Dos_ReadSector:=(DosError=0);
	   end;
end;

function GetPhysicalDrive(DriveLetter :char) : integer;
var TempBootsector : Bootsector;
begin
DriveNumber:=(ord(upcase(DriveLetter)) and $1F);
GetPhysicalDrive:=DriveNumber-1; {initial guess}

case DriveNumber of
     1 : if MappedDrive(1) > 1 then AskFor('A');
     2 : if MappedDrive(1) = 1
            then begin AskFor('B'); GetPhysicalDrive:=0; end;
     else begin
	        PhysicalDrive:=unknown;
	        GetIntVec($13,OldInterrupt13);
	        SetIntVec($13,@MyInterrupt13);
	        fillchar(TempBootsector,sizeof(bootsector),0);
	        if (not Dos_ReadSector(DriveNumber-1,0,1,TempBootSector)) or (CurrentBootSector.OEMname=#0#0#0#0#0#0#0#0)
             then if not Dos_ReadSector(DriveNumber-1,0,1,TempBootSector)
                     then {ignore};
	        SetIntVec($13,OldInterrupt13);
          GetPhysicalDrive:=PhysicalDrive;
          end;
     end;
end;

var DriveDetails : record
              Special : byte;   {bit 2 set if all sectors in track same size}
              DriveType : byte; {0=320/360k,1=1.2M,2=720k,3=SD 8",4=DD 8",5=fixed,6=tape,7=1.44M,8=optical,9=2.88M, 16=Stacker}
              DriveAttr : word; {bit0=nonremovable, bit1=doorlock(changeline) supported}
              NumberCyl : word;
              MediaType : byte; {0=normal, 1=360k disk in 1.2M drive, $F8 for DUBLDISK}
              DeviceBPB : BiosParameterBlock;
              end;

procedure GetPhysicalDriveParameters(PhysicalDrive : integer; var Sectors,MaxHead,MaxCylinders : longint;
                                     var DriveType : string);
var reg : registers;
    LBAparameters : record BufferSize, InformationFlags : word;
                           Cylinders,Heads,Sectors : longint;
                           TotalSectors : Qword;
                           BytesPerSector: word;
                           Reserved     : pointer;
                           Dunno        : byte;
                           end;
begin
with reg do begin
            if PhysicalDrive>=$80 then
               begin
               AH:=$48; DX:=PhysicalDrive;
               LBAparameters.BufferSize:=sizeof(LBAparameters);
               LBAparameters.Cylinders:=0;
               DS:=seg(LBAparameters); SI:=ofs(LBAparameters);
               intr($13,reg);
               if odd(flags) or (LBAparameters.Cylinders=0)
                  then DriveType:='no LBA' {obviously doesn't support LBA}
                  else begin
                       MaxCylinders:=LBAparameters.Cylinders;
                       MaxHead:=LBAparameters.Heads;
                       Sectors:=LBAparameters.Sectors;
                       case byte(LBAparameters.BufferSize) of
                            $1A : DriveType:='LBA 1.x Hard Disk';
                            $1E : DriveType:='LBA 2+ Hard Disk';
                            else  DriveType:='LBA Hard Disk';
                            end;
                       exit;
                       end;
               end;
            if PhysicalDrive=unknown
               then begin
                    if true then;
                    exit;
                    end;
            AH:=8; AL:=0; BX:=0; CX:=0; DX:=PhysicalDrive;
            intr($13,reg);
            DriveType:=DriveTypeName[DriveTypeType(BL)];
            case DriveTypeType(BL) of
                 Diskette360k .. Diskette2880 : DriveType:=DriveType+' diskette';
                 end;
            Sectors:=(CL and $03F);
            MaxHead:=DH;
            MaxCylinders:=CH+256*(CL shr 6);
            if (MaxHead>65) and (MaxCylinders<100)
               then WarningMessage('This disk is probably too big for this early version; '+decimal(MaxHead)+' heads??!');
            end;
end;

function GetDriveParameters(LogicalDrive : integer; var PhysicalDrive : Integer;
                            var Sectors,MaxHead,MaxCylinder : longint; var DriveType : string) : boolean;
var DriveDesc : string;
    DiskSectors,DiskMaxHead,DiskMaxCylinders : longint;
begin
DriveType:='';
GetDriveParameters:=true;
with reg do begin
            fillchar(DriveDetails,sizeof(DriveDetails),0);
            PhysicalDrive:=GetPhysicalDrive(char(64+LogicalDrive));
            GetPhysicalDriveParameters(PhysicalDrive,DiskSectors,DiskMaxHead,DiskMaxCylinders,DriveDesc);
            AX:=$440D; BX:=LogicalDrive; CX:=$0860;
            msdos(reg);  {get drive details};
            if odd(flags)
               then begin GetDriveParameters:=false; exit; end;
            move(Mem[DS:DX],DriveDetails,sizeof(DriveDetails));
            Sectors {per track}:=DriveDetails.DeviceBPB.SectorsPerTrack;
            MaxCylinder:= DriveDetails.NumberCyl -1;      {zero-based}
            MaxHead := DriveDetails.DeviceBPB.NumberOfSides -1 ;
            case DriveDetails.DriveType of
                 0 : begin DriveType:='360kb 5"'; Sectors:=9;  MaxHead:=pred(2); MaxCylinder:=pred(40); end;
                 1 : begin DriveType:='1.2Mb 5"'; Sectors:=15; MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 2 : begin DriveType:='720kb 3"'; Sectors:=9;  MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 3 : begin DriveType:='8" SD';Sectors:=9;  MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 4 : begin DriveType:='8" DD';Sectors:=9;  MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 5 : begin {hard disk }
                     if PhysicalDrive=unknown
                        then DriveType:='Stacker'
                        else DriveType:='Partition of disk 0x'+hex2(PhysicalDrive);
                     end;
                 7 : begin DriveType:='1.44Mb 3';Sectors:=18; MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 9 : begin DriveType:='2.88Mb 3';Sectors:=18; MaxHead:=pred(2); MaxCylinder:=pred(80); end;
                 16: ErrorMessage('Cannot format compressed drive');
                 else ErrorMessage('I cannot format this drive type ('+decimal(DriveDetails.DriveType));
                 end;
            if DriveDetails.DriveType in [0..4,7..9]
               then DriveType:=DriveType+' diskette';
            end;
end;


procedure WriteMsg(Msg : string; X,Y : byte; attr : word);
var i : byte;
begin
Opendos.GotoXY(X,Y);
TextAttr:=attr;
write(Msg);
end;

const Info_Count : byte = 0;
      Info_column = 50;

procedure PaintScreen(title : string);
var st,line1,line2,line3,line4 : string[132];
    i,j,Width,Info_column : integer;
begin
Width:=80;
Info_column:=50; {must think of a better name some day}
OriginalTextAttr:=White;
ClrScr;
st:=PROGNAME+' v'+VERSION+'                                                    ';
st:=copy(st,1,Width-2-length(WhatItDoes));
st:=st+WhatItDoes;
WriteMsg(st,1,1,$70);
fillchar(line1,Width,''); line1[0]:=chr(width); line1[1]:=''; line1[width]:='';
fillchar(line2,width,' '); line2[0]:=chr(width); line2[1]:=''; line2[width]:='';
line3:=line1;
move(title[1],line1[3],length(title));
line1[Info_column]:='';
line2[Info_column]:='';
line3[Info_column]:=''; line3[1]:=''; line3[width]:='';
writeMsg(line1,1,3,Cyan);
for i:=4 to 13 do WriteMsg(line2,1,i,Cyan);
writeMsg(line3,1,14,Cyan);
line2[Info_column]:=' ';
line3[Info_column]:='';
for i:=15 to 17 do WriteMsg(line2,1,i,Cyan);
writeMsg(line3,1,18,Cyan);
line2[width-1]:='';
for i:=19 to 23 do WriteMsg(line2,1,i,Cyan);
line3[1]:=''; line3[width]:='';
writeMsg(line3,1,24,Cyan);
WriteMsg(chr(30),Width-1,19,$70);
WriteMsg(chr(31),Width-1,23,$70);
end;

procedure InfoMsg(st : string);
begin
if Batchmode
   then writeln(st)
   else WriteMsg(copy(st,1,78-Info_column),Info_column+1,4+Info_count,Green);
inc(Info_count);
end;

function Want(option : AskYesNo; prompt : string) : boolean;
var st : string[2]; SaveX,SaveY : integer;
begin
Want:=(option=Yes);
if (option=Ask) then
   begin
   if not BatchMode
      then begin
           SaveScreen;
           WriteMsg('ͻ',5,16,Yellow);
           WriteMsg('                                                              ',5,17,Yellow);
           WriteMsg('                                                              ',5,18,Yellow);
           WriteMsg('ͼ',5,19,Yellow);
           gotoXY(7,17);
           end;
   write(Translate(Prompt)+' ');
   readln(st);
   Want:=pos(' '+capitals(st),YesStr)<>0;
   if not BatchMode
      then begin
           RestoreScreen;
           end;
   end;
end;

procedure RememberToFix(NatureOfProblem : FaultType; StartSector,EndSector : comp; Description : string);
var PreviousRecord : FaultRecordPointer;
begin
PreviousRecord:=FaultsFound;
new(FaultsFound);
inc(FaultCount);
if FaultCount>200
   then ErrorMessage('Too many faults ('+decimal(FaultCount)+')!');
fillchar(FaultsFound^,sizeof(FaultsFound^),0);
with FaultsFound^ do
     begin
     Fault:=NatureOfProblem;
     Link:=PreviousRecord;
     Start:=StartSector;
     Finish:=EndSector;
     Details:=Description;
     end;
end;

procedure LogMessage(Msg : string80);
begin
if BatchMode
   then writeln(Msg)
   else begin
        Recorded[Linecount and 31]:=copy(Msg+'                                                                ',1,73);
        if (LineCount < 10) and (LineCount >= 4)
           then begin
                WriteMsg('',79,20+(LineCount-5) div 2,Yellow);
                WriteMsg('',79,20+(LineCount-4) div 2,LightCyan);
                end;
        if LineCount<5 then begin
                            WriteMsg(Recorded[Linecount and 31],4,19+LineCount,LightMagenta);
                            end
                       else for i:=4 downto 0 do
                                begin
                                WriteMsg(Recorded[(Linecount-i) and 31],4,23-i,LightMagenta);
                                end;
        end;
inc(LineCount);
end;

function FindAffectedFile(SectorNumber : comp) : string;
begin
{for i:=1 to KnownFiles do
    with KnownFile[i]^ do
} FindAffectedFile:='';
end;

procedure FaultySector(Msg : string; SectorNumber : comp; HowMany : integer; buffer : sectorarraypointer);
var st : string;
    s  : integer;
    er : array[0..63] of word;
    PreviousError,
    ThisError    : string;
    SectorList   : string[64];
    Buffer2      : array[0..1023] of byte;
    where        : pointer;

  function SectorNumbers : string;
  var st,nn : string80;
      i,j,k : byte;
  begin
  str(SectorNumber+ord(SectorList[1]):4:0,st);
  k:=0;
  for i:=2 to length(SectorList) do
      begin
      nn:=decimal(SectorNumber+ord(SectorList[i]));
      j:=k+1;
      if SectorList[i-1]=pred(SectorList[i])
         then if st[j]='-' then st:=copy(st,1,j)+nn
                           else begin k:=length(st); st:=st+'-'+nn end
         else st:=st+','+nn;
      end;
  if length(Sectorlist)<2
     then SectorNumbers:=' '+st
     else begin
          while (st<>'') and (st[1]=' ') do delete(st,1,1);
          SectorNumbers:='s '+st;
          end;
  end;

begin
fillchar(er,sizeof(er),0);
st:='';
ThisError:='';
SectorList:='';
for s:=0 to pred(HowMany) do
    begin
    if buffer=nil then where:=@buffer2 else where:=@Buffer^[s+1];
    WriteMsg(' Testing sector '+decimal(round(SectorNumber+s))+'...',55,17,LightRed);
    if not Dos_ReadSector(DriveNumber-1,round(SectorNumber+s),1,where^)
       then begin
            er[s]:=DosError;
            ThisError:='0x'+hex2(hi(DosError))+' ('+BiosError(hi(DosError))+') '+FindAffectedFile(SectorNumber+s);
            if (SectorList<>'') and (ThisError<>PreviousError)
                       then begin
                            st:='Sector'+SectorNumbers+' read error: '+ThisError;
                            if Batchmode then writeln(st)
                                         else LogMessage(st);
                            RememberToFix(HardError,SectorNumber+ord(SectorList[1]),
                                          SectorNumber+ord(SectorList[length(SectorList)]),ThisError);
                            SectorList:='';
                            end;
            SectorList:=SectorList+char(s);
            PreviousError:=ThisError;
            end;
    end;
WriteMsg('                        ',55,17,White);
if SectorList<>''
   then begin
        st:='Sector'+SectorNumbers+' read error: '+ThisError;
        RememberToFix(HardError,SectorNumber+ord(SectorList[1]),SectorNumber+ord(SectorList[length(SectorList)]),ThisError);
        end
   else if ThisError=''
           then begin
                st:='Soft error (fixed by re-reading): '+Msg;
                RememberToFix(SoftError,SectorNumber,SectorNumber+pred(HowMany),Msg);
                end
           else st:='';
if st<>''
   then if Batchmode then writeln(st)
             else LogMessage(st);

end;

function CheckBootsector(FS : FilesystemType; MyBootSector : BootSector) : boolean;
var DetectedType : FilesystemType;
    FirstFatSector : array[0..511] of byte;
begin
{determine Filesystem type}
FSType:=FAT12;
with MyBootsector,BPB do
     begin
     if SectorsPerCluster in [1,2,4,8,16,32]
        then begin
             if TotalSectors=0 then TrueTotalBytes:=BigTotalSectors
                               else TrueTotalBytes:=TotalSectors;
             Nclusters:=round(TrueTotalBytes) div SectorsPerCluster;
             TrueTotalBytes:=TrueTotalBytes*512;
             end
        else begin
             Nclusters:=0;
             TrueTotalBytes:=DiskSize(DriveNumber);
             end;
     FStype:=FilesystemType((7+pos(FatType,'FAT12   FAT16   FAT32   ALFS    HPFS    NTFS    ')) div 8);
     if (FStype=NotSpecified) then
        begin
        {FStype:=EXT2FS;}
        if (NumberOfFATs in [1,2]) and (SectorsPerCluster in [1,2,4,8,16]) and (AA55=$AA55)
           then if Nclusters<$FF7
                   then FStype:=FAT12
                   else FStype:=FAT16
           else begin
                if Dos_ReadSector(DriveNumber-1,1,1,FirstFatSector)
                   then if (FirstFatSector[0] in [$F0..$FF]) and (BytesPerSector=0)
                           then with CurrentBootsector.BPB do
                                begin
                                FStype:=FAT12;
                                LogMessage('I have to assume this is an old DOS 1.x diskette with no BPB');
                                NumberOfFATs:=2; ReservedSectors:=1;
                                BytesPerSector:=512;
                                IDbyte:=FirstFatSector[0];
                                case FirstFatSector[0] of
                                     $FE : begin
                                           SectorsPerCluster:=1; RootEntries:=64;
                                           SectorsPerFAT:=1; NumberOfSides:=1;
                                           SectorsPerTrack:=8; TotalSectors:=320;
                                           end;
                                     $FC : begin
                                           SectorsPerCluster:=1; RootEntries:=64;
                                           SectorsPerFAT:=2; NumberOfSides:=1;
                                           SectorsPerTrack:=9; TotalSectors:=360;
                                           end;
                                     $FF : begin
                                           SectorsPerCluster:=1; RootEntries:=112;
                                           SectorsPerFAT:=1; NumberOfSides:=2;
                                           SectorsPerTrack:=8; TotalSectors:=640;
                                           end;
                                     $FD : begin
                                           SectorsPerCluster:=1; RootEntries:=112;
                                           SectorsPerFAT:=2; NumberOfSides:=2;
                                           SectorsPerTrack:=9; TotalSectors:=720;
                                           end;
                                     end;
                                TrueTotalBytes:=TotalSectors; TrueTotalBytes:=TrueTotalBytes*BytesPerSector;
                                end
                           else begin { check for non-DOS disks}
                                end;
                st:=st;
                end;
        end;
     end;
CheckBootsector:=FStype<>NotSpecified;
end;

function CheckFat : boolean;
var i,j,k,N : word; Buffer2 : array[0..255] of word;

  function ReadFatSectors(start, HowMany : integer; where : pointer) : boolean;
  var i,first : integer;
  begin
  ReadFatSectors:=true;
  first:=start+CurrentBootsector.BPB.ReservedSectors+start-1;
  if not DOS_ReadSector(DriveNumber-1,first,HowMany,where^)
     then begin
          FaultySector('Cannot read FAT',first,HowMany,where);
          for i:=1 to HowMany do
              if not DOS_ReadSector(DriveNumber-1,first+i-1,1,FATsectors[start+i-1]^)
                 then if (CurrentBootsector.BPB.NumberOfFATs<2)
                       or not DOS_ReadSector(DriveNumber-1,first+N+i-1,1,FATsectors[start+i-1]^)
                         then begin
                              RememberToFix(FATerror,first+i-1,first+i-1,'Error reading FAT');
                              inc(k);
                              ReadFatSectors:=false;
                              end
                         else begin
                              RememberToFix(Needed2ndFAT,first+i-1,first+i-1,'Correctable error reading FAT');
                              end;
          end;
  end;

begin
CheckFat:=true;
TotalFreeBytes:=0;
with CurrentBootsector,BPB do
     begin
     N:=SectorsPerFat;
     if N=0
        then begin
             st:='Sectors per FAT is zero!';
             LogMessage(Translate(st));
             RememberToFix(BadBPB,0,0,st);
             exit;
             end;
     if N<8
        then begin
             getmem(FATsectors[0],N*512); {FATsectors is a zero-based array of pointers}
             for i:=1 to N-1 do           {but we allocate in lots of up to 8xsector for efficiency}
                 FATsectors[i]:=@FATsectors[0]^[i+1];
             if not ReadFATsectors(0,N-1,FatSectors[0]) then CheckFat:=false;
             end
        else begin
             for i:=0 to ((N+7) div 8)-1 do
                 begin
                 k:=i*8;
                 getmem(FATsectors[k],8*512);
                 for j:=k+1 to k+7 do
                     FATsectors[j]:=@FATsectors[k]^[1+j-k];
                 if not ReadFATsectors(k,min(N-k,8),FATsectors[k])
                    then CheckFAT:=false;
                 end;
             end;
     end;
(* if there are any errors above it is because I restarted programming while I'm still sick!!! *)
end;

function CheckAlfsSpace : boolean;
begin
CheckAlfsSpace:=false;
(* !!! *)
end;

function CheckFreeSpace : boolean;
begin
CheckFreespace:=false;
case FStype of
     FAT12,FAT16 : CheckFreespace:=CheckFAT;
     ALFS        : CheckFreespace:=CheckAlfsSpace;
     else LogMessage('Sorry, version '+Version+' of '+ProgName+' cannot check the free space of '+FSname[FStype]+' disks.');
     end;
end;

function ClusterToSector(cluster : longint) : longint;
var sector : longint;
begin
with CurrentBootsector.BPB do
     Sector:=ReservedSectors+NumberOfFats*SectorsPerFat
                      +(RootEntries+15) div 16
                      +(cluster-2)*SectorsPerCluster;
ClusterToSector:=Sector;
end;

function ReadCluster(Cluster : word; var blocks : integer; var where : pointer) : boolean;
var N : integer; Sector : longint;
begin
blocks:=CurrentBootsector.BPB.SectorsPerCluster;
getmem(where,blocks*512);
fillchar(where^,blocks*512,0);
sector:=ClusterToSector(Cluster);
if not Dos_ReadSector(DriveNumber-1,Sector,CurrentBootsector.BPB.SectorsPerCluster,where^)
   then FaultySector('Error reading cluster '+decimal(cluster),sector,CurrentBootsector.BPB.SectorsPerCluster,where);
end;

function ProperName(name,ext : string80) : string;
begin
while (name[length(name)]=' ') do dec(name[0]);
while (ext[length(ext)]=' ') do dec(ext[0]);
if ext='' then ProperName:=name
          else ProperName:=name+'.'+ext;
end;

function CheckFatDir(DirName : string; var blocks; N : integer) : boolean;
var ThisDir : DosDirArray absolute blocks;
    SubDir  : ^DosDirArray;
    EndOfDir: boolean;
    BytesAtEnd,
    AllocUnit:longint;
    LongnamesInDir,
    N2,Errors,
    i,j,k   : integer;

 procedure InvalidDirEntry(EntryNumber : byte; var ThisEntry : DosDirEntry; msg : string80);
 begin
 inc(Errors);
 if Errors<4 then LogMessage('Directory error: '+Msg+' in '+DirName+'\')
 end;

 procedure CheckVolume(var ThisEntry : DosDirEntry);
 begin
 (* !!! *)
 end;

 function FatEntry(cluster : word) : longint; {returns -1 for eof, -2 for bad block, 0 for free, else next cluster}
 var i,j,k : word;
 begin
 case FStype of
    FAT16 : begin i:=hi(cluster); move(FATsectors[i]^[lo(cluster)*2],k,2); end;
    else    begin i:=cluster+(cluster shr 1); (* !!! *) end;
    end;
 FatEntry:=-1;
 end;

 procedure CheckSubdir(var ThisEntry : DosDirEntry);
 var errors : integer;

   procedure ExamineDirBlock(StartCluster : word);
   begin
   with ThisEntry do
        if ReadCluster(StartCluster,N2,pointer(Subdir))
                    then CheckFatDir:=CheckFatDir(DirName+'\'+ProperName(Name,ext),Subdir^,N2*16)
                    else begin
                         LogMessage('Cannot read subdirectory: '+Name);
                         {RememberToFix(BadDir,ClusterToSector(StartCluster),0,'}
                         inc(errors);
                         end;
                 freemem(Subdir,N2*512);
                 DirectoryBytes:=DirectoryBytes+N2*512;
                 if FatEntry(StartCluster)>1
                    then ExamineDirBlock(FatEntry(StartCluster));
   end;

 begin
 errors:=0;
 if ThisEntry.Name[1]='.'
    then {check dot and .. files}
    else with CurrentBootsector.BPB,ThisEntry do
                 begin
                 end;
 end;

begin
CheckFatDir:=true;
EndOfDir:=false;
Errors:=0;
LongnamesInDir := 0;
DirectoryBytes:=DirectoryBytes + ((N+15) div 16)*512;
for i:=1 to N do
    with ThisDir[i] do
         if Name[1]=#0 then EndOfDir:=true
            else begin
                 if EndOfDir then begin
                                  if Name[1]<>#$E5
                                     then InvalidDirEntry(i,ThisDir[i],'Directory entries after end-of-dir mark');
                                  end;
                 if Name[1]=#$E5
                    then {ignore deleted entry}
                    else if Attribute=$0F then inc(LongnamesInDir)
                    else if startcluster>MaxCluster then InvalidDirEntry(i,ThisDir[i],'Start Cluster invalid')
                    else if boolean(Attribute and Directory) then CheckSubdir(ThisDir[i])
                    else if boolean(Attribute and VolumeID) then CheckVolume(ThisDir[i])
                    else begin
                         case (attribute and (sysfile+hidden)) of
                              hidden : begin
                                       HiddenBytes:=HiddenBytes+size;
                                       inc(HiddenFiles);
                                       end;
                              sysfile: begin
                                       systembytes:=systemBytes+size;
                                       inc(HiddenFiles);
                                       end;
                       hidden+sysfile: begin
                                       systemBytes:=systemBytes+size;
                                       HiddenBytes:=HiddenBytes+size;
                                       inc(HiddenFiles);
                                       end;
                              0 : begin
                                  UserFileBytes:=UserFileBytes+size;
                                  inc(UserFiles);
                                  end;
                              end;
                         if (Password<>0) or (Permissions<>0)
                            then begin
                                 st:=DirName+'\'+ProperName(Name,ext);
                                 if (password=0) and (Dunno=0) and (UID=0)
                                    then LogMessage('OS/2 file: '+st)
                                    else if Password=0
                                    then LogMessage('Dunno: '+hex2(dunno)+' Encr.: '+hex(Password)+' GID='+decimal(GID)
                                               +' UID='+decimal(UID)+' Permissions: 0x'+hex(Permissions)+' '+st)
                                    else LogMessage(DrwxAttrName(st,attribute+longint(256)*Permissions)+' '+st);
                                 end;
                         with CurrentBootsector.BPB do AllocUnit:=SectorsPerCluster*BytesPerSector;
                         BytesAtEnd:=size mod AllocUnit;
                         if BytesAtEnd>0
                            then WastedBytes:=WastedBytes+(AllocUnit-BytesAtEnd);
                         end;
                 end;
if (LongnamesInDir>0)
   then if not (VFAT in FeaturesFound)
        then begin
             LogMessage('Note: VFAT-style Long filename(s) found');
             FeaturesFound:=FeaturesFound+[VFAT];
             end;
CheckFatDir:=(Errors=0);
end;

function CheckDirectoryStructure : boolean;
var RootDir : ^DosDirArray;
    i,j,k   : integer;
begin
CheckDirectoryStructure:=true;
if FStype in [FAT12..FAT16]
   then with CurrentBootsector.BPB do
        begin
        j:=(15+RootEntries) div 16;
        getmem(RootDir,j*512);
        fillchar(RootDir^,j*512,0);
        k:=ReservedSectors+SectorsPerFat*NumberOfFats;
        if not Dos_ReadSector(DriveNumber-1,k,j,RootDir^)
           then begin
                if not Dos_ReadSector(DriveNumber-1,k,1,RootDir^)
                   then LogMessage('Cannot read the first root directory sector');
                FaultySector('Error reading root directory',k,k+j-1,pointer(RootDir))
                {exit?}
                end;
        if not CheckFatDir('',RootDir^,RootEntries)
           then CheckDirectoryStructure:=false;
        freemem(RootDir,j*512);
        end
   else LogMessage('This version cannot check non-DOS disks');
end;

type BooleanFunction = function : boolean;

function CheckCrosslinks : boolean;
begin
CheckCrosslinks:=true;
end;

function CheckPartitionTable : boolean;
begin
CheckPartitionTable:=true;
end;

function CheckTiming : boolean;
begin
CheckTiming:=true;
end;

function CheckVFAT : boolean;
begin
CheckVFAT:=true;
end;

procedure ShowOkay(msg : string; sector : comp; Percent : integer);
var nnn,ppp : string[9];
begin
if Batchmode then exit;
str(sector:6:0,nnn); str(percent:2,ppp);
writeMsg('sector '+nnn+' ('+ppp+'%) '+msg+'  ',6,17,Green);
end;

function ScanDiskette(PhysicalDrive : integer; MaxCylinder,MaxHead,Sectors : word) : boolean;
var buffer : ^SectorArray;
    Head,Cyl : word;
    st       : string80;
    scale    : integer;
begin
getmem(buffer,512*Sectors);
ScanDiskette:=true;
if MaxCylinder>70 then Scale:=(69+MaxCylinder) div 70
                  else scale:=1;
for Cyl:=0 to MaxCylinder do
    begin
    for Head:=0 to MaxHead do
        begin
        ShowOkay('cylinder='+decimal(Cyl)+'/head='+decimal(Head),
          Sectors*(Head+succ(MaxHead)*Cyl)+1,
          cyl*100 div MaxCylinder);
        DOSERROR:= ReadViaBios(PhysicalDrive,Cyl,Head,1,Sectors,buffer^);
        if DOSERROR<>0
           then begin
                FaultySector(hex2(DOSERROR)+' ('+BiosError(DosError)+') at cyl='
                     +decimal(cyl)+'/head='+decimal(head),(Cyl*succ(MaxHead)+Head)*Sectors,Sectors,nil);
                ScanDiskette:=false;
                st:='B'
                end
           else if (scale=1) or odd(cyl)
                   then st:=''
                   else st:='';
        WriteMsg(st,6+Cyl div scale,16-Head,$70);
        end;
    end;
freemem(buffer,512*sectors);
end;

function ScanHardDisk( BPB : BiosParameterBlock) : boolean;
var buffer : ^SectorArray;
    i,j,k,
    SPC    : integer;
    cluster: longint;
    kount      : word;
    Chart   : array[0..200] of char;
begin
kount:=2;
fillchar(chart,sizeof(chart),' ');
ScanHardDisk:=true;
with CurrentBootSector.BPB do
     begin
     SPC:=SectorsPerCluster;
     if (SPC<1) or (SPC>32)
        then begin LogMessage('Cannot make sense of this disk''s Sectors-per-cluster!'); exit; end;
     getmem(buffer,512*SPC);
     for cluster:=2 to MaxCluster do
         if not Dos_ReadSector(DriveNumber-1,ClusterOffset + (cluster-2)*SPC,SPC,buffer^)
            then begin
                 i:=100*Cluster div MaxCluster;
                 Chart[i]:='B';
                 WriteMsg('B',5+ (i div 2),16-(i and 1),$70);
                 FaultySector('Error '+hex2(DosError)+' reading cluster: '+decimal(cluster)
                             ,(ClusterOffset + cluster*SPC),SPC,nil);
                 ScanHardDisk:=false;
                 end
            else if (cluster mod kount)=0
                    then begin
                         j:=200*Cluster div MaxCluster;
                         i:=j div 2;
                         if Chart[i]='B'  {keep bad block flag}
                            then WriteMsg('B',5+ (i div 2),16-(i and 1),$70)
                            else begin
                                 if odd(j) then Chart[i]:=''
                                           else Chart[i]:='';
                                 WriteMsg(Chart[i],5+ (i div 2),16-(i and 1),$07);
                                 end;
                         ShowOkay('Cluster='+decimal(cluster),ClusterOffset + (cluster-2)*SPC,100*Cluster div MaxCluster);
                         kount:=max(4,MaxCluster div 200);
                         end;
     ShowOkay('Cluster='+decimal(MaxCluster),ClusterOffset + (MaxCluster-2)*SPC,100);
     freemem(buffer,512*SPC);
     end;
end;

function FormatWithUnits(N : comp) : string80;
var st : string80;
begin
if Units=Kb
   then begin str(N/1024:8:1,st); st:=st+' Kb'; end
   else begin str(N/1.024e6:8:1,st); st:=st+' Mb'; end;
FormatWithUnits:=st;
end;

procedure ScanThisDisk(Drive : string);
var DriveLetter : char;
    Row         : byte;
    DriveDesc   : string;
    Sectors,MaxHead,MaxCylinder : longint;
    Success,
    GotBootSector : boolean;
    Buffer        : ^BigArray;
    N             : Comp;
    SPC,
    cluster       : word;

   procedure Check(Title : string80; TestRoutine : BooleanFunction);
   var Success : boolean;
   begin
   if not Batchmode then WriteMsg(Translate(Title),13,Row,Cyan);
   Success:=TestRoutine;
   if Success
      then st:=Translate('Okay')
      else st:=Translate('Error');
   if not Batchmode then WriteMsg(st,12-length(st),Row,Yellow)
                    else if Success then writeln(st:9,' ',Translate(Title));
   inc(Row);
   end;

begin
DriveLetter:=upcase(Drive[1]);
DriveNumber:=ord(DriveLetter) and $1F;
LineCount:=0;
fillchar(CurrentBootSector,sizeof(bootsector),0);
GotBootSector:=Dos_ReadSector(DriveNumber-1, 0, 1, CurrentBootSector);
if not GetDriveParameters(DriveNumber,PhysicalDrive,Sectors,MaxHead,MaxCylinder,DriveDesc)
   then begin
        if GotBootsector
           then DriveDesc:=Translate('Unknown disk type ('+decimal(DriveDetails.DriveType)+')');
        end
   else begin
        if not GotBootsector then move(DriveDetails.DeviceBPB,CurrentBootSector.BPB,sizeof(BiosParameterBlock));
        end;

if (PhysicalDrive<>Unknown) and not GotBootsector
           then begin
                reg.ah:=ReadViaBios(PhysicalDrive,0,0,1, 1, CurrentBootSector);
                if reg.ah=0 then GotBootsector:=true;
                end;
if GotBootsector
   then with CurrentBootsector do move(BPB,DriveDetails.DeviceBPB,sizeof(BPB))
   else begin
        st:=Translate('Cannot access disk ')+DriveLetter+': ('+BiosError(reg.ah)+')';
        WarningMessage(st);
        exit;
        end;

if BatchMode
   then begin
        OutputLine('Scanning drive '+Drive+': ('+DriveDesc+')');
        end
   else begin
        PaintScreen('ScanDisk '+Translate('is now checking drive ')+DriveLetter+':');
        end;

InfoMsg(' '+DriveDesc+' drive');
Row:=4;

if not Batchmode then WriteMsg(Translate('Boot sector'),13,Row,Cyan);
Success:=CheckBootsector(FStype,CurrentBootsector);
if Success
   then st:=Translate('Okay')
   else st:=Translate('Error');
N:=sectors*succ(MaxHead)*succ(MaxCylinder);
if FStype in [FAT12..FAT16,ALFS]
   then with CurrentBootsector,BPB do
        begin
        if SectorsPerTrack<4
           then LogMessage('Boot sector reports '+decimal(SectorsPerTrack)
                          +' sectors per track; maximum from drive is '+decimal(Sectors))
           else Sectors:=SectorsPerTrack;
        if (NumberOfSides=0)
           then LogMessage('Boot sector reports 0 sides (heads); maximum for drive is '+decimal(MaxHead+1))
           else MaxHead:=pred(NumberOfSides);
        if (BigTotalSectors=0) or (TotalSectors>=360)
           then BigTotalSectors:=TotalSectors;
        ClusterOffset:=1+NumberOfFats*SectorsPerFAT + RootEntries div 16;
        DataSectors:=(BigTotalSectors-ClusterOffset);
        MaxCluster:=1 + (DataSectors div SectorsPerCluster);
        WastedBytes:=DataSectors-(SectorsPerCluster*(MaxCluster-1));
        if (NumberOfSides>64)
           then LogMessage('Boot sector reports '+decimal(NumberOfSides)+' sides; some software may have trouble with this');
        if (TotalSectors>1) or (FStype=ALFS)
           then N:=TotalSectors
           else N:=BigTotalSectors;

        if (Sectors*NumberofSides)=0
           then MaxCylinder:=pred(40)
           else MaxCylinder:=pred(round(N / (Sectors*NumberOfSides)));
        end;
if not Batchmode then WriteMsg(st,12-length(st),Row,Yellow);
inc(Row);

if DriveIsntRemovable(DriveNumber)=0
           then Units:=Kb
           else Units:=Mb;

with CurrentBootsector,BPB do
     N:=N*512.0;

if Units=Kb then begin
                 str(N / 1024:8:1,st);
                 st:=st+' Kb '+FSname[FsType]+' diskette';
                 end
            else begin
                 str(N / 1.024e6:8:1,st);
                 st:=st+' Mb '+FSname[FsType]+' partition';
                 end;
InfoMsg(st);

Check('Free space accounting',CheckFreeSpace);

Check('Directory structure',CheckDirectoryStructure);

Check('VFAT-style long filenames',CheckVFAT);

Check('Cross-links (twice-allocated areas)',CheckCrosslinks);

if HiddenFiles>0
   then InfoMsg(FormatWithUnits(HiddenBytes)+' '+decimal(HiddenFiles)+' hidden files');

InfoMsg(FormatWithUnits(DirectoryBytes)+' dir. structure');

n:=DiskFree(DriveNumber);
InfoMsg(FormatWithUnits(TrueTotalBytes-HiddenBytes-UserFileBytes-DirectoryBytes-n)+' system overheads');

InfoMsg(FormatWithUnits(UserFileBytes)+' '+decimal(UserFiles)+' user files');

InfoMsg('');
InfoMsg(FormatWithUnits(N)+' free space');

if Want(SurfaceScan,'Surface scan?')
   then with CurrentBootSector,BPB do
             begin
             if not Batchmode then WriteMsg(Translate('Surface scan'),13,Row,Cyan);
             if (MaxHead<=2) and (MaxCylinder<88)
                then Success:=ScanDiskette(PhysicalDrive,MaxCylinder,MaxHead,Sectors)
                else Success:=ScanHardDisk(BPB);
             if Success
                then st:=Translate('Okay')
                else st:=Translate('Error');
             if not Batchmode then WriteMsg(st,12-length(st),Row,Yellow);
             inc(Row);
             end;
WriteMsg('ScanDisk '+Translate('has now finished checking drive ')+DriveLetter+':',3,3,Brown);
if FaultsFound=nil
   then st:=Translate('no faults')
   else if FaultCount=1
           then st:=Translate('found a fault')
           else st:=Translate('found '+decimal(FaultCount)+' faults!');
LogMessage('Finished checking '+Drive+', '+st);
end;

begin
AllowableAttributes:=$3F;
DefaultNoOption:='C';
intr($11,reg);
with reg do if odd(AX) then NumberOfFloppyDiskDrives:=succ((AX shr 6) and 3)
	               else NumberOfFloppyDiskDrives:=0;

if not Parse('VeRsIoN='+version+#0,'CoPyRiGhT='+copyright+#0,author,
        ValidOptions,Syntax,WhatItDoes)
	then halt;

{process / options (other than standard ones the Parse routine will have done)}
if pos('/T',Globals)>0 then TimingTests:=Yes
   else if pos('T',NoOptions)>0 then TimingTests:=No;
if pos('/B',Globals)>0 then Batchmode:=true;
if pos('/C',Globals)>0 then CheckOnly:=Yes
   else if pos('C',NoOptions)>0 then CheckOnly:=No;
if pos('/D',Globals)>0 then DeleteLost:=Yes
   else if pos('D',NoOptions)>0 then DeleteLost:=No;
if pos('/F',Globals)>0 then FixFaults:=Yes
   else if pos('F',NoOptions)>0 then FixFaults:=No;
if pos('/T',Globals)>0 then TimingTests:=Yes
   else if pos('T',NoOptions)>0 then TimingTests:=No;
if pos('/S',Globals)>0 then SurfaceScan:=Yes;
if (pos('S',NoOptions)>0) then NoSummary:=Yes;
{      PartitionTest }
{      SoakTest  }
{      VirusScan }


ScanThisDisk(Parameter[1]^);

if not BatchMode then gotoXY(1,25);

FinishOff;
end.
