#
# Makefile for Borland C++ 3.1 for kernel.exe
#
# $Id: KERNEL.MAK,v 1.1.1.1 1999/03/29 15:41:15 jprice Exp $
#
# $Log: KERNEL.MAK,v $
# Revision 1.1.1.1  1999/03/29 15:41:15  jprice
# New version without IPL.SYS
#
# Revision 1.7  1999/03/01 06:04:37  jprice
# Fixed so it'll work with config.mak
#
# Revision 1.6  1999/03/01 05:46:43  jprice
# Turned off DEBUG define.
#
# Revision 1.5  1999/02/09 04:49:43  jprice
# Make makefile use common config.mak file
#
# Revision 1.4  1999/02/08 05:55:57  jprice
# Added Pat's 1937 kernel patches
#
# Revision 1.3  1999/02/04 03:09:59  jprice
# Added option to share constants (-d).
#
# Revision 1.2  1999/01/22 04:13:26  jprice
# Formating
#
# Revision 1.1.1.1  1999/01/20 05:51:01  jprice
# Imported sources
#
#
#   Rev 1.8.1 10 Jan 1999            SRM
#Took out "/P-" from TLINK
#Changed "bcc" to "tcc"
#
#   Rev 1.9   06 Dec 1998  8:45:40   patv
#Added new files for I/O subsystem.
#
#   Rev 1.8   22 Jan 1998 14:50:06   patv
#Outdated stacks.asm.
#
#   Rev 1.6   03 Jan 1998  8:36:50   patv
#Converted data area to SDA format
#
#   Rev 1.5   30 Jan 1997  7:55:54   patv
#Added TSC flag for trace support.
#
#   Rev 1.4   16 Jan 1997 12:46:42   patv
#pre-Release 0.92 feature additions
#
#   Rev 1.3   29 Aug 1996 13:07:34   patv
#Bug fixes for v0.91b
#
#   Rev 1.2   29 May 1996 21:03:32   patv
#bug fixes for v0.91a
#
#   Rev 1.1   19 Feb 1996  3:35:38   patv
#Added NLS, int2f and config.sys processing
#
#   Rev 1.0   02 Jul 1995  8:30:22   patv
#Initial revision.
#
# $EndLog$
#

!include "..\config.mak"

RELEASE = 1.00

.AUTODEPEND

#
# Compiler and Options for Borland C++
# ------------------------------------
LIBPATH = .
INCLUDEPATH = ..\HDR
#CFLAGS          = -v -X -I. -D__STDC__=0 -DTSC -DDEBUG -DKERNEL -DI86 -DPROTO -DSHWR -DASMSUPT
#CFLAGS          = -v -X -I. -D__STDC__=0 -DTSC -DKERNEL -DI86 -DPROTO -DSHWR -DASMSUPT
AFLAGS          = /Mx /DSTANDALONE=1 /I..\HDR
LIBS            =..\LIB\DEVICE.LIB ..\LIB\LIBM.LIB

#               *Implicit Rules*
.c.obj:
  $(CC) +kernel.cfg -c {$< }

.cpp.obj:
  $(CC) +kernel.cfg -c {$< }

#               *List Macros*


EXE_dependencies =  \
 kernel.obj \
 entry.obj \
 io.obj \
 blockio.obj \
 chario.obj \
 dosfns.obj \
 console.obj \
 printer.obj \
 serial.obj \
 dsk.obj \
 error.obj \
 fatdir.obj \
 fatfs.obj \
 fattab.obj \
 fcbfns.obj \
 initoem.obj \
 inthndlr.obj \
 irqstack.obj \
 ioctl.obj \
 main.obj \
 config.obj \
 memmgr.obj \
 misc.obj \
 newstuff.obj \
 nls.obj \
 dosnames.obj \
 prf.obj \
 strings.obj \
 sysclk.obj \
 syspack.obj \
 systime.obj \
 task.obj \
 int2f.obj \
 apisupt.obj \
 asmsupt.obj \
 execrh.obj \
 nlssupt.obj \
 procsupt.obj

#               *Explicit Rules*

production:     ..\bin\kernel.sys

..\bin\kernel.sys: kernel.sys
                copy kernel.sys ..\bin

kernel.sys:	kernel.exe
                ..\utils\exeflat kernel.exe kernel.sys 0x60 >nul

clobber:        clean
                del kernel.exe
                del kernel.sys

clean:
        ..\utils\rm -f *.obj *.bak *.crf *.xrf *.map *.lst *.las status.me

kernel.exe: kernel.cfg $(EXE_dependencies)
  $(LINK) /m/c/L$(LIBPATH) @&&|
kernel.obj+
entry.obj+
io.obj+
blockio.obj+
chario.obj+
dosfns.obj+
console.obj+
printer.obj+
serial.obj+
dsk.obj+
error.obj+
fatdir.obj+
fatfs.obj+
fattab.obj+
fcbfns.obj+
initoem.obj+
inthndlr.obj+
ioctl.obj+
main.obj+
config.obj+
memmgr.obj+
misc.obj+
newstuff.obj+
nls.obj+
dosnames.obj+
prf.obj+
strings.obj+
sysclk.obj+
syspack.obj+
systime.obj+
task.obj+
int2f.obj+
irqstack.obj+
apisupt.obj+
asmsupt.obj+
execrh.obj+
nlssupt.obj+
procsupt.obj
kernel          # exe file
kernel          # map file
$(LIBS)
|
	tdstrip kernel.exe


#               *Individual File Dependencies*
kernel.obj: kernel.cfg kernel.asm segs.inc
        $(ASM) $(AFLAGS) kernel,,;

console.obj: kernel.cfg console.asm io.inc
        $(ASM) $(AFLAGS) console,,;

printer.obj: kernel.cfg printer.asm io.inc
        $(ASM) $(AFLAGS) printer,,;

serial.obj: kernel.cfg serial.asm io.inc
        $(ASM) $(AFLAGS) serial,,;

entry.obj: kernel.cfg entry.asm
        $(ASM) $(AFLAGS) entry,,;

blockio.obj: kernel.cfg blockio.c globals.h

chario.obj: kernel.cfg chario.c globals.h

dosfns.obj: kernel.cfg dosfns.c globals.h

dsk.obj: kernel.cfg dsk.c globals.h

error.obj: kernel.cfg error.c globals.h

fatdir.obj: kernel.cfg fatdir.c globals.h fatdir.c

fatfs.obj: kernel.cfg fatfs.c globals.h fatfs.c

fattab.obj: kernel.cfg fattab.c globals.h

fcbfns.obj: kernel.cfg fcbfns.c globals.h

initoem.obj: kernel.cfg initoem.c globals.h

inthndlr.obj: kernel.cfg inthndlr.c globals.h

ioctl.obj: kernel.cfg ioctl.c globals.h

main.obj: kernel.cfg main.c globals.h

config.obj: kernel.cfg config.c globals.h

memmgr.obj: kernel.cfg memmgr.c globals.h

misc.obj: kernel.cfg misc.c globals.h

nls.obj: kernel.cfg nls.c globals.h

newstuff.obj: kernel.cfg newstuff.c globals.h

dosnames.obj: kernel.cfg dosnames.c globals.h dosnames.c

prf.obj: kernel.cfg prf.c globals.h

strings.obj: kernel.cfg strings.c globals.h

sysclk.obj: kernel.cfg sysclk.c globals.h

syspack.obj: kernel.cfg syspack.c globals.h

systime.obj: kernel.cfg systime.c globals.h

task.obj: kernel.cfg task.c globals.h

apisupt.obj: kernel.cfg apisupt.asm
        $(ASM) $(AFLAGS) APISUPT,,;

asmsupt.obj: kernel.cfg asmsupt.asm
        $(ASM) $(AFLAGS) ASMSUPT,,;

execrh.obj: kernel.cfg execrh.asm
        $(ASM) $(AFLAGS) EXECRH,,;

int2f.obj: kernel.cfg int2f.asm
        $(ASM) $(AFLAGS) int2f,,;

io.obj: kernel.cfg io.asm segs.inc
        $(ASM) $(AFLAGS) io,,;

irqstack.obj: kernel.cfg irqstack.asm
        $(ASM) $(AFLAGS) irqstack.asm,,;

nlssupt.obj: kernel.cfg nlssupt.asm
        $(ASM) $(AFLAGS) nlssupt,,;

procsupt.obj: kernel.cfg procsupt.asm
        $(ASM) $(AFLAGS) PROCSUPT,,;

proto.h:        $(CSRC) $(LIBCSRC1) $(LIBCSRC2) $(LIBCSRC3) $(LIBCSRC4)
                echo /* proto.h generated by make */ > proto.h
                echo #undef _P >> proto.h
                ..\utils\proto $(CSRC)
                ..\utils\proto $(LIBCSRC1)
                ..\utils\proto $(LIBCSRC2)
                ..\utils\proto $(LIBCSRC3)
                ..\utils\proto $(LIBCSRC4)
                echo Don't forget to edit proto.h for version control
