#define THECURSE_C                              /* protect this source file */

/* $Id: thecurse.c,v 1.1.1.1 1998/06/10 03:36:47 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* This is a library for Borland C, which simulates UNIX curses.  This
   is intended only to aid software ports from UNIX to Borland C.  I
   am NOT trying to re-implement curses for Borland. */

#include <stdio.h>
#include <conio.h>				/* Borland's console i/o */
#include <dos.h>				/* Borland: for sound() */

#include "thecurse.h"				/* header for this file */


/* globals, this file only */

int min_x = 1;					/* the standard PC screen */
int min_y = 1;

int fg_color = 7;				/* the usual colors */
int bg_color = 0;


/* globals */

int COLS = 80;					/* the standard PC screen */
int LINES = 25;


/* functions */

int
initscr (void)
{
  /* initialize the curses environment */

  textmode (C80);				/* set color, 80 cols */
  standend();					/* set normal colors */
  return (OK);
}

int
endwin (void)
{
  /* reset to default text mode */

  textmode (LASTMODE);				/* original text mode */
  return (OK);
}

int
move (int y, int x)
{
  /* Borland's conio library starts counting at 1, while curses starts
     counting at 0. */

  y++;
  x++;

  /* move the cursor. */

  if ((y < min_y) || (y > LINES)) {
    return (ERR);
  }

  if ((x < min_x) || (x > COLS)) {
    return (ERR);
  }

  gotoxy (x, y);
  return (OK);
}

int
addch (int ch)
{
  /* Add the character.  Borland returns the ch if successful, or EOF
     on error */

  if (putch (ch) == EOF) {
    return (ERR);
  }

  return (OK);
}

int
mvaddch (int y, int x, int ch)
{
  /* Do a move, then addch */

  if (move (y, x) == ERR) {
    return (ERR);
  }

  if (addch (ch) == ERR) {
    return (ERR);
  }

  return (OK);
}

int
addstr (const char *str)
{
  /* Print the string using multiple calls to addch */

  int i;

  for (i = 0; str[i] != '\0'; i++) {
    if (addch (str[i]) == ERR) {
      return (ERR);
    }
  } /* for */

  return (OK);
}

int
mvaddstr (int y, int x, char *str)
{
  /* Do a move, then an addstr */

  if (move (y, x) == ERR) {
    return (ERR);
  }

  if (addstr (str) == ERR) {
    return (ERR);
  }

  return (OK);
}

int
refresh (void)
{
  /* faked call to refresh the screen */

  return (OK);
}

int
standout (void)
{
  /* invert the foreground/background colors */

  textcolor (bg_color);

  if (fg_color > 7) {
    textbackground (fg_color - 8);
  }

  else {
    textbackground (fg_color);
  }

  return (OK);
}

int
standend (void)
{
  /* reset the foreground/background colors */

  textcolor (fg_color);
  textbackground (bg_color);

  return (OK);
}

/* getch - not needed, since Borland's conio already has one */

#if 0						/* this is deactivated code */
int
getstr (char *str)
{
  /* this is a lame get-string function, but it will do for now. */

  int ch;
  int i;

  i = 0;
  for (ch = getch(); ch != KEY_ENTER; i++) {
    str[i] = ch;

    /* print the char */

    if (addch (ch) == ERR) {
      return (ERR);
    }
  } /* for */

  return (OK);
}

int
mvgetstr (int y, int x, char *str)
{
  /* do a move, then a getstr */

  if (move (y, x) == ERR) {
    return (ERR);
  }

  if (getstr (str) == ERR) {
    return (ERR);
  }

  return (OK);
}
#endif /* 0 */

int
clrtoeol (void)
{
  /* clear to end of line */

  clreol();
  return (OK);
}

int
erase (void)
{
  /* erase screen */

  clrscr();
  return (OK);
}

int
clear (void)
{
  /* erase screen */

  clrscr();
  return (OK);
}

int
beep (void)
{
  /* make a beep - requires DOS.H */

  sound (440);					/* freq. in Hz */
  delay (100);					/* time in ms */
  nosound();					/* turn off sound */

  return (OK);
}
int
flash (void)
{
  return (beep());
}
