/*  EXPANDVARS - A sample of how to expand shell-style variables
Copyright (C) 1998 Steffen Kaiser

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: expandv.h,v $
$Locker:  $	$Name:  $	$State: Exp $

char *expandVars(char *str, char **keys, char **values, int items)

Expand variables in a string str. The returned string is
the dynamically allocated, expanded string.

Both arrays 'keys' and 'values' must contain at least 'items'
elements.
'keys' are matched case-insensitive.

There are three methods of expansion supported:
UNIXVARS:	Detects variables of the form:	$name or ${name} or $?
DOSVARS:	Detects variables of the form:	%name%
LETTER:	Detects variables of the form: %?

The $name variant takes all letters and/or digits following the
dollar sign. If no alnum() is present, take the next character.
The ${name} and %name% variants also substitute the closing mark.
The %? variant takes _any_ following character as the variable name.

Because no quoting mechanism is implemented, here is how to
insert:
UNIXVARS: a dollar sign: ${}
DOSVARS: a percent sign: %%
LETTERS: a percent sign: %%

Return:
NULL: if malloc() failed
else: expanded string

Target compilers:
+ Borland C v5.2

It compiles under and emits the expected results:
+ Micro-C v3.14

$Log: expandv.h,v $
Revision 1.1  1998/04/13 20:26:58  jhall
the include file for expandVars

Revision 1.1  1998/03/10 03:37:30  jhall
Included Steffan Kaiser's EXPANDVARS function.  This is version 1.1, which
includes a fix for non-DOS systems.  It is generally cleaner code, too.

Revision 1.1  1998/02/04 19:14:04  jhall
Initial revision

Revision 1.4  1998/02/01 07:11:50  ska
bugfix: elimited core dump because of modifying (const char) arrays
add: memicmp() function, is stricmp() or strcasecmp()

Revision 1.3  1998/02/01 06:43:46  ska
bugfix: if no variable scan mode is defined, an error is displayed
fix: some typos
chg: #include of global headers to be more ANSI-compliant
chg: local functions app_() scn() are static now

Revision 1.2  1998/01/21 07:48:09  ska
fix: LETTERS mode: at EOS the varible name is empty -> default entry added

Revision 1.1  1998/01/21 07:45:10  ska
Initial revision

*/

char *expandVars(const char *str, const char *keys[],
		 const char *values[], int items);
