/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  clustsize.h
// Module Description:  Cluster size specs header file.
*/


typedef struct Cluster_Size_Table
{
  unsigned long min_num_sectors;
  unsigned long max_num_sectors;
  unsigned int sectors_per_cluster;
  unsigned int cluster_size;
} CST;

CST cluster_size_table[7]=
{
  {    320,  16383, 8, 2048},         /* FAT12,  320KB to    8MB */
  {  16384,  32767, 8, 4096},         /* FAT12,    4MB to   16MB */
  {  32768, 262143, 4, 2048},         /* FAT16,   16MB to  128MB */
  { 262144, 524287, 8, 4096},         /* FAT16,  128MB to  256MB */
  { 524288,1048575,16, 8192},         /* FAT16,  256MB to  512MB */
  {1048576,2097151,32,16384},         /* FAT16,  512MB to 1024MB */
  {2097152,4194303,64,32768}          /* FAT16, 1024MB to 2048MB */
};
