/* $Id: STR.H 1.6 2000/03/31 09:09:34 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	Supplemental string functions.

ob(ject): utoa10
su(bsystem): misc
ty(pe): M
sh(ort description): Transform an unsigned decimal number into ASCII format
lo(ng description): Transforms an unsigned decimal number into its ASCII
	representation.
pr(erequistes): buf != NULL
va(lue): none
re(lated to): itoa10
se(condary subsystems): 
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers): 

ob(ject): itoa10
su(bsystem): misc
ty(pe): M
sh(ort description): Transform a signed decimal number into ASCII format
lo(ng description): Transforms a signed decimal number into its ASCII
	representation.
pr(erequistes): buf != NULL
va(lue): none
re(lated to): utoa10
se(condary subsystems): 
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers): 

   $Log: STR.H $
   Revision 1.6  2000/03/31 09:09:34  ska
   add: DBG_CLOSELOG, suppl_l_openmode
   add: SYSLOG_ALWAYS_FLUSHLOG
   add: fcommit(), Fcommit(), Fflush(), commit()
   add: suppl_log_flush(), DBG_FLUSHLOG, DBG_ALWAYS_FLUSHLOG
   fix: dfnsearch(): DBG_ARGUMENT()
   chg: F[gs]etpos() -> true replacements of f[gs]etpos(); removed
   	Fp[gs]etpos(); added FF[gs]etpos() using a non-pointer argument
   bugfix: secure string functions: memory functions don't accept length == 0
   add: MKSTRFCT.PL: generate DOC\SSTR.FCT
   fix: dfnsplit(): a pathname without path components returns the root
   	directory as path portion
   add: dfnsplit(): debug output of return values of found drive/path/name/ext
   fix: dfnsqueeze(): DBG_ENTER() contains wrong names
   fix: dfnsplit(): chkHeap in drive spec detection routine breaks if/else
   chg: moved NLS-depended stuff from DFN.H into NLS_F.H
   add: integer SUPPL error codes -- all functions returning (int) error codes
   	return unique codes used throughout all SUPPL, see ERRCODES.H

   Revision 1.5  1999/12/13 02:23:44  ska
   add: debug subsystem
   bugfix: Fposcmp(): If abs(pos1 - pos2) > 32767, the return value is random
   add: strend() --> returns the address of the NUL byte of a string
   chg: StrAppend() --> StrAppQStr()
   add: StrQuote(), StrUnquote()
   bugfix: Strspn(): if any parameter is NULL, returns NULL now
   bugfix: MemiCmp(): returned wrong sign
   bugfix: dfnstat(): Win95 LFN's entry never or invalidly detected
   add: dfndelim() & dfndelim2()
   chg: environ.h: mcb_toenv() --> macro mcb_env()
   fix: cfg_osen.c: cfg_ostkEnum(): If output stack empty --> random return value
   fix: strnum(): '0x' prefix detection fails
   chg: long*(): Except longcmp() all functions are void; for portable subsys
   bugfix: Erealloc(): if len == 0, the program is terminated erroreously
   add: Fcopyi() & Fcopyl() & Fcopybuf()
   chg: Fcopyto(): 'topos' must contain a valid position returned by Fgetpos()
   add: supplio.h: Fpos2dword() & Fppos2dword(): Extract (dword) pos from(fpos_t)
   chg: env_newsize() renamed into env_setsize()
   bugfix: env_check(): accepts no segm==0, as it is standard
   sub: dynstr.h: STR_SAVE_MODES, not used anymore (StrSaveTokens() removed)
   chg: dynstr.h: STR_SAVED_TOKENS is its own type now
   bugfix: StrTok*(): if(st) effects first assignment only
   bugfix: StrTail(): string is strdup()'ed two times
   bugfix: _fStriCmp(): temporary storage into (char) is unportable
   bugfix: StriCmp(): sign is inverted
   bugfix: StriCmp(): accepts no NULL parameters
   add: DFN_LFN to dfn.h and dfnstat()
   bugfix: UNC-aware dfnmatch2(): function name wrong
   sub: removed "Target compilers" note everywhere
   fix: dfnstat(): returns DFN_DIRECTORY on "X:" and "X:\"
   chg: No SUPPL function will invoke openlog() automatically

   Revision 1.4  1999/04/13 00:11:50  ska
   bugfix: dfnexpand(): fname == "" --> fname := "."
   bugfix: dfnsearch(): Searching root instead of '.' if no search path
   add: syslog subsystem
   fix: spelling in comments etc.
   bugfix: not all SUPPORT_UNC_PATH macros correct
   add: INI file random access subsystem
   add: Fmaxbuf()
   add: Fcopy(), Fcopyto()
   add: Fposcpy(), Fposcmp()
   add: memzero(): unportable memory zero'ing function

   Revision 1.3  1999/01/18 05:32:29  ska
   add: INI file writing functions
   fix: dfnstat() uses wrong register for result
   add: dfnfreplace(), dfnbakname()

   Revision 1.2  1999/01/05 08:41:12  ska
   fix: Esetsize() removed warning because of free()
   fix: some typos
   add: secure string functions

   Revision 1.1  1998/12/08 04:04:11  ska
   Initial revision

*/

#ifndef __STR_H
#define __STR_H

#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#endif
#include <portable.h>

char *skipws(const char *s);
char *skipwd(const char *s);
char *singleword(char *s);

/* void itoa10(int num, char * const buf); */
/* void utoa10(int num, char * const buf); */
#ifndef _MICROC_
#define itoa10(num,buf)	itoa((num), (buf), 10)
#define utoa10(num,buf) ultoa((unsigned)(num), (buf), 10)
#else
	/* negative radix --> signed */
#define itoa10(num,buf)	itoa((num), (buf), -10)
	/* positive radix --> unsigned */
#define utoa10(num,buf)	itoa((num), (buf), 10)
#endif

int strnum(const char * const s, int * const num, char ** const endp);
int strbool(char *s);

/* memzero() fills a block of memory with 0; used throughout
	SUPPL where a larger amount of values of data types: (int), (short),
	(char) and pointers are to initialize with 0 or NULL.
	It is unportable, but efficient on portable systems; because of this
	macro places, where to port on failure, are easy to locate. */
/* void memzero(void *poi, size_t length); */
#define memzero(poi,length)	memset((poi), 0, (length))
#define memzerobj(object)	memzero(&object,sizeof(object))
#define memzerostrct(structure)	memzero(aS(structure),sizeof(structure))

#endif
