/*	$id$
	$Locker:  $	$Name:  $	$State: Exp $

	Performs an user prompt

	Display prompt (if any), get user input via vcgetchar(),
	map key to metakey, return metakey if valid.

	$Log: msg_prmp.c,v $
	Revision 1.1  2001/04/12 00:33:53  skaus
	chg: new structure
	chg: If DEBUG enabled, no available commands are displayed on startup
	fix: PTCHSIZE also patches min extra size to force to have this amount
	   of memory available on start
	bugfix: CALL doesn't reset options
	add: PTCHSIZE to patch heap size
	add: VSPAWN, /SWAP switch, .SWP resource handling
	bugfix: COMMAND.COM A:\
	bugfix: CALL: if swapOnExec == ERROR, no change of swapOnExec allowed
	add: command MEMORY
	bugfix: runExtension(): destroys command[-2]
	add: clean.bat
	add: localized CRITER strings
	chg: use LNG files for hard-coded strings (hangForEver(), init.c)
		via STRINGS.LIB
	add: DEL.C, COPY.C, CBREAK.C: STRINGS-based prompts
	add: fixstrs.c: prompts & symbolic keys
	add: fixstrs.c: backslash escape sequences
	add: version IDs to DEFAULT.LNG and validation to FIXSTRS.C
	chg: splitted code apart into LIB\*.c and CMD\*.c
	bugfix: IF is now using error system & STRINGS to report errors
	add: CALL: /N
	
 */

#include "../config.h"

#include <assert.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/misc.h"

int userprompt(unsigned id,...)
{
	char *fmt, *str;
	int ch;

	if(!getPromptString(id, &str, &fmt))
		return 0;

	/* Issue message */
	if(*fmt) {
		va_list ap;

		va_start(ap, id);
		vprintf(fmt, ap);
		va_end(ap);
	}

	while((ch = vcgetchar()) == 0 || (ch = mapMetakey(str, ch)) == 0)
		beep();                     /* hit erroreous character */

	putchar('\n');                /* advance to next line */
	freePromptString(str, fmt);

	return ch;
}
