/*
 *  INIT.C - initialization code
 *
 *      This is more or less a complete rewrite based on the
 *      initialize() code of v0.74c, but also some changes of 0.75b.
 *
 *  Comments:
 *      1998/07/19 ska  removed from COMMAND.C and put into this file
 *
 * 09-Sep-1998 ska
 * - fix/chg: ^Break handler now handles external programs properly
 *
 * 01-Dec-1998 jpp
 * - finished batch file trace mode.  Fixed bug with /C command line switch
 *   running batch files
 * - Added about 2 second delay where user can press F8 to run autoexec.bat
 *   in tracemode, or press F5 to bypass autoexec.bat completely.
 *
 * 1998/12/04 ska
 *  bugfix: "/C" collection of already broken-up arguments
 *
 * 1998/12/05 ska
 * - add: command line parsing as mention in the strings\strings.txt help page
 * - add: issue the help screen on "/?" [with display_string()]
 * - add: set "exitflag" if help screen was issued or an invalid option
 *  was found. If exit is OK, COMMAND will terminate then
 * - add: load messages into conventional far memory
 *
 * 1999/01/08 ska
 * - bugfix: on suggestion of Charles Dye (raster@highfiber.com) "/ccommand"
 *      "/c" must work without a space between [MS COMMAND compatibly]
 *      also mimics: "/c/? dir" --> bad command or filename
 * - add: DR DOS compatibly: "/c:" and "/c="
 *      even supports wierd looking: "/c:dir/?"
 * - add: DR DOS compatibly: "/p:AUTOEXEC_replacement"
 * - sub: calling _fullpath() for ComDir; at this point the path must be
 *      fully-qualtifed by convention of the environ
 *
 * 1/Feb/1999 Rob Linwood
 * - removed the "static" modifier from "showcmds()" so it could be used
 *   in the "?" command
 *
 * 11-Feb-1999 (John P Price <linux-guru@gcfl.net>)
 * - using keypressed() that I wrote instead of Turbo C's kbhit() function
 *   because for some reason kbhit() hangs under the FreeDOS kernel.
 * - prints seconds as it waits for a keypress from user (during initial
 *   boot)
 * - Fixed path to autoexec.bat.
 *
 * 24-Mar-1999 (John P Price <linux-guru@gcfl.net>)
 * - changed the way we run autoexec.bat or a batch file on the command line.
 *
 * 1999/04/23 ska
 * chg: ComDir: replaced by ComPath, comFile() & comPathFile()
 * fix: combination of "/p" and "/c"|"/k" did not work
 */

#include "config.h"

#include <assert.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <alloc.h>

#include "mcb.h"
#include <environ.h>
#include "err_hand.h"
#include "batch.h"
#include "timefunc.h"
#include <dfn.h>

#include "strings.h"

				/* Check for an argument; ch may be evaluated multiple times */
#define isargsign(ch)           \
				((ch) == ':' || (ch) == '=')

/* Name of the executable */
#define COM_NAME "COMMAND.COM"

extern int aliasload(char *, char *);
extern void initCBreakCatcher(void);

static unsigned oldPSP;
char *ComPath;                   /* absolute filename of COMMAND shell */

/* Without resetting the owner PSP, the program is not removed
   from memory */
void exitfct(void)
{
#ifdef FEATURE_LOAD_MESSAGES
  uninitModuleStrings();        /* free the message strings segment */
#endif
  OwnerPSP = oldPSP;
}

/*
 * show commands and options that are available.
 *
 */
#pragma argsused
int showcmds(char *rest)
{
  struct CMD *cmdptr;
  unsigned char y;
  extern struct CMD cmds[];     /* The internal command table */

  puts("Internal commands available:");
  y = 0;
  cmdptr = cmds;
  while (cmdptr->name)
  {
    if (++y == 8)
    {
      puts(cmdptr->name);
      y = 0;
    }
    else
      printf("%-10s", cmdptr->name);

    cmdptr++;
  }
  if (y != 0)
    putchar('\n');
  printf("\nFeatures available: ");
#ifdef FEATURE_ALIASES
	printf("[aliases] ");
#endif
#ifdef FEATURE_HISTORY
  printf("[history] ");
#endif
#ifdef FEATURE_FILENAME_COMPLETION
  printf("[filename completion] ");
#endif
#ifdef FEATURE_LOAD_MESSAGES
  printf("[load messages] ");
#endif
#ifdef FEATURE_SWAP_EXEC
  printf("[swapping] ");
#endif
  putchar('\n');

  return 0;
}

int keypressed(void)
{
  union REGS r;

  r.h.ah = 0x01;

  int86(0x16, &r, &r);

  /* Check the zero flag.  Z=0 means a key was pressed; Z=1 means no key */
  if (r.x.flags & 0x40)
    return 0;
  else
    return 1;
}

/* Waits about 3 secs for a keypress.
   returns 0 if none else returns key pressed.
 */

int WaitForFkeys(void)
{
  struct dostime_t start;
  struct dostime_t now;
  int secs = 3;
  int ch;

	_dos_gettime(&start);
  printf("%d", secs);
  while (secs)
  {
    _dos_gettime(&now);
    if (now.second != start.second)
    {
      _dos_gettime(&start);
      secs--;
      printf("\b%d", secs);
    }
    if (keypressed())
    {
      if ((ch = getch()) == 0)
        ch = getch() + 256;
      printf("\b ");
      return ch;
    }
  }
  printf("\b ");
  return 0;
}

#define KEY_F5   319
#define KEY_F8   322

/*
   Read the argument of the option as a number and return:
   1 && *value != 0: success
   1 && *value == 0: if option found, but number invalid
   0: no argument found --> not the option
 */
int fetchNum(unsigned *value, char *q, char *option, int low, int high)
{
  unsigned e;

  assert(value);
  assert(q);
  assert(option);

  *value = e = 0;
  if (isargsign(*q))
  {
    if (!q[1])
    {
      printf("Argument missing in: %s\n", option);
      return 1;
    }

		while (isdigit(*++q))
      e = e * 10 + *q - '0';
    if (*q)
      printf("Invalid number in: %s\n", option);
    else if (e > high)
      printf("Number must not exceed %u in: %s\n", high, option);
    else if (e < low)
      printf("Number be greater than or equal to %u in: %s\n", low, option);
    else
      *value = e;
    return 1;
  }
	return 0;
}

/*
 * set up global initializations and process parameters
 *
 * argc - number of parameters to command.com
 * argv - command-line parameters
 *
 *      This function will:
 *      1) Set up the host environment (Create a new environment segment if
 *              necessary, alter the parent process ID, catch ^Break etc.)
 *      2) Create the COMSPEC variable
 *      3) Parse the command line parameters passed to COMMAND.COM
 *      4) Perform all command line actions (spawn "/c" commands, alters
 *              size of environment etc.)
 *      5) If shell is interactive, invoke a ver() command.
 */

#pragma argsused
int initialize(int argc, char *argv[])
{
	char *comPath;                /* path to COMMAND.COM (for COMSPEC/reload) */
	char *newTTY;                 /* what to change TTY to */
	unsigned envSize;             /* minimum environment size (/E:) */
	int loadMSGs;                 /* load messages permanent into memory (/MSG) */
	int spawnCmd;                 /* spawn command (/C or /K) */
	int showhelp;                 /* show help screen */
  int showinfo;                 /* show initial info only if no command line options */
	int key;

  char *argv0;                  /* preserve argv[0] for later */
  char *autoexec;               /* of AUTOEXEC.BAT to be started see /P */
  char *p;
	char *q;
	char *h;                      /* during scanning the command line
																	 and to pass an argument to spawnCmd */
	char buf[256];
	unsigned e;
	extern int canexit;

/* Set up the host environment of COMMAND.COM */

	printf("Starting FreeCom...\n\n");

	/* Install the ^Break handler (see chkCBreak() for more details) */
	printf("[initCBreakCatcher]\n");
	initCBreakCatcher();

	/* Install INT 24 Critical error handler */
	printf("[init_error_handler]\n");
	init_error_handler();

	/* DOS shells patch the PPID to the own PID, how stupid this is, however */

	oldPSP = OwnerPSP;
	atexit(exitfct);
	OwnerPSP = _psp;

  /* Some elder DOSs may not receive an initialized environment segment */
	if (env_glbSeg && !isMCB(SEG2MCB(env_glbSeg)))
		env_setGlbSeg(0);

/* Now parse the command line parameters passed to COMMAND.COM */
	/* Preparations */
	comPath = newTTY = NULL;
	loadMSGs = tracemode = spawnCmd = showhelp = 0;
	showinfo = 1;

	autoexec = "\\AUTOEXEC.BAT";  /* standard name for it */

	/*JPP added 128 to size so that we can add COMSPEC and other variables */
	envSize = env_resize(0, 0) + 128;
	if (envSize < 160 || envSize > 32767)	/* invalid size? */
		envSize = 256;
	argv0 = argv[0];              /* preserve for later */

	while (!spawnCmd && (p = *++argv) != NULL)
	{                             /* one next argument */
		if (*p != '/')
		{                           /* non-option argument */
			if (!comPath)
				comPath = p;
			else if (!newTTY)
				newTTY = p;
			else
			{
				puts("Too many arguments");
				break;
			}
			if ((p = strchr(p, '/')) == NULL)	/* no option appended */
				continue;
      *p = '\0';
    }

    /* scan options */
    while (p && *++p)
    {
      /* h := begin of option for printing error messages
         p := end of option string
         q := running pointer through option string
       */
      if ((p = strchr(h = q = p, '/')) != NULL)
        *p = '\0';
      switch (toupper(*q++))
      {
        case 'K':
        case 'C':
          h = NULL;             /* means: no additional word */
          if (p)
            *p = '/', p = NULL; /* support for "/c:dir/?" */
          if (isargsign(*q))
          {                     /* "/C:" or "/C=" */
            if (q[1])
              h = &q[1];
					}
          else if (*q)          /* "/C<command> shortcut */
            h = q;
          spawnCmd = toupper(q[-1]);
          showinfo = 0;
          break;

        case 'E':
          if (fetchNum(&e, q, h, 256, 32767))
          {
            if (e && envSize < e)	/* don't shrink below minimum */
              envSize = e;
          }
          else
            goto unknown;
          break;

        case 'F':
          if (*q)
            goto unknown;
          autofail = 1;
					break;

        case 'L':
          if (strcmpi(q, "OW") == 0)
            forceLow = 1;
          else if (fetchNum(&e, q, h, 128, 1023))
          {
            if (e)
              puts("/L is not implemented, yet");
          }
          else
            goto unknown;
          break;

        case 'M':
          if (strcmpi(q, "SG") == 0)
            loadMSGs = 1;
          else
            goto unknown;
          break;

        case 'P':
          if (isargsign(*q) && q[1])	/* set AUTOEXEC.BAT filename */
            autoexec = &q[1];
					else if (*q)
            goto unknown;
          canexit = 0;
          break;

        case 'U':
          if (fetchNum(&e, q, h, 128, 255))
          {
            if (e)
              puts("/U is not implemented, yet");
          }
          else
            goto unknown;
          break;

        case 'Y':
          if (*q)
            goto unknown;
          tracemode = 1;
          showinfo = 0;
          break;

        case '?':
          exitflag = showhelp = 1;
          break;

        default:
        unknown:
          printf("Unknown option: %s\n", h);
          exitflag = 1;
          break;
      }
    }
  }

  /* At this point:
     If spawnCmd != 0, 'h' may point to an optionally argument
     used as the first word in the command line to be constructed
     (which is the remainder of "/C***", "/C:" or "/C=").
   */

/* Now process the options */

#ifdef INCLUDE_CMD_CTTY

  if (newTTY)                   /* change TTY as early as possible so the caller gets
                                   the messages into the correct channel */
    cmd_ctty(newTTY);
#endif

  /* First of all, set up the environment */
  env_resizeCtrl |= ENV_USEUMB | ENV_ALLOWMOVE;
  if (!env_newsize(0, envSize))
    puts("Could not resize/create environment");
#ifdef DEBUG
  else
    {
      printf("Environment size set to %d bytes.\n", envSize);
    }
#endif

  /* Then add the COMSPEC variable */
  if (comPath)
  {
    /* Remove quotes, maybe this comes handy in the future */
    q = stpcpy(buf, *comPath == '"' ? comPath + 1 : comPath);
    if (q[-1] == '"')
      --q;
    if (buf[1] != ':' || buf[2] != '\\')
    {
      puts("The path to " COM_NAME " must be fully qualified!\n"
           "That means including drive letter and beginning with a backslash.\n"
           "For example: C:\\FDOS");
    }
    else
    {
      strcpy(q, "\\" COM_NAME);
      if (exist(buf))
      {
        q = buf;
        goto comFound;
      }
      printf("Cannot find " COM_NAME " in: %s\n", comPath);
    }
  }

  if (!argv0 || !*argv0 || !exist(argv0))
  {
    if (argv0 && *argv0)
      printf("Cannot find: %s\n", argv0);
    puts("You must specify the complete path to " COM_NAME);
    puts("as the first argument of COMMAND,");
		puts("for instance: C:\\FDOS");
    exit(101);
  }

  q = argv0;

comFound:
	/* Make a copy of the filename of the COMMAND shell into the heap
		and also make sure it is an absolute one. */
	if((ComPath = dfnexpand(q, NULL)) == NULL) {
    error_out_of_memory();
		exitflag = 1;
  }

  if (chgEnv("COMSPEC", ComPath))
    error_env_var("COMSPEC");

  if (showhelp)
    display_string(TEXT_CMDHELP_COMMAND);
  if (exitflag && canexit)
    return 1;

  /* Here the messages had to be loaded, the filename is in 'p' */
  if (loadMSGs)
  {
#ifdef FEATURE_LOAD_MESSAGES
    if (!loadMsgs())
      display_string(TEXT_FAILED_LOAD_STRINGS);
#else
    display_string(TEXT_MSG_NOTIMPLEMENTED);
#endif
  }

  /* Now the /P option can be processed */
  if (!canexit)
  {
		showinfo = 0;
		short_version();

		if (exist(autoexec))
		{
			printf("\nPress F8 for trace mode, or F5 to bypass %s... ", autoexec);
			key = WaitForFkeys();
			putchar('\n');

			if (key == KEY_F8)
			{
				tracemode = 1;
			}

			if (key == KEY_F5)
			{
				printf("Bypassing %s\n", autoexec);
			}
			else
			{
//        strcpy(commandline, autoexec);
        process_input(1, autoexec);
      }
		}
		else
		{
			printf("%s not found.\n", autoexec);
#ifdef INCLUDE_CMD_DATE
			cmd_date(NULL);
#endif
#ifdef INCLUDE_CMD_TIME
			cmd_time(NULL);
#endif
		}
	}

	/* Now the /C or /K option can be processed */
	if (spawnCmd)
	{
		if (h)
		{                           /* left-over from the "/C" option */
			q = stpcpy(buf, h);
		}
		else
		{
			q = buf;
			*buf = '\0';              // remove on errors -- ska
		}
		while ((p = *++argv) != NULL)
		{
			*q = ' ';
			q = stpcpy(q + 1, p);
		}

//    strcpy(commandline, buf);   // otherwise 'h' see above -- ska
    process_input(1, buf);

    if (spawnCmd != 'K')
      return 2;
	}

	if (showinfo)
	{
		short_version();
		putchar('\n');
		showcmds(NULL);
		putchar('\n');
	}
  dprintf(("%ld bytes available.\n\n", farcoreleft()));

	printf("[End of initialize]\n");

	return 0;
}
