/*
 * VER.C
 *
 *  06/30/98 (Rob Lake)
 *      rewrote ver command to accept switches, now ver alone prints
 *      copyright notice only.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 30-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added text about where to send bug reports and get updates.
 *
 * 13-Sep-1998 (John P Price <linux-guru@gcfl.net>)
 * - change /r to print info. /d shows redistribution info now.
 *
 * 30-Jan-1999 (John P Price <linux-guru@gcfl.net>)
 * - changed /r to show FreeDOS kernel version
 *
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "command.h"
#include "strings.h"

char *shellver = "version 0.76 [" __DATE__ "]";
char *shellname = "FreeDOS Command Shell";

void short_version(void)
{
	printf("\n%s %s\n", shellname, shellver);
}

#ifdef INCLUDE_CMD_VER

/*
 *  display shell version info internal command.
 *
 *
 */
#pragma argsused
int cmd_ver(char *rest)
{
	int i;

	/* JPP 07/08/1998 clean up and shortened info. */

	short_version();

	/* Basic copyright notice */
	if (rest[0] == 0)
	{
		display_string(TEXT_MSG_VER_COPYRIGHT);
		display_string(TEXT_MSG_VER_BASIC);
	}
  else
  {
    for (i = 0; rest[i]; i++)
    {
      /* skip spaces */
			if (rest[i] == ' ')
        continue;
      if (rest[i] == '/')
      {
        /* is this a lone '/' ? */
        if (rest[i + 1] == 0)
        {
          error_invalid_switch(' ');
          return 1;
        }
        continue;
      }
			if (toupper(rest[i]) == 'R')
			{                         /* version information */
				union REGS regs;
				regs.h.ah = 0x30;
				intdos(&regs, &regs);
				printf("DOS version %u.%u\n", regs.h.al,regs.h.ah);

				if (regs.h.bh == 0xfd)
				{
					if (regs.h.bl == 0xff)
					{
						printf("FreeDOS kernel (build 1933 or prior)\n",
								 regs.h.ch,regs.h.cl,regs.h.bl);
					}
					else
					{
						printf("FreeDOS kernel version %d.%d.%d\n",
								 regs.h.ch,regs.h.cl,regs.h.bl);
					}
				}
			}
			else if (toupper(rest[i]) == 'W')
			{                         /* Warranty notice */
				display_string(TEXT_MSG_VER_COPYRIGHT);
				display_string(TEXT_MSG_VER_WARRANTY);
			}
			else if (toupper(rest[i]) == 'D')
			{                         /* Redistribution notice */
				display_string(TEXT_MSG_VER_COPYRIGHT);
				display_string(TEXT_MSG_VER_REDISTRIBUTION);
			}
      else if (toupper(rest[i]) == 'C')
      {                         /* Developer listing */
				display_string(TEXT_MSG_VER_COPYRIGHT);
        display_string(TEXT_MSG_VER_DEVELOPERS);
      }
      else
      {
        error_invalid_switch(toupper(rest[i]));
        return 1;
      }

    }
  }
  return 0;
}

#endif
