/*
 *  TIME.C - time internal command
 *
 *  Comments:
 *
 *  07/08/1998 (John P. Price)
 *    started.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_TIME

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

#include "command.h"
#include "timefunc.h"
#include "strings.h"

int parsetime(char *s)
{
  struct dostime_t t;

  if (!*s)
    return 1;

  t.hour = 0;
  t.minute = 0;
  t.second = 0;
  t.hsecond = 0;

  // first get hour
  if (isdigit(*s))
  {
    while (isdigit(*s))
      t.hour = t.hour * 10 + (*s++) - '0';
  }
  else
    return 0;

  // get colon
  if (*s == ':')
  {
    s++;

    // now get minutes
    if (isdigit(*s))
    {
      while (isdigit(*s))
        t.minute = t.minute * 10 + (*s++) - '0';

      // get colon
      if (*s == ':')
      {
        s++;

        // now get seconds
        if (isdigit(*s))
        {
          while (isdigit(*s))
            t.second = t.second * 10 + (*s++) - '0';

          // get period
          if (*s == '.')
          {
            s++;

            // now get hundreths
            if (isdigit(*s))
            {
              while (isdigit(*s))
                t.hsecond = t.hsecond * 10 + (*s++) - '0';
            }
          }
        }
      }
    }
  }

  if (toupper(*s) == 'P')
  {
    t.hour += 12;
  }

  if ((toupper(*s) == 'A') && (t.hour == 12))
  {
    t.hour = 0;
  }

  if (t.hour > 23 || t.minute > 60 || t.second > 60 || t.hsecond > 99)
    return 0;

  _dos_settime(&t);
  return 1;
}

#pragma argsused
int cmd_time(char *rest)
{
  struct dostime_t t;
  char ampm;
  char s[40];

  if (!*rest)
  {
    _dos_gettime(&t);

    if (t.hour > 12)
    {
      ampm = 'p';
      t.hour -= 12;
    }
    else
      ampm = 'a';

    if (t.hour == 0)
      t.hour += 12;

    display_string(TEXT_MSG_CURRENT_TIME, t.hour, t.minute,
                   t.second, t.hsecond, ampm);
  }

  while (1)
  {
    if (!(rest && *rest))
    {
      printf("Enter new time: ");
      fgets(s, sizeof(s), stdin);
      while (*s && s[strlen(s) - 1] < ' ')
        s[strlen(s) - 1] = '\0';
      if (parsetime(s))
        return 0;
    }
    else
    {
      if (parsetime(rest))
        return 0;
      // force input the next time around.
      *rest = '\0';
    }
    display_string(TEXT_ERROR_INVALID_TIME);
  }
}

#endif

#ifdef DEBUG_STANDALONE
int main(void)
{
  cmd_time("time", "");
  return 1;
}
#endif
