/*
 *  DEL.C - del command.
 *
 *  Comments:
 *
 *  06/29/98 (Rob Lake rlake@cs.mun.ca)
 *      rewrote del to support wildcards
 *      added my name to the contributors
 *
 * 07/13/98 (Rob Lake)
 *  - fixed bug that caused del not to delete file with out attribute.
 *  - moved set, del, ren, and ver to there own files
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 09-Aug-1998 (Rob Lake <rlake@cs.mun.ca>)
 * - changed check for ^C
 * - alloced mem for char **arg
 *
 * 10-Aug-1998 ska
 * - fixed allocation of char **arg incl. out-of-memory check
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_DEL

#include <dir.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <direct.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>

#include <dfn.h>
#include <dynstr.h>

#include "command.h"
#include "strings.h"

/*

 *  simple file delete internal command.
 *  Rewritten by Rob Lake (06/29/98)
 *
 */

/* Visible cgetchar() that does not advance the cursor */
int vcgetchar(void)
{
  int ch;

  ch = cgetchar();
  if (isprint(ch))
  {
    putchar(ch);
    putchar('\b');
    fflush(stdout);
  }
  else
    beep();

  return ch;
}

#pragma argsused
int cmd_del(char *rest)
{
  int args;
  int inter;
  int filespec;

  struct ffblk f;
  struct stat stbuf;

  /* Make fullname somewhat larger to ensure that appending
     a matched name, one backslash and one hope. */
  char fullname[MAXPATH + sizeof(f.ff_name) + 2],
   *p;
  int len;

  char **arg;

  arg = split(rest, &args);
  inter = 0;
  filespec = 0;

  if (args > 2)
  {
    error_too_many_parameters(arg[args - 1]);
    freep(arg);
    return 1;
  }
  else if (args >= 1)
  {
    if (stricmp(arg[1], "/p") == 0)
    {
      inter = 1;
      filespec = 0;
    }
    else if (stricmp(arg[0], "/p") == 0)
    {
      filespec = 1;
      inter = 1;
    }
    /* only one argument and that's /P */
    if (args == 1 && inter)
    {
      error_req_param_missing();
      freep(arg);
      return 1;
    }

    /* Get the pattern fully-qualified */
    /* Note: An absolute path always contains:
       A:\\
       --> It's always three bytes long at minimum
       and always contains a backslash */
    p = dfnexpand(arg[filespec], NULL);
    freep(arg);
    if ((len = strlen(p)) >= MAXPATH)
    {
      error_filename_too_long(p);
      free(p);
      return 1;
    }
    strcpy(fullname, p);        /* Operating over a local buffer simplifies
                                   the process; rather than keep the pattern
                                   within dynamic memory - 1998/08/12 ska */
    free(p);
    p = fullname + len;

    /* check if it is a directory */
    if (stat(fullname, &stbuf) == 0	/* exists */
        && (stbuf.st_mode & S_IFMT) == S_IFDIR	/* is directory */
    /* Under DOS everything seems to be possible, even to
       successfully stat() "C:\\TEMP\\*.*" ?!
       At least with some compilers.
       - 1998/10/27 ska */
        && strpbrk(fullname, "?*") == NULL)	/* no wildcards */
    {
      if (p[-1] != '\\')
        *p++ = '\\';
    }

    if (p[-1] == '\\')
      p = stpcpy(p, "*.*");

  }
  else
  {
    /* only command given */
    error_req_param_missing();
    freep(arg);
    return 1;
  }

  /* p := address to copy the filename to to form the fully-qualified
     filename */
  /* There is at least one backslash within fullname, because of dfnexpand() */
  while (*--p != '\\') ;
  ++p;

  /* make sure user is sure if all files are to be
   * deleted */
  if (strcmp(p, "*.*") == 0 && !inter)
  {
    int ch,
      yes;

    display_string(TEXT_MSG_DELETE_ALL);
    fflush(stdout);             /* to be absolutely sure - 1998/08/12 ska */
    yes = 0;
    while (yes != 'Y' && yes != 'N' && (ch = vcgetchar()) != '\n' && ch != '\r'
           && !chkCBreak(BREAK_INPUT))
    {
      yes = toupper(ch);
    }
    putchar('\n');
    if (yes != 'Y')
    {
      return 1;
    }
  }

  if (FINDFIRST(fullname, &f, FA_ARCH))
  {

    error_sfile_not_found(fullname);
    return 1;
  }

  do
  {
    strcpy(p, f.ff_name);       /* Make the full path */

    if (inter)
    {
      int c;
      do
      {
        printf("%s, Delete(Y/N)?", fullname);
        fflush(stdout);
        c = toupper(vcgetchar());
        putchar('\n');
        if (chkCBreak(BREAK_INPUT))
        {
          return 1;
        }
      }
      while (c != 'Y' && c != 'N');
      if (c != 'Y')             /* don't delete */
        continue;
    }

    if (cbreak)
      return 1;

#ifdef NODEL
/* define NODEL if you want to debug */
    puts(fullname);
#else
    if (unlink(fullname) != 0)
    {
      perror(fullname);
      /* return 1;                                                            -- just notify the user - 1998/08/12 ska */
    }
#endif

  }
  while (FINDNEXT(&f) == 0);

  return 0;
}

#endif
