/*
 *  BATCH.C - batch file processor for COMMAND.COM.
 *
 *
 *
 *  Comments:
 *
 *  ??/??/?? (Evan Jeffrey) -------------------------------------------------
 *    started.
 *  
 *  07/15/95 (Tim Norman) ---------------------------------------------------
 *    modes and bugfixes.
 *
 *  08/08/95 (Matt Rains) ---------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *    i have added some constants to help making changes easier.
 *
 *  01/29/96 (Steffan Kaiser) -----------------------------------------------
 *    made a few cosmetic changes
 *
 *  02/05/96 (Tim Norman) ---------------------------------------------------
 *    changed to comply with new first/rest calling scheme
 *
 *  06/14/97 (Steffen Kaiser) -----------------------------------------------
 *    bug fixes.  added error level expansion %?.  ctrl-break handling
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>

#include "command.h"

#define D_LABELERR   "ERROR: label not found!"
#define D_SYNTAXERR  "ERROR: syntax error!"
#define D_PAUSEMSG   "[press any key to continue]"
#define D_BEEP       "beep"
#define D_CALL       "call"
#define D_DOWN       "down"
#define D_ECHO       "echo"
#define D_ERRORLEVEL "errorlevel"
#define D_EXIST      "exist"
#define D_GOTO       "goto"
#define D_IF         "if"
#define D_NOT        "not"
#define D_ON         "on"
#define D_OFF        "off"
#define D_PAUSE      "pause"
#define D_REM        "rem"
#define D_SHIFT      "shift"

/* function decls */
void split (char *, char **);
char *parse_firstarg (char *);
void printprompt (void);

/*
 * append src to dest, but don't reach endDest.
 * return NULL, if failure;
 * return one byte behind the last copied byte, otherwise
*/
char *appendString(char *dest, char *src, char *endDest)
{
   size_t len;

   if(!src) return dest;

   len = strlen(src);
   if(dest + len >= endDest) return NULL;

   return stpcpy(dest, src);
}

/*
 * process a batch file
 *
 *
 */
int batch(char *firstword, char *restofline)
{
   FILE *bfile;

   int argc;             /* argc for call to this batch file */
   char *argv[128];      /* argv not including name of batch file */

   char *first, *rest;   /* first and rest of read-in line */

   int realnum;          /* the actual number of the parameter we want */
   char *var;            /* pointer to env. var. value */
   char *tmp;            /* temporary string pointer */

   static int nestlevel = 0;
   static int called;
   static int echo = 1;
   int shiftlevel = 0;   /* number of times we've shifted the parameters */
   char textline[128];
   char cmdline[128];

   /* varibles found within code */
   int notval;
   int found;

   nestlevel++; /* keep track of how many batch files are running */

   /* open the batch file */
   if((bfile = fopen(firstword, "rt")) == NULL)
   {
      return(1);
   }

   /* split our command-line params */
   split (restofline, argv+1);
   argv[0] = firstword;
   for (argc = 0; argv[++argc]; )
      ;

   /* set the called flag to 1.  This indicates that a batch file has been */
   /* run.  Used for determining what to do when a batch file is called */
   /* from within another batch file */
   called = 1;

   /* cycle through each line of the batch file */
   while(fgets(textline, sizeof (textline), bfile) != NULL)
   {
      /* copy textline[] -> cmdline[] and */
      /* 1) expand the variables */
      /* 2) replace control codes by spaces */
      char *p, *q;

      /* check for ctrl-break */
      if (chkCBreak (BREAK_BATCHFILE))
	 break;

      if (!strchr (textline, '\n'))
	 p = NULL;
      else
      {
	 for (q = textline; isspace (*q); q++)
	    ;

	 /* ignore labels and empty lines */
	 if (*q == ':' || *q == '\n' || *q == 0)
	    continue;

	 for (p = cmdline; p && (*p = *q++) != 0; )
	 {
	    if (*p == '%')
	    {
	       if (isdigit (*q))      /* argument */
	       {
		  realnum = *q - '0' + shiftlevel;
		  if ((unsigned)realnum <= argc)
		     p = appendString (p, argv[realnum], cmdline + sizeof (cmdline));
		  ++q;
	       }
	       else if (*q == '?')    /* non-standard: error level */
	       {
		  char buf[4];

		  ++q;
		  sprintf (buf, "%u", errorlevel);
		  p = appendString (p, buf, cmdline + sizeof (cmdline));
	       }
	       else                   /* possibly a variable */
	       {
		  char *endvar;

		  if ((endvar = strchr (q, '%')) != NULL)
		  {
		     *endvar = 0;
		     if ((var = getenv (q)) == NULL)
			var = getenv (strupr (q));
		     p = appendString (p, var, cmdline + sizeof (cmdline));
		     q = endvar + 1;
		  }
	       }
	    }
	    else
	    {
	       if (iscntrl (*p))
		  *p = ' ';
	       if ((unsigned)++p >= (unsigned)(cmdline + sizeof (cmdline)))
		  p = NULL;
	    }
	 }
      }

      if (!p)
      {
	 fputs ("Command line too long.\n", stderr);
	 printf ("%s\n%s\n", cmdline, textline);
	 fclose (bfile);
	 --nestlevel;
	 return -1;
      }

      /* strip trailing spaces */
      while (--p >= cmdline && isspace (*p))
	 ;
      p[1] = 0;

      /* ignore empty lines */
      if (!*cmdline)
	 continue;

      /* make a copy that we can use to pass to parsecommandline if nothing */
      /* else matches */
      strcpy (textline, first = cmdline);

      /* check for non-echo character */
      if (*first == '@')
      {
	 first++;
	 while (isspace (*first))
	    first++;
      }
      else if (echo)
      {
	 printprompt ();
	 puts (cmdline);
      }

      /* find the rest of the line and delimit the first word */
      rest = parse_firstarg (first);
      /* POST condition: rest may be NULL */

      /* check for SHIFT instruction */
      if(strcmpi (first, D_SHIFT) == 0)
      {
	 /* check if we are shifting down rather than up */
	 if(rest && strncmpi(rest, D_DOWN, sizeof (D_DOWN)) == 0)
	    /* only shift down if shiftlevel != 0 */
	    shiftlevel = shiftlevel ? shiftlevel - 1 : 0;
	 else
	    /* shift up */
	    shiftlevel++;
      }
      /* check for PAUSE instruction */
      else if(strcmpi(first, D_PAUSE) == 0)
      {
	 puts(D_PAUSEMSG);
	 cgetchar();
      }
      /* check for ECHO instruction */
      else if(strcmpi(first, D_ECHO) == 0)
      {
	 if (rest)
	 {
	    if(stricmp(rest, D_OFF) == 0)
	       echo = 0;
	    else if(stricmp(rest, D_ON) == 0)
	       echo = 1;
	    else if (!rest)
	       printf ("ECHO is %s\n", echo ? D_ON : D_OFF);
	    else
	       puts(rest);
	 }
      }
      /* check for GOTO instruction */
      else if(strcmpi(first, D_GOTO) == 0)
      {
	 if (!rest || !*rest)
	 {
	    fprintf (stderr, "No label specified for GOTO\n");
	    fclose (bfile);
	    nestlevel --;
	    return 1;
	 }

	 /* extract the label that we're going to */
	 parse_firstarg (rest);

	 /* now search for the label */
	 rewind(bfile);

	 found = 0;

	 while (fgets (textline, sizeof (textline), bfile) != NULL)
	 {
	    tmp = textline;

	    while (isspace (*tmp))
	       tmp++;

	    if (*tmp == ':')
	    {
	       tmp++;

	       parse_firstarg (tmp);

	       if (strcmp (tmp, rest) == 0)
	       {
		  found = 1;
		  break;
	       }
	    }
	 }

	 if(!found)
	 {
	    printf ("Label not found: %s\n", rest);
	    fclose (bfile);
	    nestlevel --;
	    return(1);
	 }
      }
      /* check for IF command */
      else if(strcmpi(first, D_IF) == 0)
      {
	 puts ("IF not implemented yet");

#if 0
	 if(strcmpi(p[1], D_NOT) == 0)
	 {
	    notval++;
	 }
	 if(!strcmpi(p[1 + notval], D_ERRORLEVEL))
	 {
	    ;
	 }
	 else if(!strcmpi(p[1 + notval], D_EXIST))
	 {
	    ;
	 }
	 else
	 {
	    ;
	 }
#endif
      }
      /* check for BEEP command */
      else if(strcmpi(first, D_BEEP) == 0)
      {
	 printf("\a");
      }
      /* check for CALL command */
      else if(strcmpi(first, D_CALL) == 0)
      {
	 parsecommandline(rest);
      }
      else
      {
	 char *place;

	 /* clear the call flag */
	 called = 0;

	 /* strip \n and \r before calling parsecommandline */
	 place = &textline[strlen (textline) - 1];
	 while ((*place == '\n' || *place == '\r') && place > textline)
	    *place-- = 0;
	 parsecommandline(textline);

	 /* if a batch file was called, then return */
	 if(called)
	 {
	    fclose (bfile);
	    nestlevel --;
	    return(0);
	 }

	 /* set the call flag back */
	 called = 1;
      }
   }

   /* close the file and decrease the nesting level */
   fclose(bfile);
   nestlevel--;

   if(nestlevel == 0)
   {
      /* reset the echo when the main calling batch file quits */
      echo = 1;
      chkCBreak (BREAK_OUTOFBATCH);
   }

   return(0);
}
