/*
 *  IF.C - if command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>

#include "command.h"
#include "cmdline.h"
#include "batch.h"

#pragma argsused
int cmd_if(char *rest)
{
/*
 * Perform IF command.
 *
 */

#define X_EXEC 1
#define X_EMPTY 0x80

  int x_flag = 0;               /* when set cause 'then' clause to be exec'ed */

  char *pp;

  /* First check if rest string begins with word 'not' */
  assert(rest);

  if (matchtok(rest, "not"))
  {
    x_flag = X_EXEC;            /* Remember 'NOT' */
  }

  /* Check for 'exist' form */

  if (matchtok(rest, "exit"))
  {
    pp = rest;
    while (*pp && !isspace(*pp))
      pp++;

    if (*pp)
    {
      struct ffblk f;

      *pp++ = '\0';

      x_flag ^= FINDFIRST(rest, &f, FA_NORMAL) ? 0 : X_EXEC;
    }
    else
      return 0;
  }

  /* Check for 'errorlevel' form */

  else if (matchtok(rest, "errorlevel"))
  {
    int
      n = 0;

    while (isdigit(*pp))
      n = n * 10 + (*pp++ - '0');

    x_flag ^= (errorlevel < n) ? 0 : X_EXEC;

    x_flag |= X_EMPTY;          /* Syntax error if comd empty */
  }

  /* Check that '==' is present, syntax error if not */

  else if (NULL == (pp = strstr(rest, "==")))
  {
    error_syntax(NULL);
    return 1;
  }

  else
  {
    /* Change first '='to space to terminate comparison loop */

    *pp = ' ';                  /* Need a space to terminate comparison loop */

    pp = ltrim(pp + 2);         /* over '==' and subsquent spaces */

    strcat(pp, " ");            /* Add one space to ensure comparison ends */

    while (*rest == *pp)       /* Comparison loop */
    {
      if (isspace(*rest))      /* Terminates on space */
        break;

      rest++, pp++;
    }

    if (x_flag ^= (*rest != *pp) ? 0 : X_EXEC)
    {
      while (*pp && !isspace(*pp))      /* Find first space, */
        pp++;

      x_flag |= X_EMPTY;
    }
  }

  if (x_flag & X_EMPTY)
  {
  	pp = ltrim(pp);

    if (*pp == '\0')            /* If nothing left then syntax err */
    {
      error_syntax(NULL);
      return 1;
    }
  }

  if (x_flag & X_EXEC)
    parsecommandline(pp);

  return 0;
}
