/*
 * SET.C
 *
 */

#include "command.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

/*
 * set environment variables
 *
 *
 */
#pragma argsused
int
set(char *first, char *rest)
{
  unsigned char count;          /* counter */
  char *env_temp;               /* temporary copy for putenv */

  /* if no parameters, show the environment */
  if (rest[0] == 0)
  {
    /* JPP 07/08/1998 removed call to show_environment */
    for (count = 0; environ[count]; count++)
    {
      puts(environ[count]);
    }
    return 0;
  }

  /* make sure there is an = in the command */
  /* JPP 07/08/1998 moved test for syntax before allocating memory */
  if (strchr(rest, '=') == NULL)
  {
    puts("Syntax error");
    return 1;
  }

  if ((env_temp = strdup(rest)) == NULL)
  {
    puts("Memory error");
    return 1;
  }

  /* capitalize name of env. var. */
  for (count = 0; env_temp[count] && env_temp[count] != '='; count++)
  {
    env_temp[count] = toupper(env_temp[count]);
  }

  if (putenv(env_temp) < 0)
  {
    puts("Environment error");
  }

  return 0;
}
