/*
 * REN.C
 */

#include "command.h"
#include <stdio.h>

/*
 *
 *  simple file rename internal command.
 *
 */
#pragma argsused
int
ren(char *first, char *rest)
{
  char *arg[2];

  /* set the first argument */
  arg[0] = rest;

  /* split off the first argument and get the second argument start */
  arg[1] = parse_firstarg(rest);

  /* check if there are the wrong number of arguments */
  if (!arg[0][0] || !arg[1] || parse_firstarg(arg[1]) != NULL)
  {
    printf("%s\n", BADCMDLINE);
    printf("%s: %s\n", USAGE, REN_HELP);
    return 1;
  }
  else if (rename(arg[0], arg[1]) != 0)
  {
    perror("ren()");
    return 1;
  }

  return 0;
}
