/* COMMAND.H
 * header file for the modules in COMMAND.COM
 * Tim Norman
 * 7-15-95
 *
 * 06/29/98 (Rob Lake)
 *      - Moved error messages in here
 *
 * 07/12/98 (Rob Lake)
 *  - Moved more error message here
 *
 */

#define EnvSeg (*(unsigned far*)MK_FP(_psp, 0x2c))
#define OwnerPSP (*(unsigned far *)MK_FP(_psp, 0x16))

#define BREAK_BATCHFILE 1
#define BREAK_OUTOFBATCH 2
#define BREAK_INPUT 3
#define BREAK_IGNORE 4

/* define some error messages */
#define SYNTAXERR       "Syntax error"
#define NOENVERR        "ERROR: no environment"
#define INVALIDDRIVE    "ERROR: invalid drive"
#define INVALIDFUNCTION "ERROR: invalid function"
#define BADCOMMAND      "Bad command or filename"
#define ACCESSDENIED    "ERROR: access denied"
#define NOTENOUGHMEMORY "ERROR: not enough memory"
#define BADENVIROMENT   "ERROR: bad enviroment"
#define BADFORMAT       "ERROR: bad format"
#define ERROR_E2BIG     "ERROR: Argument list too long"
#define ERROR_EINVAL    "ERROR: Invalid argument"

#define CANNOTPIPE      "Error!  Cannot pipe!  Cannot open temporary file!\n"

#define TOO_MANY_PARAMETERS "Too many parameters - %s\n"
#define INVALID_SWITCH "Invalid switch - /%c\n"
#define PATH_NOT_FOUND "Path not found\n"
#define FILE_NOT_FOUND "File not found"
#define REQ_PARAM_MISSING "Required parameter missing\n"
#define INVALID_DRIVE "Invalid drive specification\n"

#define SHELLINFO    "FreeDOS Command Line Interface"
#define SHELLVER     "version 0.74d"
#define BADCMDLINE   "bad or incorrect command line"
#define USAGE        "usage"
#define CD_HELP      "change to directory   CD [d:][path]"
#define MD_HELP      "make directory   MD [d:]path"
#define RD_HELP      "remove directory   RD [d:]path"
#define DIR_HELP     "display directory listing   DIR [d:][path][filespec]"
#define VER_HELP     "display shell version info   VER [/C/R/W/?]"
#define DEL_HELP     "delete file   DEL [d:][path]filespec"
#define REN_HELP     "rename file   REN [d:][path]filespec1 [d:][path]filespec2"
#define SET_HELP     "SET"
#define PROMPTEQUAL  "PROMPT="
#define PATHEQUAL    "PATH="

enum
{
  FALSE, TRUE
};

/* prototypes for COMMAND.C */
extern int ctrlBreak;
extern int exitflag;
extern int errorlevel;
extern unsigned far *maxx;
extern unsigned char far *maxy;

void fatal_error(char *);
char is_delim(char);
void execute(char *, char *);
void command(char *);
void parsecommandline(char *);
int process_input(void);
int c_brk(void);
void initialize(int, char *[]);

/* prototypes for INTERNAL.C */
int dir(char *, char *);
int cd(char *, char *);
int md(char *, char *);
int rd(char *, char *);
int set(char *, char *);
int ver(char *, char *);
int del(char *, char *);
int ren(char *, char *);
int internal_exit(char *, char *);
int rem(char *, char *);
int doskey(char *, char *);
int prompt(char *, char *);
int path(char *, char *);
int cmd_date(char *, char *);   /*JPP 07/08/1998 */
int cmd_time(char *, char *);   /*JPP 07/08/1998 */
int cmd_type(char *, char *);   /*JPP 07/08/1998 */

/* prototypes for ENVIRON.C */
void show_environment(void);

/* prototypes from PROMPT.C */
void printprompt(void);

/* prototypes for CMDINPUT.C */
void readcommand(char *, int);

/* prototypes for BATCH.C */
int batch(char *, char *);
int _getch(void);

/* prototypes for WHERE.C */
void get_paths(char *[129]);
int find_which(char *[129], char *, char *);

/* prototypes for EXEC.C */
int exec(const char *, char *, const unsigned);

/* prototypes for REDIR.C */
void get_redirection(char *, char *, char *, char *[128], int *);

/* prototypes for LOADHIGH.C */
int loadhigh(char *, char *);
int loadfix(char *, char *);

/* prototypes for ALIAS.C */
void aliasexpand(char *, int);
int aliasswapout(void);
int aliasswapin(void);
int alias(char *, char *);

/* Prototypes for ERR_HAND.C */
void init_error_handler(void);
void printstring(char *);
char *get_err(unsigned);
void interrupt far dos_critical_error(unsigned, unsigned, unsigned, unsigned,
                          unsigned, unsigned, unsigned, unsigned, unsigned);

/* Prototypes for MISC.C */
int exist(char *);
int chkCBreak(int);
int cgetchar(void);
int split(char *, char **);
char *parse_firstarg(char *);

/* Prototypes for ERROR.C */
void no_pipe(void);
void badcommand(void);
void invalid_drive(void);
void req_param_missing(void);
void sfile_not_found(char *);
void file_not_found(void);
void path_not_found(void);
void too_many_parameters(char *);
void invalid_switch(char);
