/*
 *  TEMPFILE.C - tempfile() creates a unique temporary file
 *
 *
 *
 *  Comments:
 *
 *  02/02/1996 (Oliver Mueller) --------------------------------------------
 *    started. There is a problem with the tmpfile() routine of Borland so
 *    I have implemented it new.
 *
 */

#include <dir.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "tempfile.h"

static char tb[MAXPATH];

void
rmtmpfile(void)
{
  remove(tb);
}

FILE *
tempfile()
{
  char *tmp;

  tmp = tempnam(getenv("TEMP"), "ALIAS");
  if (!tmp)
  {
    errno = ENMFILE;
    return 0;
  }
  strcpy(tb, tmp);

  return fopen(tmp, "w+b");
}
