/*
 *  REDIR.C
 *
 *
 *
 *  Comments:
 *
 *  12/15/95 (Tim Norman) ---------------------------------------------------
 *    started.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

int
is_redir(char c)
{
  return c == '<' || c == '>' || c == '|';
}

/* gets the redirection from the command line and chops it out of the */
/* command line                                                       */
void
get_redirection(char *s, char *in, char *out, char *pipe[128], int *num)
{
  int count, start, inquote = 0, numpipes = 0;

  /* find and remove all the redirections first */
  for (count = 0; s[count]; count++)
    if (s[count] == '"')
      inquote = !inquote;
    else if (!inquote && (s[count] == '<' || s[count] == '>'))
    {
      /* MS-DOS ignores multiple redirection symbols and uses the last */
      /* redirection, so we'll emulate that and not check */

      /* find the next word */
      start = count;
      count++;

      /* skip over whitespace */
      while (isspace(s[count]))
        count++;

      /* skip until we hit whitespace or a delimiter of some sort */
      while (!is_redir(s[count]) && s[count] && !isspace(s[count]))
        count++;

      if (s[start] == '<')
      {
        memcpy(in, &s[start + 1], count - start - 1);
        in[count - start - 1] = 0;
      }
      else if (s[start] == '>')
      {
        memcpy(out, &s[start + 1], count - start - 1);
        out[count - start - 1] = 0;
      }

      memmove(&s[start], &s[count], strlen(&s[count]) + 1);

      /* move back one so we can check this character */
      count = start - 1;
    }

  /* now go after the pipes */

  pipe[numpipes++] = s;

  for (count = 0; s[count]; count++)
    if (s[count] == '"')
      inquote = !inquote;
    else if (!inquote && s[count] == '|')
    {
      s[count] = 0;

      pipe[numpipes++] = &s[count + 1];
    }

  pipe[numpipes] = NULL;

  *num = numpipes;
}
