/*
 *  CMDINPUT.C - handles command input (tab completion, history, etc.)
 *
 *
 *
 *  Comments:
 *
 *  01/14/95 (Tim Norman) -------------------------------------------------
 *    started.
 *
 *  08/08/95 (Matt Rains) -------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *    i have added some constants to help making changes easier.
 *
 *  12/12/95 (Tim Norman) -------------------------------------------------
 *    added findxy() function to get max x/y coordinates to display
 *    correctly on larger screens
 *
 *  12/14/95 (Tim Norman) -------------------------------------------------
 *    fixed the Tab completion code that Matt Rains broke by moving local
 *    variables to a more global scope and forgetting to initialize them
 *    when needed
 *
 *  8/1/96 (Tim Norman) ---------------------------------------------------
 *    fixed a bug in tab completion that caused filenames at the beginning
 *    of the command-line to have their first letter truncated
 *
 *  9/1/96 (Tim Norman) ---------------------------------------------------
 *    fixed a silly bug using printf instead of fputs, where typing "%i"
 *    confused printf :)
 *
 *  6/14/97 (Steffan Kaiser) ----------------------------------------------
 *    ctrl-break checking
 *
 *  6/7/97 (Marc Desrochers) ----------------------------------------------
 *    recoded everything! now properly adjusts when text font is changed.
 *    removed findxy(), reposition(), and reprint(), as these functions
 *    were inefficient. added goxy() function as gotoxy() was buggy when the
 *    screen font was changed. the printf() problem with %i on the command
 *    line was fixed by doing printf("%s",str) instead of printf(str).
 *    don't ask how I find em just be glad I do :)
 *
 *  7/12/97 (Tim Norman) --------------------------------------------------
 *    Note: above changes pre-empted Steffan's ctrl-break checking.
 *
 *  7/7/97 (Marc Desrochers) ----------------------------------------------
 *    rewrote a new findxy() because the new dir() used it.  This findxy()
 *    simply returns the values of *maxx *maxy.  In the future, please use
 *    the pointers, they will always be correct since they point to BIOS
 *    values.
 *
 *  7/8/97 (Marc Desrochers) ----------------------------------------------
 *    once again removed findxy(), moved the *maxx, *maxy pointers global
 *    and included them as externs in command.h.  Also added insert/overstrike
 *    capability
 *
 *  7/13/97 (Tim Norman) --------------------------------------------------
 *    added different cursor appearance for insert/overstrike mode
 *
 *  7/13/97 (Tim Norman) --------------------------------------------------
 *    changed my code to use _setcursortype until I can figure out why
 *    my code is crashing on some machines.  It doesn't crash on mine :)
 *
 */

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <conio.h>
#include "command.h"

#define D_BS      8
#define D_DELETE  256+83
#define D_INSERT  256+82
#define D_TAB     9
#define D_HOME    256+71
#define D_END     256+79
#define D_UP      256+72
#define D_DOWN    256+80
#define D_LEFT    256+75
#define D_RIGHT   256+77
#define D_ENTER   13
#define D_ESC     27
#define D_BEEP    printf("\a")

void history(int, char *);      /* prototype for the command-line history */

/*
 * maxx, maxy
 *
 * pointers into BIOS for the size of the screen
 */
unsigned far *maxx = (unsigned far *)0x0000044A;
unsigned char far *maxy = (unsigned char far *)0x00000484;

/*
 * There is a problem with this code.
 * If anyone knows why it crashes on some machines, plus let me
 * know!  (normat@rpi.edu)
 */
#if 0
/*
 * getmatrixheight
 *
 * return the height of the character matrix
 */
void
getmatrixheight(unsigned *mh)
{
  unsigned tmp;

  /*
   * save the BP register since that's used for the stack,
   * and this interrupt overwrites it
   */
  asm {
    mov si, bp
    mov ah, 11h
    mov al, 30h
    mov bh, 02h
    int 10h
    mov bp, si
    mov tmp,cx
  }

  *mh = tmp;
}

/*
 * setcursor
 *
 * set the starting and ending lines of the cursor
 */
void
setcursor(unsigned char start, unsigned char end)
{
  asm {
    mov ah, 01h
    mov ch, start
    mov cl, end
    int 10h
  }
}
#endif

/*
 * goxy
 *
 * move the cursor on the screen.  Needs to be in ASM because of bugs with
 * gotoxy()
 */
void
goxy(unsigned char x, unsigned char y)
{
  y--;
  x--;

  asm {
    mov ah, 2
    mov bh, 0
    mov dh, y
    mov dl, x
    int 10h
  }
}

/*
 * clrcmdline
 *
 *
 */
void
clrcmdline(char *str, int maxlen, unsigned orgx, unsigned orgy)
{
  int count;
  goxy(orgx, orgy);
  for (count = 0; count < strlen(str); count++)
    putchar(' ');
  memset(str, 0, maxlen);
  goxy(orgx, orgy);
}

/* read in a command line */
void
readcommand(char *str, int maxlen)
{
  struct ffblk file;

  // varibles found within code
  int found_dot = 0;
  int curplace = 0;
  int start;
  int perfectmatch = 1;
  char path[128];
  char fname[14];
  char maxmatch[13] = "";
  char directory[128];

  unsigned char insert = 0;
  unsigned ch;
  unsigned orgx;                // origin x/y

  unsigned orgy;
  unsigned curx;
  unsigned cury;
  int count;
  unsigned current = 0;
  unsigned charcount = 0;
  unsigned matrixheight;

  orgx = wherex();
  orgy = wherey();
  memset(str, 0, maxlen);

#if 0                           /* crashes on some machines */
  getmatrixheight(&matrixheight);
  setcursor(matrixheight * 6 / 7 - 1, matrixheight * 6 / 7);
#endif
  _setcursortype(_NORMALCURSOR);

  do
  {
    ch = getch();
    if (ch == 0)
      ch = 256 + getch();       // special key

    switch (ch)
    {
      case D_BS:               // delete character to left of cursor

        if (current > 0 && charcount > 0)
        {
          if (current == charcount)
          {
            str[current - 1] = 0;
            if (wherex() != 1)
              printf("\b \b");
            else
            {
              goxy(*maxx, wherey() - 1);
              putchar(' ');
              goxy(*maxx, wherey() - 1);
            }
          }
          else
          {
            for (count = current - 1; count < charcount; count++)
              str[count] = str[count + 1];
            if (wherex() != 1)
              goxy(wherex() - 1, wherey());
            else
              goxy(*maxx, wherey() - 1);
            curx = wherex();
            cury = wherey();
            printf("%s ", &str[current - 1]);
            goxy(curx, cury);
          }
          charcount--;
          current--;
        }
        break;
      case D_INSERT:           /* toggle insert/overstrike mode */
        insert ^= 1;
#if 0                           /* crashes on some machines */
        if (insert)
          setcursor(matrixheight / 2, matrixheight * 6 / 7);
        else
          setcursor(matrixheight * 6 / 7 - 1, matrixheight * 6 / 7);
#endif

        if (insert)
          _setcursortype(_SOLIDCURSOR);
        else
          _setcursortype(_NORMALCURSOR);

        break;
      case D_DELETE:           // delete character under cursor

        if (current != charcount && charcount > 0)
        {
          for (count = current; count < charcount; count++)
            str[count] = str[count + 1];
          charcount--;
          curx = wherex();
          cury = wherey();
          printf("%s ", &str[current]);
          goxy(curx, cury);
        }
        break;
      case D_HOME:             // goto beginning of string

        if (current != 0)
        {
          goxy(orgx, orgy);
          current = 0;
        }
        break;
      case D_END:              // goto end of string

        if (current != charcount)
        {
          goxy(orgx, orgy);
          printf("%s", str);
          current = charcount;
        }
        break;
      case D_TAB:
        maxmatch[0] = 0;
        found_dot = 0;
        curplace = 0;
        perfectmatch = 1;

        // expand current file name
        if (current == charcount) // only works at end of line

        {
          count = charcount - 1;
          if (count < 0)
            count = 0;

          while (count > 0 && str[count] != ' ')  // find front of word

            count--;

          if (str[count] == ' ')  // if not at beginning, go forward 1

            count++;

          start = count;

          // extract directory from word
          strcpy(directory, &str[start]);
          curplace = strlen(directory) - 1;
          while (curplace >= 0 && directory[curplace] != '\\' &&
                 directory[curplace] != ':')
          {
            directory[curplace] = 0;
            curplace--;
          }

          strcpy(path, &str[start]);

          // look for a . in the filename
          for (count = strlen(directory); path[count] != 0; count++)
            if (path[count] == '.')
            {
              found_dot = 1;
              break;
            }
          if (found_dot)
            strcat(path, "*");
          else
            strcat(path, "*.*");

          curplace = 0;         // current fname

          if (findfirst(path, &file, 0x3F) == 0)
          {                     // find anything

            do
            {
              if (file.ff_name[0] == '.') // ignore . and ..

                continue;

              strcpy(fname, file.ff_name);

              if (file.ff_attrib == FA_DIREC)
                strcat(fname, "\\");
              else
                strcat(fname, " ");

              if (!maxmatch[0] && perfectmatch)
                strcpy(maxmatch, fname);

              else
              {
                for (count = 0; maxmatch[count] && fname[count]; count++)
                  if (maxmatch[count] != fname[count])
                  {
                    perfectmatch = 0;
                    maxmatch[count] = 0;
                    break;
                  }
              }
            }
            while (findnext(&file) == 0);

            strcpy(&str[start], directory);
            strcat(&str[start], maxmatch);
            charcount = strlen(str);
            current = charcount;

            goxy(orgx, orgy);
            printf("%s", str);
            if ((strlen(str) > (*maxx - orgx)) && (orgy == *maxy + 1))
              orgy--;

            if (!perfectmatch)
              D_BEEP;
          }
          else
            D_BEEP;
        }
        else
          D_BEEP;
        break;
      case D_ENTER:            // end input, return to main

        if (str[0])
          history(0, str);      // add to the history

        putchar('\n');
        break;
      case D_ESC:              // clear str  Make this callable!

        clrcmdline(str, maxlen, orgx, orgy);
        current = charcount = 0;
        break;
      case D_UP:               // get previous command from buffer

        clrcmdline(str, maxlen, orgx, orgy);
        history(-1, str);
        current = charcount = strlen(str);
        printf("%s", str);
        break;
      case D_DOWN:             // get next command from buffer

        clrcmdline(str, maxlen, orgx, orgy);
        history(1, str);
        current = charcount = strlen(str);
        printf("%s", str);
        break;
      case D_LEFT:             // move cursor left

        if (current > 0)
        {
          current--;
          if (wherex() == 1)
            goxy(*maxx, wherey() - 1);
          else
            goxy(wherex() - 1, wherey());
        }
        else
          D_BEEP;
        break;
      case D_RIGHT:            // move cursor right

        if (current != charcount)
        {
          current++;
          if (wherex() == *maxx)
            goxy(1, wherey() + 1);
          else
            goxy(wherex() + 1, wherey());
        }
        break;
      default:                 // insert character into string...

        if ((ch >= 32 && ch <= 255) && (charcount != (maxlen - 2)))
        {
          if (insert && current != charcount)
          {
            for (count = charcount; count >= current; count--)
              str[count] = str[count - 1];
            str[current++] = ch;
            curx = wherex() + 1;
            cury = wherey();
            printf("%s", &str[current - 1]);
            if ((strlen(str) > (*maxx - orgx)) && (orgy == *maxy + 1))
              cury--;
            goxy(curx, cury);
            charcount++;
          }
          else
          {
            if (current == charcount)
              charcount++;
            str[current++] = ch;
            putchar(ch);
          }
          if ((strlen(str) > (*maxx - orgx)) && (orgy == *maxy + 1))
            orgy--;
        }
        else
          D_BEEP;
        break;
    }
  }
  while (ch != D_ENTER);

#if 0
  setcursor(matrixheight * 6 / 7 - 1, matrixheight * 6 / 7);
#endif
  _setcursortype(_NORMALCURSOR);
}
