/* Rephrase.cpp */

#include "Rephrase.h"
#include "pDisplay.h"
#include "PhraseDefs.h"

#include <interface/Alert.h>
#include <storage/Path.h>
#include <support/String.h>
#include <storage/Entry.h>
#include <storage/FilePanel.h>

#include <string.h>
#include <stdio.h>

Rephrase::Rephrase() :
	BApplication("application/x.vnd-BeDTS-Rephrase"),
	fOpen(NULL),
	fPhraseCount(0)
{
}


Rephrase::~Rephrase()
{
	delete fOpen; fOpen = NULL;
}

void 
Rephrase::ReadyToRun()
{
	// create a window to edit phrases if none exists
	if (fPhraseCount == 0)
	{
		fPhraseCount++;
		(new pDisplay)->Show();
	}
}

void 
Rephrase::AboutRequested()
{
	// display a simple about box
	BString aboutString;
	aboutString = "Rephrase ";
	aboutString << vMajor;
	aboutString += ".";
	aboutString << vMinor;
	if (vState != NULL)
	{
		aboutString += vState;
		aboutString << vNum;
	}	
	aboutString += "\nwritten by hippo\n\n";
	BAlert *about = new BAlert("About Rephrase", aboutString.String(), "Dismiss");
	about->Go(NULL);
}

void 
Rephrase::ArgvReceived(int32 argc, char **argv)
{
	// the first argument is the application name
	// the second and beyond are files to open
	BEntry entry;
	entry_ref ref;
	bool goodRef = false;
	BMessage msg(B_REFS_RECEIVED);
	for (int ix = 1; ix < argc; ix++)
	{
		// set the entry to the specified path
		entry.SetTo(argv[ix]);
		// if a file exists at that location,
		//get its entry ref and add it to the message
		if (entry.Exists())
		{
			entry.GetRef(&ref);
			if (msg.AddRef("refs", &ref) == B_OK)
				goodRef = true;
		}
	}
	// if we have at least one good ref in the message, pass it
	// to RefsReceived() for processing
	if (goodRef)
		RefsReceived(&msg);
}

void 
Rephrase::RefsReceived(BMessage *msg)
{
	printf("refs received time: %Ld\n", system_time());
	// find the number of refs in the message
	int32 count = 0;
	type_code type;
	status_t status = msg->GetInfo("refs", &type, &count);
	if (status != B_OK || type != B_REF_TYPE || count == 0)
		// there are no valid refs in this message
		return;
	
	// open a new phrase editing window for each ref
	entry_ref ref;
	for (int32 ix = 0; ix < count; ix++)
	{
		if (msg->FindRef("refs", ix, &ref) == B_OK)
		{
			fPhraseCount++;
			(new pDisplay(&ref))->Show();
		} 
	}
}

void 
Rephrase::MessageReceived(BMessage *msg)
{
	switch(msg->what)
	{
		case NEW_PHRASE:
		{
			fPhraseCount++;
			(new pDisplay)->Show();
			break;
		}
		case OPEN_PHRASE:
		{
			// create the file panel
			if (!fOpen)
			{
				fOpen = new BFilePanel;
				fOpen->Window()->SetTitle("Rephrase: Open");
			}
			// if it is hidden, increment the count
			if (!fOpen->IsShowing())
				fPhraseCount++;
			
			fOpen->Show();
			break;
		}
		case WINDOW_CLOSED:
		case B_CANCEL:
		{
			// a window we care about has closed
			// decrement the count and quit if there are no more
			fPhraseCount--;
			if (fPhraseCount < 1)
				PostMessage(B_QUIT_REQUESTED);
			break;
		}
		default:
			BApplication::MessageReceived(msg);
			break;
	}
}

int main()
{
	// create and run the application!
	Rephrase app;
	return app.Run();
}
