/* Rephrase.cpp */

#include "Rephrase.h"
#include "pDisplay.h"

#include <interface/Alert.h>
#include <storage/Path.h>
#include <support/String.h>
#include <storage/Entry.h>

#include <string.h>
#include <stdio.h>

Rephrase::Rephrase() :
	BApplication("application/x.vnd-BeDTS-Rephrase")
{
	// no basic initialization
}


Rephrase::~Rephrase()
{
	// no cleanup
}

void 
Rephrase::ReadyToRun()
{
	// create a window to edit phrases if none exists
	if (CountWindows() == 0)
	{
		new pDisplay();
	}
}

void 
Rephrase::AboutRequested()
{
	// display a simple about box
	BString aboutString;
	aboutString = "Rephrase ";
	aboutString << vMajor;
	aboutString += ".";
	aboutString << vMinor;
	if (vState != NULL)
	{
		aboutString += vState;
		aboutString << vNum;
	}	
	aboutString += "\nwritten by hippo\n\n"
					"Type in your phrases.\n"
					"Save them by selecting text and dragging\n"
					"to the Desktop or a folder.\n"
					"Import text by dragging a text file to the window.\n";

	BAlert *about = new BAlert("About Rephrase", aboutString.String(), "Dismiss");
	about->Go(NULL);
}

void 
Rephrase::ArgvReceived(int32 argc, char **argv)
{
	// the first argument is the application name
	// the second and beyond are files to open
	BEntry entry;
	entry_ref ref;
	bool goodRef = false;
	BMessage msg(B_REFS_RECEIVED);
	for (int ix = 1; ix < argc; ix++)
	{
		// set the entry to the specified path
		entry.SetTo(argv[ix]);
		// if a file exists at that location,
		//get its entry ref and add it to the message
		if (entry.Exists())
		{
			entry.GetRef(&ref);
			if (msg.AddRef("refs", &ref) == B_OK)
				goodRef = true;
		}
	}
	// if we have at least one good ref in the message, pass it
	// to RefsReceived() for processing
	if (goodRef)
		RefsReceived(&msg);
}

void 
Rephrase::RefsReceived(BMessage *msg)
{
	// find the number of refs in the message
	int32 count = 0;
	type_code type;
	status_t status = msg->GetInfo("refs", &type, &count);
	if (status != B_OK || type != B_REF_TYPE || count == 0)
		// there are no valid refs in this message
		return;
	
	// open a new phrase editing window for each ref
	entry_ref ref;
	for (int32 ix = 0; ix < count; ix++)
	{
		if (msg->FindRef("refs", ix, &ref) == B_OK)
		{
			// don't open windows right on top of each other
			new pDisplay(&ref);
		} 
	}
}

int main()
{
	// create and run the application!
	Rephrase app;
	return app.Run();
}
