
#include "pDisplay.h"

#include <app/Application.h>
#include <interface/TextView.h>
#include <interface/Menu.h>
#include <interface/MenuBar.h>
#include <interface/MenuItem.h>

#include <stdio.h>

pDisplay::pDisplay() :
	BWindow(BRect(100,100,349,249), "Rephrase", B_TITLED_WINDOW_LOOK,
		B_NORMAL_WINDOW_FEEL, B_NOT_ZOOMABLE | B_NOT_RESIZABLE)
{
	BRect bounds = Bounds();

	// build a menu bar
	BMenuBar *mBar = new BMenuBar(bounds, "MainMenu");
	// build the File menu
	BMenu *menu = new BMenu("File");
	BMenuItem *aboutItem = new BMenuItem("About Rephrase", new BMessage(B_ABOUT_REQUESTED));
	menu->AddItem(aboutItem);
	menu->AddItem(new BSeparatorItem);
	menu->AddItem(new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q', B_COMMAND_KEY));
	mBar->AddItem(menu);
	//build the Edit menu
	BMenu *editMenu = new BMenu("Edit");
	editMenu->AddItem(new BMenuItem("Cut", new BMessage(B_CUT), 'X', B_COMMAND_KEY));
	editMenu->AddItem(new BMenuItem("Copy", new BMessage(B_COPY), 'C', B_COMMAND_KEY));
	editMenu->AddItem(new BMenuItem("Paste", new BMessage(B_PASTE), 'V', B_COMMAND_KEY));
	editMenu->AddItem(new BSeparatorItem);
	editMenu->AddItem(new BMenuItem("Select All", new BMessage(B_SELECT_ALL), 'A', B_COMMAND_KEY));
	mBar->AddItem(editMenu);
	AddChild(mBar);

	// leave room for the menu bar
	bounds.top += mBar->Frame().Height();
	// inset the text by 4 in the text view's coordinate space
	BRect text(bounds);
	text.OffsetTo(B_ORIGIN);
	text.InsetBy(4,4);
	BTextView *edit = new BTextView(bounds, "EditPhrase", text, B_FOLLOW_ALL_SIDES);	
	AddChild(edit);

	// make sure the text view is the focus so it receives keyboard input
	edit->MakeFocus();
	// target the menu items correctly
	aboutItem->SetTarget(be_app);
	editMenu->SetTargetForItems(edit);
}


pDisplay::~pDisplay()
{
	// no cleanup
	// note that BWindow will clean up all of its children
	// automatically for us.  There is no need (and it will cause problems)
	// if you delete the menu bar, menus, menu items or text view created
	// in the constructor.  This is why we do not stash
	// any pointers to these items in the class
}

bool 
pDisplay::QuitRequested()
{
	// we are the only window so tell the app to quit
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}
