/* Rephrase.cpp */

#include "Rephrase.h"
#include "pDisplay.h"

#include <interface/Alert.h>
#include <support/String.h>

Rephrase::Rephrase() :
	BApplication("application/x.vnd-BeDTS-Rephrase")
{
	// no basic initialization
}


Rephrase::~Rephrase()
{
	// no cleanup
}

void 
Rephrase::ReadyToRun()
{
	// create and show a window to edit phrases
	pDisplay *dis = new pDisplay;
	dis->Show();
}

void 
Rephrase::AboutRequested()
{
	// display a simple about box
	BString aboutString;
	aboutString = "Rephrase ";
	aboutString << vMajor;
	aboutString += ".";
	aboutString << vMinor;
	if (vState != NULL)
	{
		aboutString += vState;
		aboutString << vNum;
	}	
	aboutString += "\nwritten by hippo\n\n"
					"Type in your phrases.\n"
					"Save them by selecting text and dragging\n"
					"to the Desktop or a folder.\n"
					"Import text by dragging a text file to the window.\n";

	BAlert *about = new BAlert("About Rephrase", aboutString.String(), "Dismiss");
	about->Go(NULL);
}


int main()
{
	// create and run the application!
	Rephrase app;
	return app.Run();
}
