/*
**	Copyright 2000 Be Incorporated. All Rights Reserved.
**	This file may be used under the terms of the Be Sample Code 
**	License.
*/

#include "ToolBar.h"

/* internal Toolbar constants */
const float buttonWidth = 18; //16x16 icon w/ 1-pixel border on each side
const float buttonHeight = 18;

const float topInset = 2;    //dist from top border
const float bottomInset = 2; //dist from bottom border
const float leftInset = 2;   //dist from left border
const float buttonDelta = 3; //horizontal dist between buttons

ToolBar::ToolBar(BRect barRect, char *name) :
		BView(BRect(barRect.left, barRect.top, barRect.right+1, barRect.top+22), name,
			B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP, B_WILL_DRAW)
{
}

/********************************/

void
ToolBar::AttachedToWindow()
{
	SetViewColor(210, 210, 210);
	InitPrivateButtons();
}

/********************************/

void
ToolBar::Draw(BRect drawRect)
{
	BRect b = Bounds();

	SetHighColor(240, 240, 240);
	StrokeLine(b.LeftBottom(), b.LeftTop());
	StrokeLine(b.LeftTop(), b.RightTop());

	SetHighColor(152, 152, 152);
	StrokeLine(b.RightTop(), b.RightBottom());
	StrokeLine(b.RightBottom(), b.LeftBottom());
	
	b.bottom -= 1;
	b.right -= 1;

	SetHighColor(184, 184, 184);
	StrokeLine(b.RightBottom(), b.LeftBottom());

	SetHighColor(210, 210, 210);
	StrokeLine(b.LeftBottom(), b.LeftBottom());
}

/********************************/

void 
ToolBar::InitPrivateButtons()
{
	BRect newButtonBounds = Bounds();
	newButtonBounds.top = newButtonBounds.top + topInset;
	newButtonBounds.left = newButtonBounds.left + leftInset;
	newButtonBounds.bottom = newButtonBounds.bottom - bottomInset;
	newButtonBounds.right = leftInset + buttonWidth;

	ButtCon	*addButton;

	addButton = new ButtCon(newButtonBounds, "Save Button", new BMessage(TOOLBAR_SAVE_MSG));
	AddChild(addButton);	
	newButtonBounds.left += addButton->Bounds().Width() + buttonDelta;

	AddChild(new ButtCon(newButtonBounds, "Save Button", new BMessage(TOOLBAR_SAVE_MSG)));	
}

/********************************/

const unsigned char kExampleNormalBits []= {
	0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1C,
	0x1F,0x1E,0x1E,0x1E,0x1E,0x1E,0x16,0x00,0x00,0x16,0x1E,0x1E,0x1E,0x1E,0x1C,0x17,
	0x1F,0x1E,0x1E,0x1C,0x1C,0x1C,0x00,0x1E,0x1E,0x00,0x1C,0x1C,0x1C,0x1C,0x1A,0x17,
	0x1F,0x1E,0x15,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x15,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x00,0x1E,0x1D,0x1E,0x1E,0x1E,0x1E,0x00,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x00,0x1E,0x1E,0x1E,0x1E,0x1D,0x1E,0x00,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1E,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1A,0x17,
	0x1F,0x1C,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x17,0x17,
	0x1C,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x15
};

const unsigned char kExamplePressedBits []= {
	0x15,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1C,
	0x17,0x17,0x1A,0x1A,0x1A,0x1A,0x16,0x00,0x00,0x15,0x1A,0x1A,0x1A,0x1A,0x1C,0x1F,
	0x17,0x1A,0x1B,0x1C,0x1C,0x1C,0x00,0x1E,0x1E,0x00,0x1C,0x1C,0x1C,0x1C,0x1E,0x1F,
	0x17,0x1A,0x16,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x16,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x00,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x00,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x00,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x00,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x00,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x00,0x1E,0x1F,
	0x17,0x1A,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x1E,0x1F,
	0x1C,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F
};
/********************************/

ButtCon::ButtCon(BRect frame, const char *name, BMessage *message)
	: BButton(BRect(frame.left, frame.top, frame.left+buttonWidth-1, frame.top+buttonHeight-1), name, name, message, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	fKeyCap = new BBitmap(BRect(0,0,15,15), B_RGB_32_BIT);
	fKeyCap->SetBits(kExampleNormalBits, sizeof(kExampleNormalBits), 0, B_COLOR_8_BIT);
	
	fPressedKeyCap = new BBitmap(BRect(0,0,15,15), B_RGB_32_BIT);
	fPressedKeyCap->SetBits(kExamplePressedBits, sizeof(kExamplePressedBits), 0, B_COLOR_8_BIT);
	ResizeTo(buttonWidth-1,buttonHeight-1);
}

/********************************/

ButtCon::~ButtCon()
{
	delete fKeyCap;
	delete fPressedKeyCap;
}

/********************************/

void 
ButtCon::AttachedToWindow()
{
}

/********************************/

void 
ButtCon::Draw(BRect dRect)
{
	SetHighColor(48,48,48,0);
	StrokeLine(Bounds().LeftTop()	+BPoint(1,0),	Bounds().RightTop()		+BPoint(-1,0));
	StrokeLine(Bounds().LeftBottom()+BPoint(1,0),	Bounds().RightBottom()	+BPoint(-1,0));

	StrokeLine(Bounds().LeftTop()	+BPoint(0,1),	Bounds().LeftBottom()	+BPoint(0,-1));
	StrokeLine(Bounds().RightTop()	+BPoint(0,1),	Bounds().RightBottom()	+BPoint(0,-1));
	
	BRect bitBounds = Bounds();
	bitBounds.InsetBy(1,1);
	if (Value() == 0) {
		DrawBitmap(fKeyCap, bitBounds);
	} else {
		DrawBitmap(fPressedKeyCap, bitBounds);
	}
}



