/* dInfoView */

#pragma once

#include "Defs.h"
#include <View.h>

struct stat;
class BDirectory;
class BList;

class dInfoView : public BView {
	public:
							dInfoView(entry_ref &ref, struct stat &st, BDirectory &dir);
							~dInfoView();
	
		status_t			InitCheck();
	
		void				MessageReceived(BMessage *msg);
		void				Draw(BRect updateRect);
		
		char *				GetName();
		
	private:
	
		void				TraverseDirectory(BDirectory &dir);
		void				EvaluateRef(entry_ref &ref);
		
		status_t			fStatus;
		entry_ref			fRef;
		char *				fNameStr;
		char *				fPathStr;
		char *				fCreateStr;
		char *				fModStr;

		BList *				fIndexList;

		int32				fEntryCount;
		int32				fSubDirCount;
		int32				fLinkCount;
		int32				fFileCount;
		int32				fIndexed;
		int32				fPartialIndexed;
		int32				fNotIndexed;
		int32				fInvalidCount;
};