//****************************************
// effectaddon.c
//****************************************
/*
	Copyright 2000, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#include "effect.h"
#include "BitmapButton.h"
#include "ResourceSet.h"

#include <Locker.h>
#include <TranslatorFormats.h>

//****************************************

static int32 gResourcesCreated = 0;
static BResourceSet gResources;

static BResourceSet& Resources()
{
	// Return the BResourceSet object for this image, initializing
	// if needed.
	if ((gResourcesCreated&2) != 0) {
		// Quick return if already initialized.
		return gResources;
	} else if (atomic_or(&gResourcesCreated, 1) == 0) {
		// Not yet initialized -- do so.
		gResources.AddResources(&gResourcesCreated);
		// Mark that we are done.
		atomic_or(&gResourcesCreated, 2);
	} else {
		// Wait for resources to be initialized.
		while ((gResourcesCreated&2) == 0) snooze(50000);
	}
	return gResources;
}

//****************************************

class myEffect : public Effect
{
public:
	//operations
	virtual BView*		Generate() {
		const BBitmap* bm = Resources().FindBitmap(B_PNG_FORMAT, "BeOS Logo");
		return new BBitmapButton(BRect(0, 0, 10, 10), "button",
								 "Effect", new BMessage('blah'), bm);
	}
};

//****************************************

extern "C" _EXPORT Effect* NewEffect( );

//****************************************

Effect* NewEffect( )
{
	return new myEffect;
}
