#ifndef LIST_H
#define LIST_H

#include<assert.h>

template <class AType> class ALinkOf
{
public:
				ALinkOf(AType aValue, ALinkOf<AType> * nextLink);


		ALinkOf<AType>	*	Insert(AType aValue);

		ALinkOf<AType> *	Copy();

		AType	fValue;
		ALinkOf<AType> *	fNextLink;

protected:
private:
};

template <class AType> class AListOf
{
public:
				AListOf();
				AListOf(const AListOf<AType>& other);
	virtual	~AListOf();

	virtual	void	Add(AType aValue);
	virtual	void	DeleteAll();
				AType	FirstElement() const;
	virtual	int	Includes(const AType& aValue) const;
				int	IsEmpty() const;
	virtual	void	RemoveFirst();

	ALinkOf<AType>*	fFirstLink;

protected:

private:
};


//===================================================
// Implementation
//===================================================

//===================================================
// Implementation: ALinkOf
//===================================================
template <class AType>
ALinkOf<AType>::ALinkOf(AType aValue, ALinkOf<AType>* nextLink)
	: fValue(aValue),
	fNextLink(nextLink)
{
}

template <class AType>
ALinkOf<AType> *
ALinkOf<AType>::Insert(AType aValue)
{
	fNextLink = new ALinkOf<AType>(aValue, fNextLink);
	assert(fNextLink != 0);

	return fNextLink;
}

template <class AType>
ALinkOf<AType> *
ALinkOf<AType>::Copy()
{
	ALinkOf<AType> * newLink;

	if (fNextLink != 0)
		newLink = new ALinkOf<AType>(fValue, fNextLink->Copy());
	else
		newLink = new ALinkOf<AType>(fValue, 0);

	assert(newLink != 0);

	return newLink;
}

//===================================================
// Implementation: AListOf
//===================================================
template <class AType>
AListOf<AType>::AListOf()
	: fFirstLink(0)
{

}

template <class AType>
AListOf<AType>::AListOf(const AListOf<AType>& other)
{
	if (other.IsEmpty())
	{
		fFirstLink = 0;
	} else
	{
		fFirstLink = other.fFirstLink->Copy();
	}
}

template <class AType>
void
AListOf<AType>::Add(AType aValue)
{
	fFirstLink = new ALinkOf<AType>(aValue,fFirstLink);
	assert(fFirstLink!=0);
}

template <class AType>
int
AListOf<AType>::IsEmpty() const
{
	return fFirstLink == 0;
}

template <class AType>
AType
AListOf<AType>::FirstElement() const
{
	assert(fFirstLink != 0);
	return fFirstLink->fValue;
}

template <class AType>
void
AListOf<AType>::RemoveFirst()
{
	assert(fFirstLink != 0);

	ALinkOf<AType> * tmpPtr = fFirstLink;

	fFirstLink = tmpPtr->fNextLink;

	delete tmpPtr;
}

template <class AType>
int
AListOf<AType>::Includes(const AType& aValue) const
{
	for (ALinkOf<AType> * aLink = fFirstLink; aLink; aLink = aLink->fNextLink)
	{
		if (aValue == aLink->fValue)
			return 1;
	}

	// The value wasn't found, so return 0 (false);
	return 0;
}

template <class AType>
AListOf<AType>::~AListOf()
{
	DeleteAll();
}

template <class AType>
void
AListOf<AType>::DeleteAll()
{
	ALinkOf<AType> * nextLink;
	for (ALinkOf<AType> * aLink = fFirstLink; aLink != 0; aLink = nextLink)
	{
		nextLink = aLink->fNextLink;
		aLink->fNextLink = 0;
		delete aLink;
	}

	fFirstLink = 0;
}

#endif
