#ifndef ITERATE_H
#define ITERATE_H

//===========================================
// File: iterator.h
//
// Contains interfaces for iterator classes
//===========================================


//===========================================
// Class: PIteratorOver
// The Protocol class for iterators
//===========================================
template<class AType> class PIteratorOver
{
public:
			virtual	long	Initialize() = 0;
			virtual	long	operator !() = 0;
			virtual	AType	operator()()=	0;
			virtual	long	operator++() = 0;
			virtual	void	operator=(const AType& newValue) = 0;

protected:

private:
};

//===========================================
// Class Template: ASequenceIterator
// The concrete template class implementation of PIteratorOver
//===========================================
template<class AType> class ASequenceIterator : public PIteratorOver<AType>
{
public:
				ASequenceIterator(ASequenceOf<AType>& aSequence);

				// Implement the PIteratorOver protocol
			virtual	long	Initialize();
			virtual	long	operator !();
			virtual	AType	operator()();
			virtual	long	operator++();
			virtual	void	operator=(const AType& newValue);

			// Sequence Iterators have these specifics
			long				operator--();
			unsigned long	Key();

protected:
			unsigned long			fCurrentKey;
			ASequenceOf<AType>&	fData;

private:

};

//===========================================
// Class Template: ASequenceIterator
// Implementations
//===========================================

template <class AType>
ASequenceIterator(ASequenceOf<AType>& aSequence)
	: fData(aSequence)
{
	Initialize();
}

// Implement the PIteratorOver protocol
template <class AType>
long
ASequenceIterator::Initialize()
{
	fCurrentKey = 0;
	return operator !();
}


template <class AType>
long
ASequenceIterator::operator !()
{
	return currentKey < fData.Length();
}


template <class AType>
AType
ASequenceIterator::operator()()
{
	return fData[fCurrentKey];
}


template <class AType>
long
ASequenceIterator::operator++()
{
	fCurrentKey++;
	return operator!();
}


template <class AType>
void
ASequenceIterator::operator=(const AType& newValue)
{
	fData[fCurrentKey] = newValue;
}


			// Sequence Iterators have these specifics
template <class AType>
long
ASequenceIterator::ASequenceIterator::operator--()
{
	if (fCurrentKey > 0)
		fCurrentKey--;
	return operator!();
}

template <class AType>
unsigned long
ASequenceIterator::ASequenceIterator::Key()
{
	return fCurrentKey();
}


#endif
