#include "charset.h"

ACharSet::ACharSet()
	: ABitSequence(256)
{
}

ACharSet::ACharSet(const char *initialValue)
	: ABitSequence(256)
{
	while (*initialValue)
   		Add(*initialValue++);
}

ACharSet::ACharSet(const ACharSet& other)
	: ABitSequence(other)
{
}

void
ACharSet::Add(const char aChar)
{
	Set((unsigned long)aChar);
}

void
ACharSet::DeleteAll()
{
}

int
ACharSet::Includes(const char aChar) const
{
	return IsSet((unsigned long)aChar);
}

void
ACharSet::Subtract(const char aChar)
{
	Clear((unsigned long)aChar);
}

