/* $Id: fxmesa.h,v 1.6 1997/06/26 14:28:42 brianp Exp $ */

/*
 * Mesa 3-D graphics library
 * Version:  2.3
 * Copyright (C) 1995-1997  Brian Paul
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * $Log: fxmesa.h,v $
 * Revision 1.6  1997/06/26 14:28:42  brianp
 * set USE_GLIDE_FULLSCREEN by testing for __WIN32__
 *
 * Revision 1.5  1997/06/20 03:34:56  brianp
 * added attribList parameter to fxMesaCreateContext()
 * added FXMESA_* symbols
 *
 * Revision 1.4  1997/06/18 02:31:05  brianp
 * added comment about the USE_GLIDE_FULLSCREEN symbol
 *
 * Revision 1.3  1997/06/18 02:28:25  brianp
 * many changes for Linux support and 3Dfx Rush support
 *
 * Revision 1.2  1997/05/28 03:50:17  brianp
 * added FXMESA_MAJOR/MINOR_VERSION symbols
 *
 * Revision 1.1  1997/05/14 03:29:25  brianp
 * Initial revision
 *
 */


/*
 * FXMesa - 3Dfx Glide driver for Mesa.  Contributed by David Bucciarelli
 */


#ifndef FXMESA_H
#define FXMESA_H


#include <glide.h>
#include "GL/gl.h"

#ifdef __BEOS__
#pragma export on
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define FXMESA_MAJOR_VERSION 2
#define FXMESA_MINOR_VERSION 3


/*
 * 0 = 3Dfx in a window (Rush chipset)
 * 1 = 3Dfx full-screen (Voodoo chipset)
 */
#ifdef __WIN32__
#define USE_GLIDE_FULLSCREEN 0
#else
#define USE_GLIDE_FULLSCREEN 1
#endif


/*
 * Values for attribList parameter to fxMesaCreateContext():
 */
#define FXMESA_NONE		0	/* to terminate attribList */
#define FXMESA_DOUBLEBUFFER	10
#define FXMESA_ALPHA_SIZE	11      /* followed by an integer */
#define FXMESA_DEPTH_SIZE	12      /* followed by an integer */
#define FXMESA_STENCIL_SIZE	13      /* followed by an integer */
#define FXMESA_ACCUM_SIZE	14      /* followed by an integer */



typedef struct fx_mesa_context *fxMesaContext;


extern fxMesaContext fxMesaCreateContext(GLuint win, GrScreenResolution_t,
                                         GrScreenRefresh_t,
                                         const GLint attribList[]);

extern fxMesaContext fxMesaCreateBestContext(GLuint win,
                                             GLint width, GLint height,
                                             const GLint attribList[]);

extern void fxMesaDestroyContext(fxMesaContext ctx);

extern void fxMesaMakeCurrent(fxMesaContext ctx);

extern fxMesaContext fxMesaGetCurrentContext( void );

extern void fxMesaSwapBuffers(void);

extern void fxMesaSetNearFar(GLfloat nearVal, GLfloat farVal);


#ifdef __cplusplus
}
#endif

#ifdef __BEOS__
#pragma export reset
#endif

#endif
