/*
 * Copyright (C) 1997 Be, Inc.  All Rights Reserved
 */
#include <NetDevice.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <OS.h>
#include <NetProtocol.h>
#include <string.h>
#include <stdio.h>
#include "EtherGrabber.h"
#include "EtherGrabber.h"

const char* kEtherFile = "/boot/EthernetAddresses.out";

#pragma export on
BNetProtocol*
open_protocol(const char *device)
{
        EtherGrabber *dev;
        thread_id tid;

        dev = new EtherGrabber();
        return (dev);
}
#pragma export off

EtherGrabber::EtherGrabber() : BNetProtocol()
{
	// Truncate the file each time we load.
	FILE* fd = fopen(kEtherFile, "w");
	fclose(fd);
	return;	
}
 
void 
EtherGrabber::AddDevice(BNetDevice* dev, const char* name)
{
	// If the device is an ethernet device, get its address
	// and write it into a file.
	if (dev->Type() == B_ETHER_NET_DEVICE)
	{
		// 48-bit ethernet address
		char ethAddress[6];
		FILE* fd = fopen(kEtherFile, "a+");
		dev->Address(ethAddress);
		fwrite(ethAddress, sizeof(ethAddress), 1, fd);
		fclose(fd);
	}
}
