//--------------------------------------------------------------------
//	
//	Header.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#pragma once
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Mail.h"
#include "Header.h"


//====================================================================

THeaderView::THeaderView(BRect rect, BRect wind_rect, bool incoming,
						 BFile *file, bool resending)
			:BBox(rect, "m_header", B_FOLLOW_NONE, B_WILL_DRAW)
{
	char		string[20];
	float		offset;
	BFont		font = *be_plain_font;
	BRect		r;
	rgb_color	c;

	fIncoming = incoming;
	fFile = file;

	c.red = c.green = c.blue = VIEW_COLOR;
	SetViewColor(c);
	font.SetSize(FONT_SIZE);
	SetFont(&font);
	offset = font.StringWidth("Enclosures: ") + 12;

	if ((fIncoming) && (!resending)) {
		r.Set(offset - font.StringWidth(FROM_TEXT) - 11, TO_FIELD_V,
			  wind_rect.Width() - SEPERATOR_MARGIN,
			  TO_FIELD_V + TO_FIELD_HEIGHT);
			sprintf(string, FROM_TEXT);
	}
	else {
		r.Set(offset - font.StringWidth(TO_TEXT) - 11, TO_FIELD_V,
			  wind_rect.Width() - SEPERATOR_MARGIN,
			  TO_FIELD_V + TO_FIELD_HEIGHT);
		sprintf(string, TO_TEXT);
	}
	fTo = new TTextControl(r, string, new BMessage(TO_FIELD),
											fIncoming, fFile, resending);
	AddChild(fTo);

	r.left = offset - font.StringWidth(SUBJECT_TEXT) - 11;
	r.top = SUBJECT_FIELD_V;
	r.bottom = SUBJECT_FIELD_V + SUBJECT_FIELD_HEIGHT;
	fSubject = new TTextControl(r, SUBJECT_TEXT, new BMessage(SUBJECT_FIELD),
											fIncoming, fFile, FALSE);
	AddChild(fSubject);

	if (!fIncoming) {
		r.Set(offset - font.StringWidth(CC_TEXT) - 11, CC_FIELD_V,
			  CC_FIELD_H + CC_FIELD_WIDTH,
			  CC_FIELD_V + CC_FIELD_HEIGHT);
		fCc = new TTextControl(r, CC_TEXT, new BMessage(CC_FIELD),
											fIncoming, fFile, FALSE);
		AddChild(fCc);

		r.Set(BCC_FIELD_H, BCC_FIELD_V,
			  BCC_FIELD_H + BCC_FIELD_WIDTH + 1,
			  BCC_FIELD_V + BCC_FIELD_HEIGHT);
		fBcc = new TTextControl(r, BCC_TEXT, new BMessage(BCC_FIELD),
											fIncoming, fFile, FALSE);
		AddChild(fBcc);
	}
}

//--------------------------------------------------------------------

void THeaderView::MessageReceived(BMessage *msg)
{
	BMessage	*message;
	BTextView	*text_view;

	switch (msg->what) {
		case B_SIMPLE_DATA:
			text_view = (BTextView *)fTo->ChildAt(0);
			if (text_view->IsFocus())
				fTo->MessageReceived(msg);
			else if (!fIncoming) {
				text_view = (BTextView *)fCc->ChildAt(0);
				if (text_view->IsFocus())
					fCc->MessageReceived(msg);
				else {
					text_view = (BTextView *)fBcc->ChildAt(0);
					if (text_view->IsFocus())
						fBcc->MessageReceived(msg);
					else {
						message = new BMessage(msg);
						message->what = REFS_RECEIVED;
						Window()->PostMessage(message, Window());
						delete message;
					}
				}
			}
			break;
	}
}


//====================================================================

TTextControl::TTextControl(BRect rect, char *label, BMessage *msg,
						   bool incoming, BFile *file, bool resending)
			 :BTextControl(rect, "", label, "", msg, B_FOLLOW_NONE)
{
	strcpy(fLabel, label);
	fCommand = msg->what;
	fFile = file;
	fIncoming = incoming;
	fResending = resending;
}

//--------------------------------------------------------------------

void TTextControl::AttachedToWindow(void)
{
	char		*string;
	BFont		font = *be_plain_font;
	BTextView	*text;
	attr_info	info;

	SetHighColor(0, 0, 0);
	BTextControl::AttachedToWindow();
	font.SetSize(FONT_SIZE);
	SetFont(&font);

	SetDivider(StringWidth(fLabel) + 6);
	text = (BTextView *)ChildAt(0);
	text->SetFont(&font);

	if (fFile) {
		if ((fIncoming) && (!fResending))
			SetEnabled(FALSE);
		switch (fCommand) {
			case SUBJECT_FIELD:
				fFile->GetAttrInfo(B_MAIL_ATTR_SUBJECT, &info);
				string = (char *)malloc(info.size);
				fFile->ReadAttr(B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0, string, info.size);
				SetText(string);
				free(string);
				break;

			case TO_FIELD:
				fFile->GetAttrInfo(B_MAIL_ATTR_FROM, &info);
				string = (char *)malloc(info.size);
				fFile->ReadAttr(B_MAIL_ATTR_FROM, B_STRING_TYPE, 0, string, info.size);
				SetText(string);
				free(string);
				break;
		}
	}
}

//--------------------------------------------------------------------

void TTextControl::MessageReceived(BMessage *msg)
{
	bool		enclosure = FALSE;
	char		type[B_FILE_NAME_LENGTH];
	char		separator[4] = ", ";
	char		*name;
	int32		index = 0;
	int32		len;
	int32		result;
	entry_ref	ref;
	BFile		file;
	BMessage	message(REFS_RECEIVED);
	BNodeInfo	*node;
	BTextView	*text_view;
	attr_info	info;

	switch (msg->what) {
		case B_SIMPLE_DATA:
			if (!fIncoming) {
				while (msg->FindRef("refs", index++, &ref) == B_NO_ERROR) {
					file.SetTo(&ref, O_RDONLY);
					if (file.InitCheck() == B_NO_ERROR) {
						node = new BNodeInfo(&file);
						node->GetType(type);
						delete node;
						if ((fCommand != SUBJECT_FIELD) && (!strcmp(type, "application/x-person"))) {
							file.GetAttrInfo("META:email", &info);
							name = (char *)malloc(info.size);
							file.ReadAttr("META:email", B_STRING_TYPE, 0, name, info.size);
							if (strlen(name)) {
								text_view = (BTextView *)ChildAt(0);
								if (len = text_view->TextLength()) {
									text_view->Select(len, len);
									text_view->Insert(separator);
								}
								text_view->Insert(name);
							}
							free(name);
						}
						else {
							enclosure = TRUE;
							message.AddRef("refs", &ref);
						}
					}
				}
				if (enclosure)
					Window()->PostMessage(&message, Window());
			}
			break;

		case M_SELECT:
			text_view = (BTextView *)ChildAt(0);
			text_view->Select(0, text_view->TextLength());
			break;

		default:
			BTextControl::MessageReceived(msg);
	}
}
